/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParsingTestUtil {
    private static final String SEPARATOR = "---------------";
    private static final String NL_SEPARATOR_NL = "\n---------------\n";

    private ParsingTestUtil() {
    }

    public static void ensureNoErrorElementsInAllSubTrees(@NotNull PsiFile file2) {
        if (file2 == null) {
            ParsingTestUtil.$$$reportNull$$$0(0);
        }
        for (PsiFile subTree : file2.getViewProvider().getAllFiles()) {
            ParsingTestUtil.ensureNoErrorElements(subTree);
        }
    }

    public static void ensureNoErrorElements(final @NotNull PsiFile file2) {
        if (file2 == null) {
            ParsingTestUtil.$$$reportNull$$$0(1);
        }
        file2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            private static final int TAB_WIDTH = 8;

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                String text = file2.getText();
                String[] lines2 = StringUtil.splitByLinesKeepSeparators((String)text);
                int offset = element.getTextOffset();
                LineColumn position = StringUtil.offsetToLineColumn((CharSequence)text, (int)offset);
                int lineNumber = position != null ? position.line : -1;
                int column = position != null ? position.column : 0;
                String line = StringUtil.trimTrailing((String)lines2[lineNumber]);
                int numIndentTabs = StringUtil.countChars((CharSequence)line.subSequence(0, column), (char)'\t', (int)0, (boolean)true);
                int indentedColumn = column + numIndentTabs * 7;
                String lineWithNoTabs = StringUtil.repeat((String)" ", (int)(numIndentTabs * 8)) + line.substring(numIndentTabs).replace('\t', ' ');
                String errorUnderline = StringUtil.repeat((String)" ", (int)indentedColumn) + StringUtil.repeat((String)"^", (int)Math.max(1, element.getTextLength()));
                TestCase.fail((String)String.format("Unexpected error element: %s:%d:%d\n\n%s\n%s\n%s", file2.getName(), lineNumber + 1, column, lineWithNoTabs, errorUnderline, element.getErrorDescription()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/ParsingTestUtil$1", "visitErrorElement"));
            }
        });
    }

    @NotNull
    public static String psiFileToString(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ParsingTestUtil.$$$reportNull$$$0(2);
        }
        StringBuilder result = new StringBuilder();
        for (PsiFile subTree : psiFile.getViewProvider().getAllFiles()) {
            result.append("Language: ").append(subTree.getLanguage()).append("\n").append(DebugUtil.psiToString((PsiElement)subTree, (boolean)true, (boolean)false));
        }
        String string = result.toString();
        if (string == null) {
            ParsingTestUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void testIncrementalParsing(@NotNull PsiFile psiFile, @NotNull CharSequence newFileText, @NotNull String answersFilePath, boolean checkInitialTreeForErrors, boolean checkFinalTreeForErrors) {
        if (psiFile == null) {
            ParsingTestUtil.$$$reportNull$$$0(4);
        }
        if (newFileText == null) {
            ParsingTestUtil.$$$reportNull$$$0(5);
        }
        if (answersFilePath == null) {
            ParsingTestUtil.$$$reportNull$$$0(6);
        }
        if (checkInitialTreeForErrors) {
            ParsingTestUtil.ensureNoErrorElements(psiFile);
        }
        Project project2 = psiFile.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        Document fileDocument = psiDocumentManager.getDocument(psiFile);
        TestCase.assertNotNull((Object)fileDocument);
        psiDocumentManager.commitDocument(fileDocument);
        CharSequence originalText = fileDocument.getCharsSequence();
        StringBuilder result = new StringBuilder("Original text:").append(NL_SEPARATOR_NL).append(originalText).append(NL_SEPARATOR_NL);
        List allFiles = psiFile.getViewProvider().getAllFiles();
        ContainerUtil.sort((List)allFiles, Comparator.comparing(it -> it.getLanguage().getID()));
        for (PsiFile subTree : allFiles) {
            UsefulTestCase.assertInstanceOf(subTree, PsiFileImpl.class);
            PsiFileImpl subTreeFile = (PsiFileImpl)subTree;
            TextRange changedRange = ChangedPsiRangeUtil.getChangedPsiRange((PsiFile)subTreeFile, (FileElement)Objects.requireNonNull(subTreeFile.getTreeElement()), (CharSequence)newFileText);
            TestCase.assertNotNull((String)"No changes found", (Object)changedRange);
            Couple reparseableRoots = BlockSupportImpl.findReparseableRoots((PsiFileImpl)subTreeFile, (FileASTNode)subTree.getNode(), (TextRange)changedRange, (CharSequence)newFileText);
            result.append("Subtree: ").append(subTree.getLanguage()).append(NL_SEPARATOR_NL);
            ParsingTestUtil.serializeReparseableRoots((Couple<ASTNode>)reparseableRoots, result, newFileText);
            result.append(NL_SEPARATOR_NL);
        }
        WriteAction.run(() -> fileDocument.setText(newFileText));
        psiDocumentManager.commitDocument(fileDocument);
        String psiBeforeCommit = ParsingTestUtil.psiFileToString(psiFile);
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            fileDocument.setText((CharSequence)"");
            psiDocumentManager.commitDocument(fileDocument);
            fileDocument.setText(newFileText);
            psiDocumentManager.commitDocument(fileDocument);
        });
        TestCase.assertEquals((String)"Reparsing error", (String)ParsingTestUtil.psiFileToString(psiFile), (String)psiBeforeCommit);
        if (checkFinalTreeForErrors) {
            ParsingTestUtil.ensureNoErrorElementsInAllSubTrees(psiFile);
        }
        UsefulTestCase.assertSameLinesWithFile(answersFilePath, result.toString(), false);
    }

    private static void serializeReparseableRoots(@Nullable Couple<ASTNode> reparseableRoots, @NotNull StringBuilder result, @NotNull CharSequence newText) {
        if (result == null) {
            ParsingTestUtil.$$$reportNull$$$0(7);
        }
        if (newText == null) {
            ParsingTestUtil.$$$reportNull$$$0(8);
        }
        TextRange reparsedRange = reparseableRoots == null ? TextRange.create((int)0, (int)newText.length()) : TextRange.from((int)((ASTNode)reparseableRoots.first).getStartOffset(), (int)((ASTNode)reparseableRoots.second).getTextLength());
        result.append(newText, 0, reparsedRange.getStartOffset());
        result.append("<reparse>");
        result.append(newText, reparsedRange.getStartOffset(), reparsedRange.getEndOffset());
        result.append("</reparse>");
        result.append(newText, reparsedRange.getEndOffset(), newText.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ParsingTestUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answersFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ParsingTestUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "psiFileToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureNoErrorElementsInAllSubTrees";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "ensureNoErrorElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToString";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "testIncrementalParsing";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serializeReparseableRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

