/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.math.BigInteger;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversion;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversion$WhenMappings;
import org.jetbrains.kotlin.nj2k.conversions.RecursiveApplicableConversionBase;
import org.jetbrains.kotlin.nj2k.symbols.JKMethodSymbol;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentImpl;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentList;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpressionImpl;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\tH\u0002J\f\u0010\u000e\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\u000f\u001a\u00020\t*\u00020\tH\u0002J\u0014\u0010\u0010\u001a\u00020\t*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\t*\u00020\nH\u0002J\u0014\u0010\u0014\u001a\u00020\t*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\nH\u0002J\u0014\u0010\u0017\u001a\u00020\t*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0018\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u0019\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001a\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001b\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001c\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/LiteralConversion;", "Lorg/jetbrains/kotlin/nj2k/conversions/RecursiveApplicableConversionBase;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "cannotConvertLiteralMessage", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKLiteralExpression;", "createTodoCall", "Lorg/jetbrains/kotlin/nj2k/tree/JKCallExpressionImpl;", "message", "cleanFloatAndDoubleLiterals", "cleanIntAndLongLiterals", "convertBinaryLiteral", "isLongLiteral", "", "convertCharLiteral", "convertHexLiteral", "convertLiteral", "", "convertOctalLiteral", "toDoubleLiteral", "toFloatLiteral", "toIntLiteral", "toLongLiteral", "toStringLiteral", "kotlin.j2k.new"})
public final class LiteralConversion
extends RecursiveApplicableConversionBase {
    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element3) {
        JKTreeElement jKTreeElement;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3 instanceof JKLiteralExpression)) {
            return this.recurse(element3);
        }
        try {
            jKTreeElement = element3;
            JKLiteralExpression $this$apply = (JKLiteralExpression)jKTreeElement;
            boolean bl = false;
            this.convertLiteral($this$apply);
            jKTreeElement = (JKExpression)jKTreeElement;
        }
        catch (NumberFormatException numberFormatException) {
            jKTreeElement = this.createTodoCall(this.cannotConvertLiteralMessage((JKLiteralExpression)element3));
        }
        JKTreeElement convertedElement = jKTreeElement;
        return this.recurse(convertedElement);
    }

    private final JKCallExpressionImpl createTodoCall(@NonNls String message2) {
        JKMethodSymbol todoMethodSymbol = this.getSymbolProvider().provideMethodSymbol("kotlin.TODO");
        JKArgumentImpl todoMessageArgument = new JKArgumentImpl(new JKLiteralExpression("\"" + message2 + "\"", JKLiteralExpression.LiteralType.STRING, null, 4, null));
        return new JKCallExpressionImpl(todoMethodSymbol, new JKArgumentList(todoMessageArgument), null, null, 12, null);
    }

    private final String cannotConvertLiteralMessage(JKLiteralExpression element3) {
        String string = element3.getType().toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        String string2 = string.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        String literalType = string2;
        String literalValue = element3.getLiteral();
        return "Could not convert " + literalType + " literal '" + literalValue + "' to Kotlin";
    }

    private final void convertLiteral(JKLiteralExpression $this$convertLiteral) {
        String string;
        switch (LiteralConversion$WhenMappings.$EnumSwitchMapping$0[$this$convertLiteral.getType().ordinal()]) {
            case 1: {
                string = this.toDoubleLiteral($this$convertLiteral);
                break;
            }
            case 2: {
                string = this.toFloatLiteral($this$convertLiteral);
                break;
            }
            case 3: {
                string = this.toLongLiteral($this$convertLiteral);
                break;
            }
            case 4: {
                string = this.toIntLiteral($this$convertLiteral);
                break;
            }
            case 5: {
                string = this.convertCharLiteral($this$convertLiteral);
                break;
            }
            case 6: {
                string = this.toStringLiteral($this$convertLiteral);
                break;
            }
            default: {
                return;
            }
        }
        $this$convertLiteral.setLiteral(string);
    }

    /*
     * WARNING - void declaration
     */
    private final String toDoubleLiteral(JKLiteralExpression $this$toDoubleLiteral) {
        void var3_3;
        String string;
        String text2 = string = this.cleanFloatAndDoubleLiterals($this$toDoubleLiteral.getLiteral());
        boolean bl = false;
        text2 = string = !StringsKt.contains$default((CharSequence)text2, (CharSequence)".", (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)text2, (CharSequence)"e", (boolean)true) ? text2 + "." : text2;
        boolean bl2 = false;
        return StringsKt.endsWith$default((String)text2, (String)".", (boolean)false, (int)2, null) ? text2 + "0" : var3_3;
    }

    private final String toFloatLiteral(JKLiteralExpression $this$toFloatLiteral) {
        String string;
        String text2 = string = this.cleanFloatAndDoubleLiterals($this$toFloatLiteral.getLiteral());
        boolean bl = false;
        return !StringsKt.endsWith$default((String)text2, (String)"f", (boolean)false, (int)2, null) ? text2 + "f" : text2;
    }

    private final String toStringLiteral(JKLiteralExpression $this$toStringLiteral) {
        CharSequence charSequence = $this$toStringLiteral.getLiteral();
        String string = "(\\\\*)\\\\([0-3]?[0-7]{1,2})";
        string = new Regex(string);
        Object object = toStringLiteral.1.INSTANCE;
        charSequence = string.replace(charSequence, object);
        string = "\\$([A-Za-z]+|\\{)";
        string = new Regex(string);
        object = "\\\\$0";
        return StringsKt.replace$default((String)string.replace(charSequence, (String)object), (String)"\\f", (String)"\\u000c", (boolean)false, (int)4, null);
    }

    private final String convertCharLiteral(JKLiteralExpression $this$convertCharLiteral) {
        CharSequence charSequence = $this$convertCharLiteral.getLiteral();
        String string = "\\\\([0-3]?[0-7]{1,2})";
        string = new Regex(string);
        Function1 function1 = convertCharLiteral.1.INSTANCE;
        return string.replace(charSequence, function1);
    }

    private final String toIntLiteral(JKLiteralExpression $this$toIntLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toIntLiteral.getLiteral()), false), false), false);
    }

    private final String toLongLiteral(JKLiteralExpression $this$toLongLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toLongLiteral.getLiteral()), true), true), true) + "L";
    }

    private final String convertHexLiteral(String $this$convertHexLiteral, boolean isLongLiteral) {
        Object object;
        if (!StringsKt.startsWith((String)$this$convertHexLiteral, (String)"0x", (boolean)true)) {
            return $this$convertHexLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertHexLiteral, (int)2), 16);
        if (isLongLiteral && value2.bitLength() > 63) {
            long l = value2.longValue();
            int n = 16;
            String string = Long.toString(l, CharsKt.checkRadix((int)n));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String string2 = string;
            int n2 = 1;
            String string3 = string2.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            object = "-0x" + string3;
        } else if (!isLongLiteral && value2.bitLength() > 31) {
            int n = value2.intValue();
            int n3 = 16;
            String string = Integer.toString(n, CharsKt.checkRadix((int)n3));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String string4 = string;
            n3 = 1;
            String string5 = string4.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            object = "-0x" + string5;
        } else {
            object = $this$convertHexLiteral;
        }
        return object;
    }

    private final String convertBinaryLiteral(String $this$convertBinaryLiteral, boolean isLongLiteral) {
        String string;
        if (!StringsKt.startsWith((String)$this$convertBinaryLiteral, (String)"0b", (boolean)true)) {
            return $this$convertBinaryLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertBinaryLiteral, (int)2), 2);
        if (isLongLiteral) {
            long l = value2.longValue();
            int n = 10;
            String string2 = Long.toString(l, CharsKt.checkRadix((int)n));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        } else {
            string = String.valueOf(value2.intValue());
        }
        return string;
    }

    private final String convertOctalLiteral(String $this$convertOctalLiteral, boolean isLongLiteral) {
        String string;
        char c;
        if (!StringsKt.startsWith$default((String)$this$convertOctalLiteral, (String)"0", (boolean)false, (int)2, null) || $this$convertOctalLiteral.length() == 1 || Character.toLowerCase(c = $this$convertOctalLiteral.charAt(1)) == 'x') {
            return $this$convertOctalLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertOctalLiteral, (int)1), 8);
        if (isLongLiteral) {
            long l = value2.longValue();
            int n = 10;
            String string2 = Long.toString(l, CharsKt.checkRadix((int)n));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        } else {
            int n = value2.intValue();
            int n2 = 10;
            String string3 = Integer.toString(n, CharsKt.checkRadix((int)n2));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        }
        return string;
    }

    private final String cleanFloatAndDoubleLiterals(String $this$cleanFloatAndDoubleLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)$this$cleanFloatAndDoubleLiterals, (String)"L", (String)"", (boolean)true), (String)"d", (String)"", (boolean)true), (String)".e", (String)"e", (boolean)true), (String)".f", (String)"", (boolean)true), (String)"f", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    private final String cleanIntAndLongLiterals(String $this$cleanIntAndLongLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)$this$cleanIntAndLongLiterals, (String)"l", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    public LiteralConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }
}

