/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.script.configuration;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.script.configuration.KotlinScriptDefinitionsModel;
import org.jetbrains.kotlin.idea.script.configuration.ModelDescriptor;
import org.jetbrains.kotlin.idea.script.configuration.ScriptingSupportSpecificSettingsProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

public class KotlinScriptingSettingsConfigurable
implements SearchableConfigurable {
    public static final String ID = "preferences.language.Kotlin.scripting";
    private JPanel root;
    private JPanel panelScriptDefinitionsChooser;
    private JPanel additionalSettingsPanel;
    private final List<UnnamedConfigurable> scriptingSupportSettingsConfigurables;
    private final KotlinScriptDefinitionsModel model;
    private final Project project;
    private final ScriptDefinitionsManager manager;
    private final KotlinScriptingSettings settings;

    public KotlinScriptingSettingsConfigurable(Project project2) {
        this.$$$setupUI$$$();
        this.scriptingSupportSettingsConfigurables = new ArrayList<UnnamedConfigurable>();
        this.project = project2;
        this.manager = ScriptDefinitionsManager.Companion.getInstance(project2);
        this.settings = KotlinScriptingSettings.Companion.getInstance(project2);
        this.model = KotlinScriptDefinitionsModel.Companion.createModel(this.manager.getAllDefinitions(), this.settings);
    }

    @Nullable
    public JComponent createComponent() {
        this.panelScriptDefinitionsChooser.setLayout((LayoutManager)new VerticalLayout(0));
        this.panelScriptDefinitionsChooser.add((Component)new TitledSeparator(KotlinBundle.message("kotlin.script.definitions.title", new Object[0])));
        JLabel commentLabel2 = new JLabel(KotlinBundle.message("kotlin.script.definitions.model.name.autoReloadScriptDependencies.description", new Object[0]));
        commentLabel2.setForeground(UIUtil.getContextHelpForeground());
        this.panelScriptDefinitionsChooser.add(commentLabel2);
        TableView table = new TableView((ListTableModel)this.model);
        this.panelScriptDefinitionsChooser.add(ToolbarDecorator.createDecorator((JTable)table).disableAddAction().disableRemoveAction().createPanel());
        table.setVisibleRowCount(12);
        this.additionalSettingsPanel.setLayout((LayoutManager)new VerticalLayout(0));
        List providers = ScriptingSupportSpecificSettingsProvider.SETTINGS_PROVIDERS.getExtensionList((AreaInstance)this.project);
        for (ScriptingSupportSpecificSettingsProvider provider2 : providers) {
            this.additionalSettingsPanel.add((Component)new TitledSeparator(provider2.getTitle()));
            UnnamedConfigurable configurable = provider2.createConfigurable();
            this.scriptingSupportSettingsConfigurables.add(configurable);
            this.additionalSettingsPanel.add(configurable.createComponent());
        }
        return this.root;
    }

    public boolean isModified() {
        for (UnnamedConfigurable supportSpecificSetting : this.scriptingSupportSettingsConfigurables) {
            if (!supportSpecificSetting.isModified()) continue;
            return true;
        }
        return this.isScriptDefinitionsChanged();
    }

    public void apply() throws ConfigurationException {
        if (this.isScriptDefinitionsChanged()) {
            for (ModelDescriptor item : this.model.getItems()) {
                ScriptDefinition definition2 = item.getDefinition();
                int order = this.model.getItems().indexOf(item);
                this.settings.setOrder(definition2, order);
                this.settings.setEnabled(definition2, item.isEnabled());
                this.settings.setAutoReloadConfigurations(definition2, item.getAutoReloadConfigurations());
            }
            this.manager.reorderScriptDefinitions();
        }
        for (UnnamedConfigurable supportSpecificSetting : this.scriptingSupportSettingsConfigurables) {
            supportSpecificSetting.apply();
        }
    }

    public void reset() {
        this.model.setDefinitions(this.manager.getAllDefinitions(), this.settings);
        for (UnnamedConfigurable supportSpecificSetting : this.scriptingSupportSettingsConfigurables) {
            supportSpecificSetting.reset();
        }
    }

    private boolean isScriptDefinitionsChanged() {
        for (ModelDescriptor item : this.model.getItems()) {
            if (this.settings.isScriptDefinitionEnabled(item.getDefinition()) != item.isEnabled()) {
                return true;
            }
            if (this.settings.autoReloadConfigurations(item.getDefinition()) == item.getAutoReloadConfigurations()) continue;
            return true;
        }
        return !this.model.getDefinitions().equals(this.manager.getAllDefinitions());
    }

    @Nls
    public String getDisplayName() {
        return KotlinBundle.message("script.name.kotlin.scripting", new Object[0]);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.root = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.panelScriptDefinitionsChooser = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.additionalSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }
}

