/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J#\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0094\u0002J\"\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/NumberConversionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "fromType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toType", "disableIfAvailable", "Lcom/intellij/codeInsight/intention/IntentionAction;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lcom/intellij/codeInsight/intention/IntentionAction;)V", "fromChar", "", "fromFloatOrDouble", "fromInt", "isConversionAvailable", "toByteOrShort", "toChar", "toInt", "typePresentation", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "kotlin.idea"})
public final class NumberConversionFix
extends KotlinQuickFixAction<KtExpression> {
    private final boolean isConversionAvailable;
    private final String typePresentation;
    private final boolean fromInt;
    private final boolean fromChar;
    private final boolean fromFloatOrDouble;
    private final boolean toChar;
    private final boolean toInt;
    private final boolean toByteOrShort;
    private final IntentionAction disableIfAvailable;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        IntentionAction intentionAction = this.disableIfAvailable;
        if (intentionAction != null) {
            if (intentionAction.isAvailable(project2, editor2, (PsiFile)file2)) return false;
        }
        if (!this.isConversionAvailable) return false;
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("insert.number.conversion", new Object[0]);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("convert.expression.to.0", this.typePresentation);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block7: {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)file2), (boolean)false, (int)2, null);
            ApiVersion apiVersion2 = PlatformKt.getLanguageVersionSettings((PsiElement)element3).getApiVersion();
            KtExpression expressionToInsert = this.fromChar && apiVersion2.compareTo(ApiVersion.KOTLIN_1_5) >= 0 ? (this.toInt ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0.code", (Object[])new Object[]{element3}, (boolean)false, (int)4, null) : CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0.code.to$1()", (Object[])new Object[]{element3, this.typePresentation}, (boolean)false, (int)4, null)) : (!this.fromInt && this.toChar && apiVersion2.compareTo(ApiVersion.KOTLIN_1_5) >= 0 ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0.toInt().toChar()", (Object[])new Object[]{element3}, (boolean)false, (int)4, null) : (this.fromFloatOrDouble && this.toByteOrShort && apiVersion2.compareTo(ApiVersion.KOTLIN_1_3) >= 0 ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0.toInt().to$1()", (Object[])new Object[]{element3, this.typePresentation}, (boolean)false, (int)4, null) : CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0.to$1()", (Object[])new Object[]{element3, this.typePresentation}, (boolean)false, (int)4, null)));
            PsiElement $this$replaced$iv = (PsiElement)element3;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)expressionToInsert))) {
                psiElement2 = (PsiElement)expressionToInsert;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)expressionToInsert);
                PsiElement psiElement3 = result$iv;
                if (!(psiElement3 instanceof KtExpression)) {
                    psiElement3 = null;
                }
                if ((psiElement2 = (PsiElement)((KtExpression)psiElement3)) == null) {
                    PsiElement psiElement4 = result$iv;
                    if (psiElement4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement4).getExpression();
                    if (ktExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression2;
                }
            }
            KtExpression newExpression2 = (KtExpression)psiElement2;
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block7;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newExpression2)));
        }
    }

    public NumberConversionFix(@NotNull KtExpression element3, @NotNull KotlinType fromType, @NotNull KotlinType toType, @Nullable IntentionAction disableIfAvailable) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)fromType, (String)"fromType");
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        super((PsiElement)element3);
        this.disableIfAvailable = disableIfAvailable;
        this.isConversionAvailable = Intrinsics.areEqual((Object)fromType, (Object)toType) ^ true && TypeUtilsKt.isSignedOrUnsignedNumberType((KotlinType)fromType) && TypeUtilsKt.isSignedOrUnsignedNumberType((KotlinType)toType);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.renderType(toType);
        this.fromInt = TypeUtilsKt.isInt((KotlinType)fromType);
        this.fromChar = TypeUtilsKt.isChar((KotlinType)fromType);
        this.fromFloatOrDouble = TypeUtilsKt.isFloat((KotlinType)fromType) || TypeUtilsKt.isDouble((KotlinType)fromType);
        this.toChar = TypeUtilsKt.isChar((KotlinType)toType);
        this.toInt = TypeUtilsKt.isInt((KotlinType)toType);
        this.toByteOrShort = TypeUtilsKt.isByte((KotlinType)toType) || TypeUtilsKt.isShort((KotlinType)toType);
    }

    public /* synthetic */ NumberConversionFix(KtExpression ktExpression, KotlinType kotlinType, KotlinType kotlinType2, IntentionAction intentionAction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            intentionAction = null;
        }
        this(ktExpression, kotlinType, kotlinType2, intentionAction);
    }
}

