/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.migration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettingsListener;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.notifications.MigrationNotificationKt;
import org.jetbrains.kotlin.idea.migration.CodeMigrationToggleAction;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationProfileKt;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationProjectServiceKt;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;
import org.jetbrains.kotlin.idea.migration.MigrationState;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/migration/KotlinMigrationProjectService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentState", "Lorg/jetbrains/kotlin/idea/migration/MigrationState;", "getProject", "()Lcom/intellij/openapi/project/Project;", "dispose", "", "updateState", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "CommonCompilerSettingsChangeListener", "kotlin.idea"})
public final class KotlinMigrationProjectService
implements Disposable {
    private MigrationState currentState;
    @NotNull
    private final Project project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateState(LanguageVersion languageVersion2, ApiVersion apiVersion2) {
        MigrationState migrationState;
        KotlinMigrationProjectService kotlinMigrationProjectService;
        MigrationState migrationState2;
        if (languageVersion2 == null || apiVersion2 == null) {
            ApiVersion apiVersion3;
            IdeKotlinVersion bundledKotlinVersion = KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion();
            LanguageVersion languageVersion3 = languageVersion2;
            if (languageVersion3 == null) {
                languageVersion3 = bundledKotlinVersion.getLanguageVersion();
            }
            if ((apiVersion3 = apiVersion2) == null) {
                apiVersion3 = bundledKotlinVersion.getApiVersion();
            }
            migrationState2 = new MigrationState(languageVersion3, apiVersion3);
        } else {
            migrationState2 = new MigrationState(languageVersion2, apiVersion2);
        }
        MigrationState newState = migrationState2;
        KotlinMigrationProjectService kotlinMigrationProjectService2 = kotlinMigrationProjectService = this;
        synchronized (kotlinMigrationProjectService2) {
            MigrationState migrationState3;
            boolean bl = false;
            MigrationState it = migrationState3 = this.currentState;
            boolean bl2 = false;
            this.currentState = newState;
            migrationState = migrationState3;
        }
        MigrationState oldState = migrationState;
        MigrationInfo migrationInfo = KotlinMigrationProjectServiceKt.access$prepareMigrationInfo(oldState, newState);
        if (migrationInfo == null) {
            return;
        }
        MigrationInfo migrationInfo2 = migrationInfo;
        ReadAction.nonBlocking((Callable)new Callable(migrationInfo2){
            final /* synthetic */ MigrationInfo $migrationInfo;

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean call() {
                boolean bl;
                if (!KotlinMigrationProfileKt.applicableMigrationToolExists(this.$migrationInfo)) {
                    boolean $i$f$isUnitTestMode = false;
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode()) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
            {
                this.$migrationInfo = migrationInfo;
            }
        }).expireWith((Disposable)this).finishOnUiThread(ModalityState.any(), new Consumer(this, migrationInfo2){
            final /* synthetic */ KotlinMigrationProjectService this$0;
            final /* synthetic */ MigrationInfo $migrationInfo;

            public final void accept(Boolean toolExists) {
                Boolean bl = toolExists;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"toolExists");
                if (bl.booleanValue()) {
                    MigrationNotificationKt.showMigrationNotification(this.this$0.getProject(), this.$migrationInfo);
                }
            }
            {
                this.this$0 = kotlinMigrationProjectService;
                this.$migrationInfo = migrationInfo;
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public void dispose() {
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinMigrationProjectService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\b\u0010\b\u001a\u0004\u0018\u0001H\u00072\b\u0010\t\u001a\u0004\u0018\u0001H\u0007H\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/migration/KotlinMigrationProjectService$CommonCompilerSettingsChangeListener;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerSettingsListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "settingsChanged", "", "T", "oldSettings", "newSettings", "(Ljava/lang/Object;Ljava/lang/Object;)V", "kotlin.idea"})
    public static final class CommonCompilerSettingsChangeListener
    implements KotlinCompilerSettingsListener {
        private final Project project;

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> void settingsChanged(@Nullable T oldSettings, @Nullable T newSettings) {
            ApiVersion apiVersion2;
            LanguageVersion languageVersion2;
            LanguageVersion languageVersion3;
            KotlinMigrationProjectService kotlinMigrationProjectService;
            String string;
            T t = newSettings;
            if (!(t instanceof CommonCompilerArguments.DummyImpl)) {
                t = null;
            }
            CommonCompilerArguments.DummyImpl dummyImpl = (CommonCompilerArguments.DummyImpl)t;
            if (dummyImpl == null) {
                return;
            }
            CommonCompilerArguments.DummyImpl newCommonSettings = dummyImpl;
            if (!CodeMigrationToggleAction.Companion.isEnabled(this.project)) {
                return;
            }
            Project $this$service$iv = this.project;
            boolean $i$f$service2 = false;
            Object object = $this$service$iv.getService(KotlinMigrationProjectService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            KotlinMigrationProjectService kotlinMigrationProjectService2 = (KotlinMigrationProjectService)object;
            String string2 = newCommonSettings.getLanguageVersion();
            if (string2 != null) {
                void it;
                String $i$f$service2 = string = string2;
                kotlinMigrationProjectService = kotlinMigrationProjectService2;
                boolean bl = false;
                languageVersion3 = LanguageVersion.Companion.fromVersionString((String)it);
                kotlinMigrationProjectService2 = kotlinMigrationProjectService;
                languageVersion2 = languageVersion3;
            } else {
                languageVersion2 = null;
            }
            String string3 = newCommonSettings.getApiVersion();
            if (string3 != null) {
                String it = string = string3;
                languageVersion3 = languageVersion2;
                kotlinMigrationProjectService = kotlinMigrationProjectService2;
                boolean bl = false;
                ApiVersion apiVersion3 = ApiVersion.Companion.parse(it);
                kotlinMigrationProjectService2 = kotlinMigrationProjectService;
                languageVersion2 = languageVersion3;
                apiVersion2 = apiVersion3;
            } else {
                apiVersion2 = null;
            }
            kotlinMigrationProjectService2.updateState(languageVersion2, apiVersion2);
        }

        public CommonCompilerSettingsChangeListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }
    }
}

