/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.klib;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import java.io.IOException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.idea.klib.FileWithMetadata;
import org.jetbrains.kotlin.idea.klib.KlibDecompiledFile;
import org.jetbrains.kotlin.idea.klib.KlibMetadataDecompiler;
import org.jetbrains.kotlin.idea.klib.KlibMetadataDecompilerKt;
import org.jetbrains.kotlin.idea.klib.KlibMetadataStubBuilder;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0019H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001a\u001a\u00020\u001bH$J\b\u0010&\u001a\u00020\u0011H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010%2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/klib/KlibMetadataDecompiler;", "V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "expectedBinaryVersion", "invalidBinaryVersion", "stubVersion", "", "(Lcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;I)V", "metadataStubBuilder", "Lorg/jetbrains/kotlin/idea/klib/KlibMetadataStubBuilder;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "getRenderer", "()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer$delegate", "Lkotlin/Lazy;", "accepts", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "buildDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "virtualFile", "createFileViewProvider", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinDecompiledFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "doReadFile", "Lorg/jetbrains/kotlin/idea/klib/FileWithMetadata;", "getStubBuilder", "readFileSafely", "kotlin.core"})
public abstract class KlibMetadataDecompiler<V extends BinaryVersion>
extends ClassFileDecompilers.Full {
    private final KlibMetadataStubBuilder metadataStubBuilder;
    private final Lazy renderer$delegate;
    private final FileType fileType;
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    private final FlexibleTypeDeserializer flexibleTypeDeserializer;
    private final Function0<V> expectedBinaryVersion;
    private final Function0<V> invalidBinaryVersion;

    private final DescriptorRenderer getRenderer() {
        Lazy lazy = this.renderer$delegate;
        KlibMetadataDecompiler klibMetadataDecompiler = this;
        Object var3_3 = null;
        return (DescriptorRenderer)lazy.getValue();
    }

    @Nullable
    protected abstract FileWithMetadata doReadFile(@NotNull VirtualFile var1);

    public boolean accepts(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return FileTypeRegistry.getInstance().isFileOfType(file2, this.fileType);
    }

    @NotNull
    public KlibMetadataStubBuilder getStubBuilder() {
        return this.metadataStubBuilder;
    }

    @NotNull
    public KotlinDecompiledFileViewProvider createFileViewProvider(@NotNull VirtualFile file2, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        return new KotlinDecompiledFileViewProvider(manager, file2, physical, (Function1)new Function1<KotlinDecompiledFileViewProvider, KtDecompiledFile>(this){
            final /* synthetic */ KlibMetadataDecompiler this$0;

            @Nullable
            public final KtDecompiledFile invoke(@NotNull KotlinDecompiledFileViewProvider provider2) {
                Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
                return new KlibDecompiledFile(provider2, (Function1<? super VirtualFile, DecompiledText>)((Function1)new Function1<VirtualFile, DecompiledText>(this.this$0){

                    @NotNull
                    public final DecompiledText invoke(@NotNull VirtualFile p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return KlibMetadataDecompiler.access$buildDecompiledText((KlibMetadataDecompiler)((Object)this.receiver), p1);
                    }
                }));
            }
            {
                this.this$0 = klibMetadataDecompiler;
                super(1);
            }
        });
    }

    private final FileWithMetadata readFileSafely(VirtualFile file2) {
        FileWithMetadata fileWithMetadata;
        if (!file2.isValid()) {
            return null;
        }
        try {
            fileWithMetadata = this.doReadFile(file2);
        }
        catch (IOException e) {
            fileWithMetadata = null;
        }
        return fileWithMetadata;
    }

    private final DecompiledText buildDecompiledText(VirtualFile virtualFile2) {
        DecompiledText decompiledText;
        boolean bl = FileTypeRegistry.getInstance().isFileOfType(virtualFile2, this.fileType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Unexpected file type " + virtualFile2.getFileType();
            throw new AssertionError((Object)string);
        }
        FileWithMetadata file2 = this.readFileSafely(virtualFile2);
        if (file2 instanceof FileWithMetadata.Incompatible) {
            decompiledText = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)((BinaryVersion)this.expectedBinaryVersion.invoke()), (BinaryVersion)((FileWithMetadata.Incompatible)file2).getVersion());
        } else if (file2 instanceof FileWithMetadata.Compatible) {
            decompiledText = KlibMetadataDecompilerKt.decompiledText((FileWithMetadata.Compatible)file2, (SerializerExtensionProtocol)this.serializerProtocol.invoke(), this.flexibleTypeDeserializer, this.getRenderer());
        } else if (file2 == null) {
            decompiledText = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)((BinaryVersion)this.expectedBinaryVersion.invoke()), (BinaryVersion)((BinaryVersion)this.invalidBinaryVersion.invoke()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return decompiledText;
    }

    public KlibMetadataDecompiler(@NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer, @NotNull Function0<? extends V> expectedBinaryVersion, @NotNull Function0<? extends V> invalidBinaryVersion, int stubVersion) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkNotNullParameter((Object)flexibleTypeDeserializer, (String)"flexibleTypeDeserializer");
        Intrinsics.checkNotNullParameter(expectedBinaryVersion, (String)"expectedBinaryVersion");
        Intrinsics.checkNotNullParameter(invalidBinaryVersion, (String)"invalidBinaryVersion");
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.flexibleTypeDeserializer = flexibleTypeDeserializer;
        this.expectedBinaryVersion = expectedBinaryVersion;
        this.invalidBinaryVersion = invalidBinaryVersion;
        this.metadataStubBuilder = new KlibMetadataStubBuilder(stubVersion, this.fileType, this.serializerProtocol, (Function1<? super VirtualFile, ? extends FileWithMetadata>)((Function1)new Function1<VirtualFile, FileWithMetadata>(this){

            @Nullable
            public final FileWithMetadata invoke(@NotNull VirtualFile p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return KlibMetadataDecompiler.access$readFileSafely((KlibMetadataDecompiler)((Object)this.receiver), p1);
            }
        }));
        this.renderer$delegate = LazyKt.lazy((Function0)renderer.2.INSTANCE);
    }

    public static final /* synthetic */ DecompiledText access$buildDecompiledText(KlibMetadataDecompiler $this, VirtualFile virtualFile2) {
        return $this.buildDecompiledText(virtualFile2);
    }

    public static final /* synthetic */ FileWithMetadata access$readFileSafely(KlibMetadataDecompiler $this, VirtualFile file2) {
        return $this.readFileSafely(file2);
    }
}

