/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.UseExpressionBodyInspection;
import org.jetbrains.kotlin.idea.intentions.MergeIfsIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/joinLines/JoinBlockIntoSingleStatementHandler;", "Lcom/intellij/codeInsight/editorActions/JoinLinesHandlerDelegate;", "()V", "tryJoinLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "kotlin.idea"})
public final class JoinBlockIntoSingleStatementHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file2, int start2, int end) {
        PsiElement resultExpression;
        PsiElement psiElement2;
        ASTNode[] oneLineReturnFunction;
        Object object;
        ASTNode[] aSTNodeArray;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof KtFile)) {
            return -1;
        }
        if (start2 == 0) {
            return -1;
        }
        char c = document.getCharsSequence().charAt(start2);
        int index2 = c == '\n' ? start2 - 1 : start2;
        PsiElement psiElement3 = file2.findElementAt(index2);
        if (psiElement3 == null) {
            return -1;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"file.findElementAt(index) ?: return CANNOT_JOIN");
        PsiElement brace = psiElement3;
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)brace), (Object)KtTokens.LBRACE) ^ true) {
            return -1;
        }
        PsiElement psiElement4 = brace.getParent();
        if (!(psiElement4 instanceof KtBlockExpression)) {
            psiElement4 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement4;
        if (ktBlockExpression == null) {
            return -1;
        }
        KtBlockExpression block2 = ktBlockExpression;
        List list2 = block2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"block.statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
        if (ktExpression == null) {
            return -1;
        }
        KtExpression statement2 = ktExpression;
        PsiElement parent2 = block2.getParent();
        UseExpressionBodyInspection useExpressionBodyInspection = new UseExpressionBodyInspection(false);
        PsiElement psiElement5 = parent2;
        if (!(psiElement5 instanceof KtDeclarationWithBody)) {
            psiElement5 = null;
        }
        ASTNode[] aSTNodeArray2 = (ASTNode[])psiElement5;
        if (aSTNodeArray2 != null) {
            ASTNode[] it = aSTNodeArray = aSTNodeArray2;
            boolean bl = false;
            object = useExpressionBodyInspection.isActiveFor((KtDeclarationWithBody)it) ? aSTNodeArray : null;
        } else {
            object = oneLineReturnFunction = null;
        }
        if (!(parent2 instanceof KtContainerNode) && !(parent2 instanceof KtWhenEntry) && oneLineReturnFunction == null) {
            return -1;
        }
        ASTNode[] aSTNodeArray3 = block2.getNode().getChildren(KtTokens.COMMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray3, (String)"block.node.getChildren(KtTokens.COMMENTS)");
        aSTNodeArray = aSTNodeArray3;
        if (!(aSTNodeArray.length == 0)) {
            return -1;
        }
        PsiElement pparent = parent2.getParent();
        if (pparent instanceof KtIfExpression) {
            PsiElement ifParent;
            if (Intrinsics.areEqual((Object)block2, (Object)((KtIfExpression)pparent).getThen()) && statement2 instanceof KtIfExpression && ((KtIfExpression)statement2).getElse() == null) {
                if (((KtIfExpression)pparent).getElse() != null) {
                    return -1;
                }
                return MergeIfsIntention.Companion.applyTo((KtIfExpression)pparent);
            }
            if (Intrinsics.areEqual((Object)block2, (Object)((KtIfExpression)pparent).getElse()) && !((ifParent = ((KtIfExpression)pparent).getParent()) instanceof KtBlockExpression) && !(ifParent instanceof KtDeclaration) && !KtPsiUtil.isAssignment((PsiElement)ifParent)) {
                return -1;
            }
        }
        if (oneLineReturnFunction != null) {
            useExpressionBodyInspection.simplify((KtDeclarationWithBody)oneLineReturnFunction, false);
            KtExpression ktExpression2 = oneLineReturnFunction.getBodyExpression();
            if (ktExpression2 == null) {
                return -1;
            }
            psiElement2 = (PsiElement)ktExpression2;
        } else {
            psiElement2 = block2.replace((PsiElement)statement2);
        }
        PsiElement psiElement6 = resultExpression = psiElement2;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"resultExpression");
        return PsiUtilsKt.getStartOffset((PsiElement)org.jetbrains.kotlin.idea.util.PsiUtilsKt.reformatted(psiElement6, true));
    }
}

