/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddMissingClassKeywordIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lcom/intellij/psi/PsiElement;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "kotlin.idea"})
public final class AddMissingClassKeywordIntention
extends SelfTargetingIntention<PsiElement> {
    private static final List<KtModifierKeywordToken> targetKeywords;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean isApplicableTo(@NotNull PsiElement element3, int caretOffset) {
        KtClass ktClass2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        ASTNode aSTNode = element3.getNode();
        if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.IDENTIFIER) ^ true) {
            return false;
        }
        PsiElement psiElement2 = element3.getParent();
        if (!(psiElement2 instanceof KtClass)) {
            psiElement2 = null;
        }
        if ((ktClass2 = (KtClass)psiElement2) == null) {
            boolean bl;
            block10: {
                PsiElement psiElement3 = element3.getParent();
                if (!(psiElement3 instanceof PsiErrorElement)) {
                    psiElement3 = null;
                }
                PsiErrorElement psiErrorElement = (PsiErrorElement)psiElement3;
                if (psiErrorElement == null) {
                    return false;
                }
                PsiErrorElement errorElement = psiErrorElement;
                PsiElement psiElement4 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)errorElement), (boolean)false, (int)1, null);
                if (!(psiElement4 instanceof KtModifierList)) {
                    psiElement4 = null;
                }
                KtModifierList ktModifierList = (KtModifierList)psiElement4;
                if (ktModifierList == null) {
                    return false;
                }
                KtModifierList modifierList = ktModifierList;
                Iterable $this$any$iv = targetKeywords;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv;
                        boolean bl2 = false;
                        if (!modifierList.hasModifier(it)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return ktClass2.isEnum() && ktClass2.getClassKeyword() == null;
    }

    @Override
    public void applyTo(@NotNull PsiElement element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Editor editor3 = editor2;
        if (editor3 == null || (editor3 = editor3.getDocument()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor?.document ?: return");
        Editor document = editor3;
        PsiElement psiElement2 = element3.getParent();
        if (!(psiElement2 instanceof PsiErrorElement)) {
            psiElement2 = null;
        }
        PsiErrorElement psiErrorElement = (PsiErrorElement)psiElement2;
        PsiElement targetElement = psiErrorElement != null ? (PsiElement)psiErrorElement : element3;
        document.insertString(PsiUtilsKt.getStartOffset((PsiElement)targetElement), (CharSequence)"class ");
        PsiDocumentManager.getInstance((Project)element3.getProject()).commitDocument((Document)document);
    }

    public AddMissingClassKeywordIntention() {
        super(PsiElement.class, KotlinBundle.lazyMessage("add.missing.class.keyword", new Object[0]), null, 4, null);
    }

    static {
        Companion = new Companion(null);
        targetKeywords = CollectionsKt.listOf((Object[])new KtModifierKeywordToken[]{KtTokens.ANNOTATION_KEYWORD, KtTokens.DATA_KEYWORD, KtTokens.SEALED_KEYWORD, KtTokens.INNER_KEYWORD});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddMissingClassKeywordIntention$Companion;", "", "()V", "targetKeywords", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

