/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.groovy.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/GradleHeuristicHelper;", "", "()V", "findStatementWithPrefix", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "prefix", "", "findStatementWithPrefixes", "prefixes", "", "getHeuristicVersionInBuildScriptDependency", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "classpathStatement", "resolveVariableInBuildScript", "name", "kotlin.groovy"})
public final class GradleHeuristicHelper {
    @NotNull
    public static final GradleHeuristicHelper INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final IdeKotlinVersion getHeuristicVersionInBuildScriptDependency(@NotNull GrCallExpression classpathStatement) {
        GrArgumentList grArgumentList;
        Intrinsics.checkNotNullParameter((Object)classpathStatement, (String)"classpathStatement");
        GrCallExpression grCallExpression = classpathStatement;
        if (grCallExpression instanceof GrMethodCall) {
            grArgumentList = ((GrMethodCall)classpathStatement).getArgumentList();
        } else {
            PsiElement $this$getChildrenOfType$iv = (PsiElement)classpathStatement;
            boolean $i$f$getChildrenOfType = false;
            Object[] objectArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, GrCommandArgumentList.class);
            if (objectArray == null) {
                objectArray = (PsiElement[])new GrCommandArgumentList[0];
            }
            grArgumentList = (GrArgumentList)ArraysKt.singleOrNull((Object[])objectArray);
        }
        if (grArgumentList == null) return null;
        Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"when (classpathStatement\u2026\n        } ?: return null");
        GrArgumentList argumentList2 = grArgumentList;
        Object[] objectArray = argumentList2.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"argumentList.children");
        Object object = ArraysKt.firstOrNull((Object[])objectArray);
        if (!(object instanceof GrLiteral)) {
            object = null;
        }
        GrLiteral grLiteral = (GrLiteral)object;
        if (grLiteral == null) return null;
        GrLiteral grLiteral2 = grLiteral;
        if (grLiteral2 instanceof GrString && ((GrString)grLiteral2).getInjections().length == 1) {
            GrReferenceExpression grReferenceExpression;
            Object[] objectArray2 = ((GrString)grLiteral2).getInjections();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"grLiteral.injections");
            GrStringInjection grStringInjection = (GrStringInjection)ArraysKt.first((Object[])objectArray2);
            if (grStringInjection == null) return null;
            GrStringInjection versionInjection = grStringInjection;
            GrExpression grExpression = versionInjection.getExpression();
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            if ((grReferenceExpression = (GrReferenceExpression)grExpression) == null) {
                Object[] objectArray3 = versionInjection.getClosableBlock();
                Object[] objectArray4 = objectArray3;
                if (objectArray3 == null) return null;
                PsiElement $this$getChildrenOfType$iv = (PsiElement)objectArray4;
                boolean $i$f$getChildrenOfType = false;
                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, GrReferenceExpression.class);
                if (psiElementArray == null) {
                    psiElementArray = (PsiElement[])new GrReferenceExpression[0];
                }
                Object[] objectArray5 = (GrReferenceExpression[])psiElementArray;
                objectArray4 = objectArray5;
                if (objectArray5 == null) return null;
                grReferenceExpression = (GrReferenceExpression)ArraysKt.singleOrNull((Object[])objectArray4);
            }
            if (grReferenceExpression == null) return null;
            GrReferenceExpression expression2 = grReferenceExpression;
            String string = expression2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.text");
            return this.resolveVariableInBuildScript(classpathStatement, string);
        }
        Object object2 = grLiteral2.getValue();
        if (object2 == null) return null;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"grLiteral.value ?: return null");
        Object literalValue = object2;
        String versionText = StringsKt.substringAfterLast$default((String)literalValue.toString(), (char)':', null, (int)2, null);
        CharSequence charSequence = versionText;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl = false;
        if (!bl) return IdeKotlinVersion.Companion.opt(versionText);
        return null;
    }

    private final IdeKotlinVersion resolveVariableInBuildScript(GrCallExpression classpathStatement, String name2) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)classpathStatement;
        boolean $i$f$getStrictParentOfType = false;
        GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrClosableBlock.class, (boolean)true);
        if (grClosableBlock == null) {
            return null;
        }
        GrClosableBlock dependenciesClosure = grClosableBlock;
        PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)dependenciesClosure;
        boolean $i$f$getStrictParentOfType2 = false;
        GrClosableBlock grClosableBlock2 = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, GrClosableBlock.class, (boolean)true);
        if (grClosableBlock2 == null) {
            return null;
        }
        GrClosableBlock buildScriptClosure = grClosableBlock2;
        for (PsiElement child : buildScriptClosure.getChildren()) {
            PsiElement psiElement2 = child;
            if (psiElement2 instanceof GrAssignmentExpression) {
                GrExpression assignValue;
                GrExpression grExpression = ((GrAssignmentExpression)child).getLValue();
                Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"child.lValue");
                if (!Intrinsics.areEqual((Object)grExpression.getText(), (Object)("ext." + name2)) || !((assignValue = ((GrAssignmentExpression)child).getRValue()) instanceof GrLiteral)) continue;
                return IdeKotlinVersion.Companion.opt(String.valueOf(((GrLiteral)assignValue).getValue()));
            }
            if (!(psiElement2 instanceof GrVariableDeclaration)) continue;
            GrVariable[] grVariableArray = ((GrVariableDeclaration)child).getVariables();
            int n = grVariableArray.length;
            for (int i = 0; i < n; ++i) {
                GrExpression assignValue;
                GrVariable variable2;
                GrVariable grVariable = variable2 = grVariableArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)grVariable, (String)"variable");
                if (!Intrinsics.areEqual((Object)grVariable.getName(), (Object)name2) || !((assignValue = variable2.getInitializerGroovy()) instanceof GrLiteral)) continue;
                return IdeKotlinVersion.Companion.opt(String.valueOf(((GrLiteral)assignValue).getValue()));
            }
        }
        return null;
    }

    @NotNull
    public final List<GrCallExpression> findStatementWithPrefix(@NotNull GrClosableBlock closure, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        return this.findStatementWithPrefixes(closure, SetsKt.setOf((Object)prefix2));
    }

    @NotNull
    public final List<GrCallExpression> findStatementWithPrefixes(@NotNull GrClosableBlock closure, @NotNull Set<String> prefixes) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        PsiElement $this$getChildrenOfType$iv = (PsiElement)closure;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, GrCallExpression.class);
        if (psiElementArray == null) {
            psiElementArray = (PsiElement[])new GrCallExpression[0];
        }
        GrCallExpression[] applicationStatements = (GrCallExpression[])psiElementArray;
        ArrayList<GrCallExpression> classPathStatements = new ArrayList<GrCallExpression>();
        for (GrCallExpression statement2 : applicationStatements) {
            String expressionText2;
            GrReferenceExpression startExpression;
            PsiElement $this$getChildrenOfType$iv2 = (PsiElement)statement2;
            boolean $i$f$getChildrenOfType2 = false;
            Object[] objectArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv2, GrReferenceExpression.class);
            if (objectArray == null) {
                objectArray = (PsiElement[])new GrReferenceExpression[0];
            }
            if ((GrReferenceExpression)ArraysKt.firstOrNull((Object[])objectArray) == null) {
                continue;
            }
            if (startExpression.getText() == null) {
                continue;
            }
            if (!prefixes.contains(expressionText2)) continue;
            classPathStatements.add(statement2);
        }
        return classPathStatements;
    }

    private GradleHeuristicHelper() {
    }

    static {
        GradleHeuristicHelper gradleHeuristicHelper;
        INSTANCE = gradleHeuristicHelper = new GradleHeuristicHelper();
    }
}

