/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.statistics;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradle.statistics.KotlinGradleFUSCollector;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;
import org.jetbrains.kotlin.statistics.BuildSessionLogger;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u00012\u00020\u0002:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/statistics/KotlinGradleFUSLogger;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "Ljava/lang/Runnable;", "()V", "run", "", "runActivity", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "kotlin.gradle.gradle-idea"})
public final class KotlinGradleFUSLogger
implements StartupActivity.DumbAware,
Runnable {
    private static final int MAXIMUM_USER_DIRS = 10;
    public static final long EXECUTION_DELAY_MIN = 60L;
    private static final String GRADLE_USER_DIRS_PROPERTY_NAME = "kotlin-gradle-user-dirs";
    private static final AtomicBoolean isRunning;
    @NotNull
    public static final Companion Companion;

    public void runActivity(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this, 60L, 60L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        Companion.reportStatistics();
    }

    static {
        Companion = new Companion(null);
        isRunning = new AtomicBoolean(false);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/statistics/KotlinGradleFUSLogger$Companion;", "", "()V", "EXECUTION_DELAY_MIN", "", "GRADLE_USER_DIRS_PROPERTY_NAME", "", "MAXIMUM_USER_DIRS", "", "value", "", "gradleUserDirs", "getGradleUserDirs", "()Ljava/util/List;", "setGradleUserDirs", "(Ljava/util/List;)V", "isRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "populateGradleUserDir", "", "path", "reportStatistics", "kotlin.gradle.gradle-idea"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void reportStatistics() {
            if (isRunning.compareAndSet(false, true)) {
                try {
                    for (String gradleUserHome : this.getGradleUserDirs()) {
                        List<File> list2 = BuildSessionLogger.Companion.listProfileFiles(new File(gradleUserHome, "kotlin-profile"));
                        if (list2 == null) continue;
                        Iterable $this$forEach$iv = list2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            File statisticFile = (File)element$iv;
                            boolean bl = false;
                            boolean fileWasRead = true;
                            try {
                                void previousEvent;
                                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                                objectRef.element = null;
                                fileWasRead = MetricsContainer.Companion.readFromFile(statisticFile, (Function1<? super MetricsContainer, Unit>)((Function1)new Function1<MetricsContainer, Unit>((Ref.ObjectRef)previousEvent){
                                    final /* synthetic */ Ref.ObjectRef $previousEvent;

                                    public final void invoke(@NotNull MetricsContainer metricContainer) {
                                        Intrinsics.checkNotNullParameter((Object)metricContainer, (String)"metricContainer");
                                        KotlinGradleFUSCollector.Companion.reportMetrics(metricContainer, (MetricsContainer)this.$previousEvent.element);
                                        this.$previousEvent.element = metricContainer;
                                    }
                                    {
                                        this.$previousEvent = objectRef;
                                        super(1);
                                    }
                                }));
                                if (!fileWasRead || statisticFile.delete()) continue;
                            }
                            catch (Exception e) {
                                Logger.getInstance(KotlinFUSLogger.class).info("Failed to process file " + statisticFile.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
                                continue;
                            }
                            finally {
                                if (statisticFile.delete()) continue;
                                Logger.getInstance(KotlinFUSLogger.class).warn("[FUS] Failed to delete file " + statisticFile.getAbsolutePath());
                                continue;
                            }
                            Logger.getInstance(KotlinFUSLogger.class).warn("[FUS] Failed to delete file " + statisticFile.getAbsolutePath());
                        }
                    }
                }
                finally {
                    isRunning.set(false);
                }
            }
        }

        private final List<String> getGradleUserDirs() {
            List list2 = PropertiesComponent.getInstance().getList(KotlinGradleFUSLogger.GRADLE_USER_DIRS_PROPERTY_NAME);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        private final void setGradleUserDirs(List<String> value2) {
            PropertiesComponent.getInstance().setList(KotlinGradleFUSLogger.GRADLE_USER_DIRS_PROPERTY_NAME, (Collection)value2);
        }

        /*
         * WARNING - void declaration
         */
        public final void populateGradleUserDir(@NotNull String path2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            List<String> currentState = this.getGradleUserDirs();
            if (currentState.contains(path2)) {
                return;
            }
            ArrayList<String> result2 = new ArrayList<String>();
            result2.add(path2);
            result2.addAll((Collection)currentState);
            Iterable iterable = result2;
            Companion companion = this;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path path3;
                String filePath = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)Paths.get(filePath, new String[0]), (String)"get(path)");
                LinkOption[] linkOptionArray = new LinkOption[0];
                if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            companion.setGradleUserDirs(CollectionsKt.take((Iterable)list2, (int)10));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

