/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.overrideImplement;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000b\u001a\u00020\fH&J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0012\u001a\u00020\u0006H&J\b\u0010\u0013\u001a\u00020\u0014H%J\b\u0010\u0015\u001a\u00020\u0014H%J!\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J&\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0014J&\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0002J\b\u0010!\u001a\u00020\u0006H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/core/overrideImplement/AbstractGenerateMembersHandler;", "T", "Lcom/intellij/codeInsight/generation/ClassMember;", "Lcom/intellij/lang/LanguageCodeInsightActionHandler;", "()V", "toImplement", "", "getToImplement", "()Z", "collectMembersToGenerate", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateMembers", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "selectedElements", "copyDoc", "getChooserTitle", "", "getNoMembersFoundHint", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "implementAll", "isValidFor", "isValidForClass", "showOverrideImplementChooser", "Lcom/intellij/ide/util/MemberChooser;", "members", "startInWriteAction", "kotlin.fir.frontend-independent"})
public abstract class AbstractGenerateMembersHandler<T extends ClassMember>
implements LanguageCodeInsightActionHandler {
    @NotNull
    public abstract Collection<T> collectMembersToGenerate(@NotNull KtClassOrObject var1);

    public abstract boolean getToImplement();

    @NlsContexts.DialogTitle
    @NotNull
    protected abstract String getChooserTitle();

    @NlsContexts.HintText
    @NotNull
    protected abstract String getNoMembersFoundHint();

    public abstract void generateMembers(@NotNull Editor var1, @NotNull KtClassOrObject var2, @NotNull Collection<? extends T> var3, boolean var4);

    protected boolean isValidForClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        return true;
    }

    private final MemberChooser<T> showOverrideImplementChooser(Project project2, Collection<? extends T> members2) {
        Collection<ClassMember> $this$toTypedArray$iv = members2;
        boolean $i$f$toTypedArray = false;
        Collection<ClassMember> thisCollection$iv = $this$toTypedArray$iv;
        ClassMember[] classMemberArray = thisCollection$iv.toArray(new ClassMember[0]);
        Intrinsics.checkNotNull((Object)classMemberArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        if (classMemberArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ClassMember[] memberArray = classMemberArray;
        MemberChooser chooser2 = new MemberChooser(memberArray, true, true, project2);
        chooser2.setTitle(this.getChooserTitle());
        if (this.getToImplement()) {
            chooser2.selectElements(memberArray);
        }
        chooser2.show();
        if (chooser2.getExitCode() != 0) {
            return null;
        }
        return chooser2;
    }

    public boolean isValidFor(@NotNull Editor editor2, @NotNull PsiFile file2) {
        KtClassOrObject ktClassOrObject;
        PsiElement elementAtCaret;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof KtFile)) {
            return false;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        PsiElement psiElement2 = elementAtCaret = file2.findElementAt(caretModel.getOffset());
        if (psiElement2 != null) {
            PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
            boolean $i$f$getNonStrictParentOfType = false;
            ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        } else {
            ktClassOrObject = null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        return classOrObject != null && this.isValidForClass(classOrObject);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        this.invoke(project2, editor2, file2, application.isUnitTestMode());
    }

    public final void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, boolean implementAll) {
        PsiElement psiElement2;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                CaretModel caretModel = editor2.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                PsiElement elementAtCaret = file2.findElementAt(caretModel.getOffset());
                psiElement2 = elementAtCaret;
                if (psiElement2 == null) break block10;
                PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
                boolean $i$f$getNonStrictParentOfType = false;
                psiElement2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
                if (psiElement2 != null) break block11;
            }
            return;
        }
        PsiElement classOrObject = psiElement2;
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        Collection members2 = this.collectMembersToGenerate((KtClassOrObject)classOrObject);
        if (members2.isEmpty() && !implementAll) {
            HintManager.getInstance().showErrorHint(editor2, this.getNoMembersFoundHint());
            return;
        }
        boolean copyDoc = false;
        Collection selectedElements2 = null;
        if (implementAll) {
            selectedElements2 = members2;
            copyDoc = false;
        } else {
            MemberChooser<T> memberChooser = this.showOverrideImplementChooser(project2, members2);
            if (memberChooser == null) {
                return;
            }
            MemberChooser<T> chooser2 = memberChooser;
            List list2 = chooser2.getSelectedElements();
            if (list2 == null) {
                return;
            }
            selectedElements2 = list2;
            copyDoc = chooser2.isCopyJavadoc();
        }
        if (selectedElements2.isEmpty()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        this.generateMembers(editor2, (KtClassOrObject)classOrObject, selectedElements2, copyDoc);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

