/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.uiDesigner.CaptionSelection;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GridChangeUtil;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.componentTree.ComponentSelectionListener;
import com.intellij.uiDesigner.designSurface.ActiveDecorationLayer;
import com.intellij.uiDesigner.designSurface.FeedbackPainter;
import com.intellij.uiDesigner.designSurface.GridInsertLocation;
import com.intellij.uiDesigner.designSurface.GridInsertMode;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.HorzInsertFeedbackPainter;
import com.intellij.uiDesigner.designSurface.VertInsertFeedbackPainter;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridCaptionPanel
extends JPanel
implements ComponentSelectionListener,
DataProvider {
    private static final Logger LOG = Logger.getInstance(GridCaptionPanel.class);
    private final GuiEditor myEditor;
    private final boolean myIsRow;
    private RadContainer mySelectedContainer;
    private final DefaultListSelectionModel mySelectionModel = new DefaultListSelectionModel();
    private int myResizeLine = -1;
    private int myDropInsertLine = -1;
    private final LineFeedbackPainter myFeedbackPainter = new LineFeedbackPainter();
    private final DeleteProvider myDeleteProvider = new MyDeleteProvider();
    private final Alarm myAlarm = new Alarm();

    public GridCaptionPanel(final GuiEditor editor, boolean isRow) {
        this.myEditor = editor;
        this.myIsRow = isRow;
        this.mySelectionModel.setSelectionMode(2);
        this.mySelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GridCaptionPanel.this.repaint();
                GridCaptionPanel.this.myEditor.fireSelectedComponentChanged();
            }
        });
        this.setBackground((Color)GridCaptionPanel.getGutterColor());
        editor.addComponentSelectionListener(this);
        MyMouseListener listener = new MyMouseListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addKeyListener(new MyKeyListener());
        this.setFocusable(true);
        DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(), (JComponent)this);
        DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GridCaptionPanel.this.repaint();
                GridCaptionPanel.this.myAlarm.addRequest(() -> editor.fireSelectedComponentChanged(), 1000);
            }

            @Override
            public void focusLost(FocusEvent e) {
                GridCaptionPanel.this.repaint();
            }
        });
    }

    public static JBColor getGutterColor() {
        return JBColor.lazy(() -> {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
            return color == null ? UIUtil.getPanelBackground() : color;
        });
    }

    public RadContainer getSelectedContainer() {
        this.checkSelectionChanged();
        return this.mySelectedContainer;
    }

    public boolean isRow() {
        return this.myIsRow;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int paintedSize = 8;
        int paintOffset = 7;
        RadContainer container = this.getSelectedGridContainer();
        if (container == null) {
            return;
        }
        RadAbstractGridLayoutManager layout = container.getGridLayoutManager();
        int[] coords = layout.getGridCellCoords(container, this.myIsRow);
        int[] sizes = layout.getGridCellSizes(container, this.myIsRow);
        int count = this.myIsRow ? layout.getGridRowCount(container) : layout.getGridColumnCount(container);
        for (int i = 0; i < count; ++i) {
            int x = this.myIsRow ? 0 : coords[i];
            int y = this.myIsRow ? coords[i] : 0;
            Point pnt = SwingUtilities.convertPoint(container.getDelegee(), x, y, this);
            Rectangle rc = this.myIsRow ? new Rectangle(bounds.x + 7, pnt.y, 8, sizes[i]) : new Rectangle(pnt.x, bounds.y + 7, sizes[i], 8);
            g.setColor(this.getCaptionColor(i));
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
            Rectangle rcDecoration = this.myIsRow ? new Rectangle(bounds.x, pnt.y, bounds.width, sizes[i]) : new Rectangle(pnt.x, bounds.y, sizes[i], bounds.height);
            layout.paintCaptionDecoration(container, this.myIsRow, i, g2d, rcDecoration);
            Stroke oldStroke = g2d.getStroke();
            int deltaX = 0;
            int deltaY = 0;
            if (this.isFocusOwner() && i == this.mySelectionModel.getLeadSelectionIndex()) {
                g.setColor(Color.BLACK);
                g2d.setStroke(new BasicStroke(2.0f));
                deltaX = this.myIsRow ? 1 : 0;
                deltaY = this.myIsRow ? 0 : 1;
            } else {
                g.setColor(Color.DARK_GRAY);
            }
            g.drawRect(rc.x + deltaX, rc.y + deltaY, rc.width - deltaX, rc.height - deltaY);
            g2d.setStroke(oldStroke);
        }
        g.setColor(Color.DARK_GRAY);
        if (this.myIsRow) {
            g.drawLine(15, 0, 15, bounds.height);
        } else {
            g.drawLine(0, 15, bounds.width, 15);
        }
        if (this.myDropInsertLine >= 0) {
            int[] lines = this.myIsRow ? layout.getHorizontalGridLines(container) : layout.getVerticalGridLines(container);
            int coord = lines[this.myDropInsertLine];
            coord = this.myIsRow ? SwingUtilities.convertPoint((Component)container.getDelegee(), (int)0, (int)coord, (Component)this).y : SwingUtilities.convertPoint((Component)container.getDelegee(), (int)coord, (int)0, (Component)this).x;
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            g.setColor(PlatformColors.BLUE);
            if (this.myIsRow) {
                g.drawLine(bounds.x + 1, coord, bounds.x + bounds.width - 1, coord);
            } else {
                g.drawLine(coord, bounds.y + 1, coord, bounds.y + bounds.height - 1);
            }
            g2d.setStroke(oldStroke);
        }
    }

    private Color getCaptionColor(int i) {
        GridChangeUtil.CellStatus status;
        if (this.mySelectionModel.isSelectedIndex(i)) {
            return LightColors.BLUE;
        }
        if (this.mySelectedContainer != null && i >= 0 && i < this.mySelectedContainer.getGridCellCount(this.myIsRow) && ((status = GridChangeUtil.canDeleteCell(this.mySelectedContainer, i, this.myIsRow)) == GridChangeUtil.CellStatus.Empty || status == GridChangeUtil.CellStatus.Redundant)) {
            return Color.PINK;
        }
        return LightColors.GREEN;
    }

    @Nullable
    private RadContainer getSelectedGridContainer() {
        RadComponent topComponent;
        RadContainer container;
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(this.myEditor);
        if (selection.size() == 1 && selection.get(0) instanceof RadContainer && (container = (RadContainer)selection.get(0)).getLayoutManager().isGrid() && (container.getParent() instanceof RadRootContainer || container.getComponentCount() > 0)) {
            return container;
        }
        container = FormEditingUtil.getSelectionParent(selection);
        if (container == null && this.myEditor.getRootContainer().getComponentCount() > 0 && (topComponent = this.myEditor.getRootContainer().getComponent(0)) instanceof RadContainer) {
            container = (RadContainer)topComponent;
        }
        if (container != null && !container.getLayoutManager().isGrid()) {
            return null;
        }
        return container;
    }

    @Override
    public void selectedComponentChanged(@NotNull GuiEditor source) {
        if (source == null) {
            GridCaptionPanel.$$$reportNull$$$0(0);
        }
        this.checkSelectionChanged();
        this.repaint();
    }

    private void checkSelectionChanged() {
        RadContainer container = this.getSelectedGridContainer();
        if (container != this.mySelectedContainer) {
            this.mySelectedContainer = container;
            this.mySelectionModel.clearSelection();
            this.repaint();
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            GridCaptionPanel.$$$reportNull$$$0(1);
        }
        if (GuiEditor.DATA_KEY.is(dataId)) {
            return this.myEditor;
        }
        if (CaptionSelection.DATA_KEY.is(dataId)) {
            return new CaptionSelection(this.mySelectedContainer, this.myIsRow, this.getSelectedCells(null), this.mySelectionModel.getLeadSelectionIndex());
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteProvider;
        }
        return this.myEditor.getData(dataId);
    }

    public void attachToScrollPane(JScrollPane scrollPane) {
        scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GridCaptionPanel.this.repaint();
            }
        });
    }

    private boolean canResizeCells() {
        return GuiDesignerConfiguration.getInstance((Project)this.myEditor.getProject()).RESIZE_HEADERS && this.mySelectedContainer != null && this.mySelectedContainer.getGridLayoutManager().canResizeCells();
    }

    private int getCellAt(Point pnt) {
        if (this.mySelectedContainer == null) {
            return -1;
        }
        pnt = SwingUtilities.convertPoint(this, pnt, this.mySelectedContainer.getDelegee());
        return this.myIsRow ? this.mySelectedContainer.getGridRowAt(pnt.y) : this.mySelectedContainer.getGridColumnAt(pnt.x);
    }

    public int[] getSelectedCells(@Nullable Point dragOrigin) {
        int cell;
        ArrayList<Integer> selection = new ArrayList<Integer>();
        RadContainer container = this.getSelectedGridContainer();
        if (container == null) {
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int size = this.getCellCount();
        for (int i = 0; i < size; ++i) {
            if (!this.mySelectionModel.isSelectedIndex(i)) continue;
            selection.add(i);
        }
        if (selection.size() == 0 && dragOrigin != null && (cell = this.getCellAt(dragOrigin)) >= 0) {
            return new int[]{cell};
        }
        int[] result = new int[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            result[i] = (Integer)selection.get(i);
        }
        return result;
    }

    private int getCellCount() {
        RadContainer gridContainer = this.getSelectedGridContainer();
        assert (gridContainer != null);
        return this.myIsRow ? gridContainer.getGridRowCount() : gridContainer.getGridColumnCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/designSurface/GridCaptionPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectedComponentChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 36) {
                GridCaptionPanel.this.mySelectionModel.setSelectionInterval(0, 0);
            } else if (e.getKeyCode() == 35) {
                int cellCount = GridCaptionPanel.this.getCellCount();
                GridCaptionPanel.this.mySelectionModel.setSelectionInterval(cellCount - 1, cellCount - 1);
            } else if (e.getKeyCode() == (GridCaptionPanel.this.myIsRow ? 38 : 37)) {
                this.moveSelection(e, -1);
            } else if (e.getKeyCode() == (GridCaptionPanel.this.myIsRow ? 40 : 39)) {
                this.moveSelection(e, 1);
            }
        }

        private void moveSelection(KeyEvent e, int delta) {
            int leadIndex = GridCaptionPanel.this.mySelectionModel.getLeadSelectionIndex();
            int newLeadIndex = leadIndex + delta;
            if (newLeadIndex >= 0 && newLeadIndex < GridCaptionPanel.this.getCellCount()) {
                if ((e.getModifiers() & 1) != 0) {
                    GridCaptionPanel.this.mySelectionModel.setSelectionInterval(GridCaptionPanel.this.mySelectionModel.getAnchorSelectionIndex(), newLeadIndex);
                } else {
                    GridCaptionPanel.this.mySelectionModel.setSelectionInterval(newLeadIndex, newLeadIndex);
                }
            }
        }
    }

    private static class MyDragBean {
        public boolean isRow;
        public int[] cells;

        MyDragBean(boolean row, int[] cells) {
            this.isRow = row;
            this.cells = cells;
        }
    }

    private class MyDnDTarget
    implements DnDTarget {
        private MyDnDTarget() {
        }

        public boolean update(DnDEvent aEvent) {
            aEvent.setDropPossible(false);
            if (GridCaptionPanel.this.mySelectedContainer == null) {
                return false;
            }
            if (!(aEvent.getAttachedObject() instanceof MyDragBean)) {
                return false;
            }
            MyDragBean bean = (MyDragBean)aEvent.getAttachedObject();
            if (bean.isRow != GridCaptionPanel.this.myIsRow || bean.cells.length == 0) {
                return false;
            }
            int gridLine = this.getDropGridLine(aEvent);
            this.setDropInsertLine(gridLine);
            aEvent.setDropPossible(gridLine >= 0);
            if (gridLine >= 0) {
                FeedbackPainter painter = GridCaptionPanel.this.myIsRow ? HorzInsertFeedbackPainter.INSTANCE : VertInsertFeedbackPainter.INSTANCE;
                Rectangle rcFeedback = new Rectangle(GridCaptionPanel.this.mySelectedContainer.getDelegee().getSize());
                Rectangle cellRect = new Rectangle(gridLine, gridLine, 1, 1);
                rcFeedback = GridInsertLocation.getInsertFeedbackPosition(GridCaptionPanel.this.myIsRow ? GridInsertMode.RowBefore : GridInsertMode.ColumnBefore, GridCaptionPanel.this.mySelectedContainer, cellRect, rcFeedback);
                GridCaptionPanel.this.myEditor.getActiveDecorationLayer().putFeedback(GridCaptionPanel.this.mySelectedContainer.getDelegee(), rcFeedback, painter, null);
            } else {
                GridCaptionPanel.this.myEditor.getActiveDecorationLayer().removeFeedback();
            }
            return false;
        }

        private int getDropGridLine(DnDEvent aEvent) {
            Point point = aEvent.getPointOn((Component)GridCaptionPanel.this.mySelectedContainer.getDelegee());
            return GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().getGridLineNear(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow, point, 20);
        }

        public void drop(DnDEvent aEvent) {
            if (!(aEvent.getAttachedObject() instanceof MyDragBean)) {
                return;
            }
            MyDragBean dragBean = (MyDragBean)aEvent.getAttachedObject();
            int targetCell = this.getDropGridLine(aEvent);
            if (targetCell < 0) {
                return;
            }
            GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().processCellsMoved(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow, dragBean.cells, targetCell);
            GridCaptionPanel.this.mySelectionModel.clearSelection();
            GridCaptionPanel.this.mySelectedContainer.revalidate();
            GridCaptionPanel.this.myEditor.refreshAndSave(true);
            this.cleanUpOnLeave();
        }

        public void cleanUpOnLeave() {
            this.setDropInsertLine(-1);
            GridCaptionPanel.this.myEditor.getActiveDecorationLayer().removeFeedback();
        }

        private void setDropInsertLine(int i) {
            if (GridCaptionPanel.this.myDropInsertLine != i) {
                GridCaptionPanel.this.myDropInsertLine = i;
                GridCaptionPanel.this.repaint();
            }
        }
    }

    private class MyDnDSource
    implements DnDSource {
        private MyDnDSource() {
        }

        public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
            int[] selectedCells;
            if (dragOrigin == null) {
                MyDnDSource.$$$reportNull$$$0(0);
            }
            LOG.debug("canStartDragging(): dragOrigin=" + dragOrigin);
            if (GridCaptionPanel.this.myResizeLine != -1) {
                LOG.debug("canStartDragging(): have resize line");
                return false;
            }
            RadContainer container = GridCaptionPanel.this.getSelectedGridContainer();
            if (container != null && container.getGridLayoutManager().getGridLineNear(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow, dragOrigin, 4) != -1) {
                LOG.debug("canStartDragging(): have gridline near");
                return false;
            }
            for (int cell : selectedCells = GridCaptionPanel.this.getSelectedCells(dragOrigin)) {
                if (this.canDragCell(cell)) continue;
                LOG.debug("canStartDragging(): cannot drag cell");
                return false;
            }
            LOG.debug("canStartDragging(): starting drag");
            return true;
        }

        private boolean canDragCell(int cell) {
            if (GridCaptionPanel.this.mySelectedContainer == null) {
                return false;
            }
            for (RadComponent c : GridCaptionPanel.this.mySelectedContainer.getComponents()) {
                if (!c.getConstraints().contains(GridCaptionPanel.this.myIsRow, cell) || c.getConstraints().getSpan(GridCaptionPanel.this.myIsRow) <= 1) continue;
                return false;
            }
            return true;
        }

        public DnDDragStartBean startDragging(DnDAction action, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                MyDnDSource.$$$reportNull$$$0(1);
            }
            return new DnDDragStartBean((Object)new MyDragBean(GridCaptionPanel.this.myIsRow, GridCaptionPanel.this.getSelectedCells(dragOrigin)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dragOrigin";
            objectArray2[1] = "com/intellij/uiDesigner/designSurface/GridCaptionPanel$MyDnDSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canStartDragging";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDeleteProvider
    implements DeleteProvider {
        private MyDeleteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyDeleteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            int[] selection;
            if (dataContext == null) {
                MyDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((selection = GridCaptionPanel.this.getSelectedCells(null)).length > 0) {
                FormEditingUtil.deleteRowOrColumn(GridCaptionPanel.this.myEditor, GridCaptionPanel.this.mySelectedContainer, selection, GridCaptionPanel.this.myIsRow);
            }
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteProvider.$$$reportNull$$$0(2);
            }
            if (GridCaptionPanel.this.mySelectedContainer == null || GridCaptionPanel.this.mySelectionModel.isSelectionEmpty()) {
                return false;
            }
            int[] selection = GridCaptionPanel.this.getSelectedCells(null);
            return GridCaptionPanel.this.mySelectedContainer.getGridCellCount(GridCaptionPanel.this.myIsRow) - selection.length >= GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().getMinCellCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uiDesigner/designSurface/GridCaptionPanel$MyDeleteProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uiDesigner/designSurface/GridCaptionPanel$MyDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LineFeedbackPainter
    implements FeedbackPainter {
        private LineFeedbackPainter() {
        }

        @Override
        public void paintFeedback(Graphics2D g, Rectangle rc) {
            g.setColor(LightColors.YELLOW);
            if (rc.width == 1) {
                g.drawLine(rc.x, rc.y, rc.x, rc.y + rc.height);
            } else {
                g.drawLine(rc.x, rc.y, rc.x + rc.width, rc.y);
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private static final int MINIMUM_RESIZED_SIZE = 8;

        private MyMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GridCaptionPanel.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (GridCaptionPanel.this.mySelectedContainer == null) {
                return;
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)GridCaptionPanel.this, true));
            Point pnt = SwingUtilities.convertPoint(GridCaptionPanel.this, e.getPoint(), GridCaptionPanel.this.mySelectedContainer.getDelegee());
            if (GridCaptionPanel.this.canResizeCells()) {
                GridCaptionPanel.this.myResizeLine = GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().getGridLineNear(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow, pnt, 4);
            }
            if (!this.checkShowPopupMenu(e)) {
                int cell = GridCaptionPanel.this.getCellAt(e.getPoint());
                if (cell == -1) {
                    return;
                }
                if ((e.getModifiers() & 2) != 0) {
                    GridCaptionPanel.this.mySelectionModel.addSelectionInterval(cell, cell);
                } else if ((e.getModifiers() & 1) != 0) {
                    GridCaptionPanel.this.mySelectionModel.addSelectionInterval(GridCaptionPanel.this.mySelectionModel.getAnchorSelectionIndex(), cell);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            GridCaptionPanel.this.setCursor(Cursor.getDefaultCursor());
            GridCaptionPanel.this.myEditor.getActiveDecorationLayer().removeFeedback();
            if (GridCaptionPanel.this.myResizeLine > 0) {
                Point pnt = SwingUtilities.convertPoint(GridCaptionPanel.this, e.getPoint(), GridCaptionPanel.this.mySelectedContainer.getDelegee());
                this.doResize(pnt);
                GridCaptionPanel.this.myResizeLine = -1;
            }
            if (!this.checkShowPopupMenu(e)) {
                int cell = GridCaptionPanel.this.getCellAt(e.getPoint());
                if (cell == -1) {
                    return;
                }
                if ((e.getModifiers() & 3) == 0) {
                    GridCaptionPanel.this.mySelectionModel.setSelectionInterval(cell, cell);
                }
            }
        }

        private boolean checkShowPopupMenu(MouseEvent e) {
            int cell = GridCaptionPanel.this.getCellAt(e.getPoint());
            if (cell >= 0 && e.isPopupTrigger()) {
                ActionGroup group;
                if (!GridCaptionPanel.this.mySelectionModel.isSelectedIndex(cell)) {
                    GridCaptionPanel.this.mySelectionModel.setSelectionInterval(cell, cell);
                }
                if ((group = GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().getCaptionActions()) != null) {
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", group);
                    popupMenu.getComponent().show(GridCaptionPanel.this, e.getX(), e.getY());
                    return true;
                }
            }
            return false;
        }

        private void doResize(Point pnt) {
            int newCoord;
            int[] coords = GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().getGridCellCoords(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow);
            int prevCoord = coords[GridCaptionPanel.this.myResizeLine - 1];
            int n = newCoord = GridCaptionPanel.this.myIsRow ? pnt.y : pnt.x;
            if (newCoord < prevCoord + 8) {
                return;
            }
            int newSize = newCoord - prevCoord;
            if (!GridCaptionPanel.this.myEditor.ensureEditable()) {
                return;
            }
            GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().processCellResized(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow, GridCaptionPanel.this.myResizeLine - 1, newSize);
            GridCaptionPanel.this.mySelectedContainer.revalidate();
            GridCaptionPanel.this.myEditor.refreshAndSave(true);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!GridCaptionPanel.this.canResizeCells()) {
                return;
            }
            Point pnt = SwingUtilities.convertPoint(GridCaptionPanel.this, e.getPoint(), GridCaptionPanel.this.mySelectedContainer.getDelegee());
            int gridLine = GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().getGridLineNear(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow, pnt, 4);
            if (gridLine <= 0) {
                GridCaptionPanel.this.setCursor(Cursor.getDefaultCursor());
            } else if (GridCaptionPanel.this.myIsRow) {
                GridCaptionPanel.this.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                GridCaptionPanel.this.setCursor(Cursor.getPredefinedCursor(10));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (GridCaptionPanel.this.myResizeLine > 0) {
                int newCoord;
                Point pnt = SwingUtilities.convertPoint(GridCaptionPanel.this, e.getPoint(), GridCaptionPanel.this.mySelectedContainer.getDelegee());
                int[] coords = GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().getGridCellCoords(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow);
                int prevCoord = coords[GridCaptionPanel.this.myResizeLine - 1];
                int n = newCoord = GridCaptionPanel.this.myIsRow ? pnt.y : pnt.x;
                if (newCoord < prevCoord + 8) {
                    return;
                }
                int newSize = newCoord - prevCoord;
                String toolTip = GridCaptionPanel.this.mySelectedContainer.getGridLayoutManager().getCellResizeTooltip(GridCaptionPanel.this.mySelectedContainer, GridCaptionPanel.this.myIsRow, GridCaptionPanel.this.myResizeLine - 1, newSize);
                ActiveDecorationLayer layer = GridCaptionPanel.this.myEditor.getActiveDecorationLayer();
                Rectangle rc = GridCaptionPanel.this.myIsRow ? new Rectangle(0, e.getPoint().y, layer.getSize().width, 1) : new Rectangle(e.getPoint().x, 0, 1, layer.getSize().height);
                layer.putFeedback(GridCaptionPanel.this, rc, GridCaptionPanel.this.myFeedbackPainter, toolTip);
            }
        }
    }
}

