/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\b"}, d2={"isContinuationParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "isLoweredSuspendFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isStringArrayParameter", "backend.js"})
public final class JsMainFunctionDetectorKt {
    public static final boolean isStringArrayParameter(@NotNull IrValueParameter $this$isStringArrayParameter) {
        Intrinsics.checkNotNullParameter($this$isStringArrayParameter, "<this>");
        IrType irType = $this$isStringArrayParameter.getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return false;
        }
        IrSimpleType type2 = irSimpleType;
        if (!IrTypePredicatesKt.isArray(type2)) {
            return false;
        }
        if (type2.getArguments().size() != 1) {
            return false;
        }
        IrTypeArgument irTypeArgument = CollectionsKt.single(type2.getArguments());
        IrTypeProjection irTypeProjection = irTypeArgument instanceof IrTypeProjection ? (IrTypeProjection)irTypeArgument : null;
        if (irTypeProjection == null) {
            return false;
        }
        IrTypeProjection argument2 = irTypeProjection;
        if (argument2.getVariance() == Variance.IN_VARIANCE) {
            return false;
        }
        return IrTypePredicatesKt.isString(argument2.getType());
    }

    public static final boolean isLoweredSuspendFunction(@NotNull IrFunction $this$isLoweredSuspendFunction, @NotNull JsCommonBackendContext context) {
        Intrinsics.checkNotNullParameter($this$isLoweredSuspendFunction, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        IrValueParameter irValueParameter = CollectionsKt.lastOrNull($this$isLoweredSuspendFunction.getValueParameters());
        if (irValueParameter == null) {
            return false;
        }
        IrValueParameter parameter = irValueParameter;
        IrType irType = parameter.getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return false;
        }
        IrSimpleType type2 = irSimpleType;
        return Intrinsics.areEqual(type2.getClassifier(), context.getCoroutineSymbols().getContinuationClass());
    }

    public static final boolean isContinuationParameter(@NotNull IrValueParameter $this$isContinuationParameter, @NotNull JsCommonBackendContext context) {
        Intrinsics.checkNotNullParameter($this$isContinuationParameter, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        IrType irType = $this$isContinuationParameter.getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return false;
        }
        IrSimpleType type2 = irSimpleType;
        return Intrinsics.areEqual(type2.getClassifier(), context.getCoroutineSymbols().getContinuationClass());
    }
}

