/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbi;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.MemoizedValueClassAbstractReplacements;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b \u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H$J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H$J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH$J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H$J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H$J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020'H$J\u0018\u0010(\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010)\u001a\u00020\u0015H\u0004J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010)\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020'H$J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0019J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002052\u0006\u00106\u001a\u000209J\u0010\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020<H\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010>*\u00020\u0015H\u0002J\f\u0010?\u001a\u00020@*\u00020\u0015H&J\f\u0010A\u001a\u00020@*\u00020\u0019H&R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmValueClassAbstractLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "replacements", "Lorg/jetbrains/kotlin/backend/jvm/MemoizedValueClassAbstractReplacements;", "getReplacements", "()Lorg/jetbrains/kotlin/backend/jvm/MemoizedValueClassAbstractReplacements;", "valueMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getValueMap", "()Ljava/util/Map;", "addBindingsFor", "", "original", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "replacement", "addJvmInlineAnnotation", "valueClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "buildBoxFunction", "buildPrimaryValueClassConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildSpecializedEqualsMethod", "buildUnboxFunctions", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformConstructorFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "transformFunctionFlat", "function", "transformSimpleFunctionFlat", "visitAnonymousInitializerNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitClassNew", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitStatementContainer", "container", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementContainer;", "hashSuffix", "", "isSpecificFieldGetter", "", "isSpecificLoweringLogicApplicable", "backend.jvm.lower"})
public abstract class JvmValueClassAbstractLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Map<IrValueSymbol, IrValueDeclaration> valueMap;

    public JvmValueClassAbstractLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.valueMap = new LinkedHashMap();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public abstract MemoizedValueClassAbstractReplacements getReplacements();

    @NotNull
    protected final Map<IrValueSymbol, IrValueDeclaration> getValueMap() {
        return this.valueMap;
    }

    private final void addBindingsFor(IrFunction original, IrFunction replacement) {
        for (Pair pair : CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(original), (Iterable)IrUtilsKt.getExplicitParameters(replacement))) {
            IrValueParameter param = (IrValueParameter)pair.component1();
            IrValueParameter newParam = (IrValueParameter)pair.component2();
            this.valueMap.put(param.getSymbol(), newParam);
        }
    }

    @Override
    public final void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.transformChildrenVoid(irFile);
    }

    public abstract boolean isSpecificLoweringLogicApplicable(@NotNull IrClass var1);

    public abstract boolean isSpecificFieldGetter(@NotNull IrFunction var1);

    @Override
    @NotNull
    public final IrStatement visitClassNew(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(declaration);
        if (irConstructor2 != null) {
            IrConstructor it = irConstructor2;
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = this.getReplacements().getGetReplacementFunction().invoke(it);
            if (irSimpleFunction != null) {
                IrSimpleFunction replacement = irSimpleFunction;
                boolean bl2 = false;
                this.addBindingsFor(it, replacement);
            }
        }
        TransformKt.transformDeclarationsFlat(declaration, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
            final /* synthetic */ JvmValueClassAbstractLowering this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final List<IrDeclaration> invoke(@NotNull IrDeclaration memberDeclaration) {
                List<IrDeclaration> list2;
                Intrinsics.checkNotNullParameter(memberDeclaration, "memberDeclaration");
                if (memberDeclaration instanceof IrFunction) {
                    void this_$iv;
                    IrElementTransformerVoidWithContext irElementTransformerVoidWithContext = this.this$0;
                    JvmValueClassAbstractLowering jvmValueClassAbstractLowering = this.this$0;
                    boolean $i$f$withinScope = false;
                    IrElementTransformerVoidWithContext.access$unsafeEnterScope((IrElementTransformerVoidWithContext)this_$iv, memberDeclaration);
                    boolean bl = false;
                    List<IrDeclaration> result$iv = jvmValueClassAbstractLowering.transformFunctionFlat((IrFunction)memberDeclaration);
                    IrElementTransformerVoidWithContext.access$unsafeLeaveScope((IrElementTransformerVoidWithContext)this_$iv);
                    list2 = result$iv;
                } else {
                    memberDeclaration.accept(this.this$0, null);
                    list2 = null;
                }
                return list2;
            }
        });
        if (this.isSpecificLoweringLogicApplicable(declaration)) {
            IrConstructor irConstructor3 = IrUtilsKt.getPrimaryConstructor(declaration);
            Intrinsics.checkNotNull(irConstructor3);
            IrConstructor irConstructor4 = irConstructor3;
            declaration.getDeclarations().removeIf(arg_0 -> JvmValueClassAbstractLowering.visitClassNew$lambda-2(irConstructor4, this, arg_0));
            this.buildPrimaryValueClassConstructor(declaration, irConstructor4);
            this.buildBoxFunction(declaration);
            this.buildUnboxFunctions(declaration);
            this.buildSpecializedEqualsMethod(declaration);
            this.addJvmInlineAnnotation(declaration);
        }
        return declaration;
    }

    @Nullable
    protected final List<IrDeclaration> transformFunctionFlat(@NotNull IrFunction function2) {
        List<IrDeclaration> list2;
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2 instanceof IrConstructor && ((IrConstructor)function2).isPrimary() && this.isSpecificLoweringLogicApplicable(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)function2))) {
            return null;
        }
        IrSimpleFunction replacement = this.getReplacements().getGetReplacementFunction().invoke(function2);
        if (replacement == null) {
            this.transformChildrenVoid(function2);
            if (function2 instanceof IrSimpleFunction) {
                ((IrSimpleFunction)function2).setOverriddenSymbols(this.getReplacements().getReplaceOverriddenSymbols().invoke((IrSimpleFunction)function2));
            }
            return null;
        }
        if (function2 instanceof IrSimpleFunction) {
            String suffix;
            boolean bl;
            block13: {
                Iterable $this$any$iv = ((IrSimpleFunction)function2).getOverriddenSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        if (!IrUtilsKt.getParentAsClass((IrDeclaration)it.getOwner()).isFun()) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl && (suffix = this.hashSuffix(function2)) != null) {
                String string2 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "function.name.asString()");
                if (StringsKt.endsWith$default(string2, suffix, false, 2, null)) {
                    this.transformChildrenVoid(function2);
                    return null;
                }
            }
        }
        this.addBindingsFor(function2, replacement);
        IrFunction irFunction2 = function2;
        if (irFunction2 instanceof IrSimpleFunction) {
            list2 = this.transformSimpleFunctionFlat((IrSimpleFunction)function2, replacement);
        } else if (irFunction2 instanceof IrConstructor) {
            list2 = this.transformConstructorFlat((IrConstructor)function2, replacement);
        } else {
            throw new IllegalStateException();
        }
        return list2;
    }

    private final String hashSuffix(IrFunction $this$hashSuffix) {
        return InlineClassAbi.INSTANCE.hashSuffix($this$hashSuffix, this.context.getState().getFunctionsWithInlineClassReturnTypesMangled(), this.context.getState().getUseOldManglingSchemeForFunctionsWithInlineClassesInSignatures());
    }

    @NotNull
    protected abstract List<IrDeclaration> transformConstructorFlat(@NotNull IrConstructor var1, @NotNull IrSimpleFunction var2);

    @NotNull
    protected abstract List<IrDeclaration> transformSimpleFunctionFlat(@NotNull IrSimpleFunction var1, @NotNull IrSimpleFunction var2);

    protected abstract void buildPrimaryValueClassConstructor(@NotNull IrClass var1, @NotNull IrConstructor var2);

    protected abstract void buildBoxFunction(@NotNull IrClass var1);

    protected abstract void buildUnboxFunctions(@NotNull IrClass var1);

    protected abstract void buildSpecializedEqualsMethod(@NotNull IrClass var1);

    protected abstract void addJvmInlineAnnotation(@NotNull IrClass var1);

    @Override
    @NotNull
    public final IrExpression visitReturn(@NotNull IrReturn expression2) {
        block4: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrReturnTarget $this$safeAs$iv = expression2.getReturnTargetSymbol().getOwner();
            boolean $i$f$safeAs = false;
            IrReturnTarget irReturnTarget = $this$safeAs$iv;
            if (!(irReturnTarget instanceof IrFunction)) {
                irReturnTarget = null;
            }
            IrFunction irFunction2 = (IrFunction)irReturnTarget;
            if (irFunction2 == null) break block4;
            IrFunction target = irFunction2;
            boolean bl = false;
            String suffix = this.hashSuffix(target);
            if (suffix != null) {
                String string2 = target.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "target.name.asString()");
                if (StringsKt.endsWith$default(string2, suffix, false, 2, null)) {
                    return super.visitReturn(expression2);
                }
            }
            IrSimpleFunction irSimpleFunction = this.getReplacements().getGetReplacementFunction().invoke(target);
            if (irSimpleFunction != null) {
                IrSimpleFunction it = irSimpleFunction;
                boolean bl2 = false;
                return ExpressionHelpersKt.irReturn(LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)it.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset()), (IrExpression)expression2.getValue().transform((IrElementTransformer)this, (Object)null));
            }
        }
        return super.visitReturn(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitStatementContainer(IrStatementContainer container) {
        List<IrStatement> $this$transformFlat$iv = container.getStatements();
        boolean $i$f$transformFlat = false;
        int i$iv = 0;
        while (i$iv < $this$transformFlat$iv.size()) {
            void statement2;
            IrStatement item$iv;
            IrStatement irStatement = item$iv = $this$transformFlat$iv.get(i$iv);
            List<IrStatement> list2 = $this$transformFlat$iv;
            boolean bl = false;
            i$iv = TransformKt.replaceInPlace(list2, statement2 instanceof IrFunction ? this.transformFunctionFlat((IrFunction)statement2) : CollectionsKt.listOf(IrElementsKt.transformStatement((IrStatement)statement2, this)), i$iv);
        }
    }

    @Override
    @NotNull
    public final IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.visitStatementContainer(expression2);
        return expression2;
    }

    @Override
    @NotNull
    public final IrBody visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.visitStatementContainer(body2);
        return body2;
    }

    @Override
    @NotNull
    public final IrStatement visitAnonymousInitializerNew(@NotNull IrAnonymousInitializer declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrDeclarationParent $this$safeAs$iv = declaration.getParent();
        boolean $i$f$safeAs = false;
        IrDeclarationParent irDeclarationParent = $this$safeAs$iv;
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        IrClass irClass2 = (IrClass)irDeclarationParent;
        return (irClass2 != null ? this.isSpecificLoweringLogicApplicable(irClass2) : false) ? (IrStatement)declaration : super.visitAnonymousInitializerNew(declaration);
    }

    private static final boolean visitClassNew$lambda-2(IrConstructor $irConstructor, JvmValueClassAbstractLowering this$0, IrDeclaration it) {
        Intrinsics.checkNotNullParameter($irConstructor, "$irConstructor");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, $irConstructor) || it instanceof IrFunction && this$0.isSpecificFieldGetter((IrFunction)it) && !((IrFunction)it).getVisibility().isPublicAPI();
    }
}

