/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.builder.KotlinLightClassBuilderFactory;
import org.jetbrains.kotlin.asJava.builder.LightClassBuilderResult;
import org.jetbrains.kotlin.asJava.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.builder.StubComputationTracker;
import org.jetbrains.kotlin.asJava.builder.StubComputationTrackerKt;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aj\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2<\u0010\u000e\u001a8\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00140\u000f\u001a\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a$\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildLightClass", "Lorg/jetbrains/kotlin/asJava/builder/LightClassBuilderResult;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "generateClassFilter", "Lorg/jetbrains/kotlin/codegen/state/GenerationState$GenerateClassFilter;", "context", "Lorg/jetbrains/kotlin/asJava/builder/LightClassConstructionContext;", "generate", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "Lkotlin/ParameterName;", "name", "state", "", "createJavaFileStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "logErrorWithOSInfo", "cause", "", "fqName", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "light-classes"})
public final class LightClassBuilderKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LightClassBuilderResult buildLightClass(@NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> files2, @NotNull GenerationState.GenerateClassFilter generateClassFilter, @NotNull LightClassConstructionContext context, @NotNull Function2<? super GenerationState, ? super Collection<? extends KtFile>, Unit> generate2) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(generateClassFilter, "generateClassFilter");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(generate2, "generate");
        Project project = ((KtFile)CollectionsKt.first((Iterable)files2)).getProject();
        Intrinsics.checkNotNullExpressionValue(project, "files.first().project");
        Project project2 = project;
        try {
            CompilerConfiguration compilerConfiguration;
            KotlinLightClassBuilderFactory classBuilderFactory = new KotlinLightClassBuilderFactory(LightClassBuilderKt.createJavaFileStub(packageFqName, files2));
            Project project3 = project2;
            ClassBuilderFactory classBuilderFactory2 = classBuilderFactory;
            ModuleDescriptor moduleDescriptor = context.getModule();
            BindingContext bindingContext = context.getBindingContext();
            LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
            if (languageVersionSettings != null) {
                void it;
                CompilerConfiguration compilerConfiguration2;
                LanguageVersionSettings languageVersionSettings2 = languageVersionSettings;
                BindingContext bindingContext2 = bindingContext;
                ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
                ClassBuilderFactory classBuilderFactory3 = classBuilderFactory2;
                Project project4 = project3;
                boolean bl = false;
                CompilerConfiguration $this$buildLightClass_u24lambda_u2d1_u24lambda_u2d0 = compilerConfiguration2 = new CompilerConfiguration();
                boolean bl2 = false;
                CommonConfigurationKeysKt.setLanguageVersionSettings($this$buildLightClass_u24lambda_u2d1_u24lambda_u2d0, (LanguageVersionSettings)it);
                $this$buildLightClass_u24lambda_u2d1_u24lambda_u2d0.put(JVMConfigurationKeys.JVM_TARGET, context.getJvmTarget());
                $this$buildLightClass_u24lambda_u2d1_u24lambda_u2d0.setReadOnly(true);
                CompilerConfiguration compilerConfiguration3 = compilerConfiguration2;
                project3 = project4;
                classBuilderFactory2 = classBuilderFactory3;
                moduleDescriptor = moduleDescriptor2;
                bindingContext = bindingContext2;
                compilerConfiguration = compilerConfiguration3;
            } else {
                compilerConfiguration = CompilerConfiguration.EMPTY;
            }
            Intrinsics.checkNotNullExpressionValue(compilerConfiguration, "context.languageVersionS\u2026mpilerConfiguration.EMPTY");
            CompilerConfiguration compilerConfiguration4 = compilerConfiguration;
            BindingContext bindingContext3 = bindingContext;
            ModuleDescriptor moduleDescriptor3 = moduleDescriptor;
            ClassBuilderFactory classBuilderFactory4 = classBuilderFactory2;
            Project project5 = project3;
            GenerationState state = new GenerationState.Builder(project5, classBuilderFactory4, moduleDescriptor3, bindingContext3, compilerConfiguration4).generateDeclaredClassFilter(generateClassFilter).wantsDiagnostics(false).build();
            state.beforeCompile();
            state.oldBEInitTrace(files2);
            generate2.invoke(state, files2);
            PsiJavaFileStub javaFileStub = classBuilderFactory.result();
            StubComputationTracker stubComputationTracker = StubComputationTrackerKt.stubComputationTrackerInstance(project2);
            if (stubComputationTracker != null) {
                stubComputationTracker.onStubComputed(javaFileStub, context);
            }
            return new LightClassBuilderResult(javaFileStub, context.getBindingContext(), state.getCollectedExtraJvmDiagnostics());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LightClassBuilderKt.logErrorWithOSInfo(e, packageFqName, null);
            throw e;
        }
    }

    private static final PsiJavaFileStub createJavaFileStub(FqName packageFqName, Collection<? extends KtFile> files2) {
        PsiJavaFileStubImpl javaFileStub = new PsiJavaFileStubImpl(packageFqName.asString(), true);
        javaFileStub.setPsiFactory(ClsWrapperStubPsiFactory.INSTANCE);
        FileViewProvider fileViewProvider = ((KtFile)CollectionsKt.first((Iterable)files2)).getViewProvider();
        ClsFileImpl fakeFile2 = new ClsFileImpl(javaFileStub, packageFqName, files2, fileViewProvider){
            final /* synthetic */ PsiJavaFileStubImpl $javaFileStub;
            final /* synthetic */ FqName $packageFqName;
            final /* synthetic */ Collection<KtFile> $files;
            {
                this.$javaFileStub = $javaFileStub;
                this.$packageFqName = $packageFqName;
                this.$files = $files;
                super($super_call_param$1);
            }

            @NotNull
            public PsiJavaFileStubImpl getStub() {
                return this.$javaFileStub;
            }

            @NotNull
            public String getPackageName() {
                String string2 = this.$packageFqName.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "packageFqName.asString()");
                return string2;
            }

            public boolean isPhysical() {
                return false;
            }

            @NotNull
            public String getText() {
                KtFile ktFile = (KtFile)CollectionsKt.singleOrNull((Iterable)this.$files);
                String string2 = ktFile != null ? ktFile.getText() : null;
                if (string2 == null) {
                    String string3 = super.getText();
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "super.getText()");
                }
                return string2;
            }
        };
        javaFileStub.setPsi((PsiFile)fakeFile2);
        return javaFileStub;
    }

    private static final void logErrorWithOSInfo(Throwable cause, FqName fqName2, VirtualFile virtualFile2) {
        String string2;
        VirtualFile virtualFile3 = virtualFile2;
        if (virtualFile3 == null) {
            string2 = "<null>";
        } else {
            String string3 = virtualFile3.getPath();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "virtualFile.path");
        }
        String path2 = string2;
        LOG.error("Could not generate LightClass for " + fqName2 + " declared in " + path2 + "\nSystem: " + SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION + " Java Runtime: " + SystemInfo.JAVA_RUNTIME_VERSION, cause);
    }

    static {
        Logger logger = Logger.getInstance(LightClassBuilderResult.class);
        Intrinsics.checkNotNullExpressionValue(logger, "<clinit>");
        LOG = logger;
    }
}

