/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.restriction.AnnotationContext;
import com.intellij.codeInspection.restriction.RestrictionInfo;
import com.intellij.codeInspection.restriction.RestrictionInfoFactory;
import com.intellij.codeInspection.restriction.StringFlowUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public abstract class NlsInfo
implements RestrictionInfo {
    static final String NLS_SAFE = "com.intellij.openapi.util.NlsSafe";
    @NotNull
    private static final String NLS_CONTEXT = "com.intellij.openapi.util.NlsContext";
    @NotNull
    private static final Set<String> ANNOTATION_NAMES = Set.of("org.jetbrains.annotations.Nls", "org.jetbrains.annotations.NonNls", "com.intellij.openapi.util.NlsSafe", "org.jetbrains.annotations.PropertyKey");
    @NotNull
    private final ThreeState myNls;

    private NlsInfo(@NotNull ThreeState nls) {
        if (nls == null) {
            NlsInfo.$$$reportNull$$$0(0);
        }
        this.myNls = nls;
    }

    public static NlsInfoFactory factory() {
        return NlsInfoFactory.INSTANCE;
    }

    @NotNull
    public ThreeState getNlsStatus() {
        ThreeState threeState = this.myNls;
        if (threeState == null) {
            NlsInfo.$$$reportNull$$$0(1);
        }
        return threeState;
    }

    public boolean canBeUsedInLocalizedContext() {
        return this instanceof Localized || this instanceof NlsSafe;
    }

    @NotNull
    public static Localized localized() {
        Localized localized = Localized.NLS;
        if (localized == null) {
            NlsInfo.$$$reportNull$$$0(2);
        }
        return localized;
    }

    @NotNull
    public static NonLocalized nonLocalized() {
        NonLocalized nonLocalized = NonLocalized.INSTANCE;
        if (nonLocalized == null) {
            NlsInfo.$$$reportNull$$$0(3);
        }
        return nonLocalized;
    }

    @NotNull
    public static NlsInfo forExpression(@NotNull UExpression expression) {
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(4);
        }
        return NlsInfo.forExpression(expression, true);
    }

    @NotNull
    static NlsInfo forExpression(@NotNull UExpression expression, boolean allowStringModifications) {
        NlsInfo target;
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(5);
        }
        if ((target = NlsInfo.fromEqualityCheck(expression = StringFlowUtil.goUp((UExpression)expression, (boolean)allowStringModifications, (RestrictionInfoFactory)NlsInfoFactory.INSTANCE), allowStringModifications)) != NlsUnspecified.UNKNOWN) {
            NlsInfo nlsInfo = target;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(6);
            }
            return nlsInfo;
        }
        AnnotationContext context = AnnotationContext.fromExpression((UExpression)expression);
        return NlsInfo.fromAnnotationContext(expression.getUastParent(), context);
    }

    @NotNull
    private static NlsInfo fromEqualityCheck(@NotNull UExpression expression, boolean allowStringModifications) {
        UastBinaryOperator operator;
        UQualifiedReferenceExpression qualifiedCall;
        String name;
        UElement parent;
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(7);
        }
        if ((parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent())) instanceof UCallExpression && (name = ((UCallExpression)parent).getMethodName()) != null && (name.equals("equals") || allowStringModifications && name.equals("startsWith") || name.equals("endsWith") || name.equals("equalsIgnoreCase") || name.equals("contains")) && (qualifiedCall = (UQualifiedReferenceExpression)ObjectUtils.tryCast((Object)parent.getUastParent(), UQualifiedReferenceExpression.class)) != null && parent.equals(qualifiedCall.getSelector())) {
            return NlsInfo.fromVariableReference(qualifiedCall.getReceiver());
        }
        if (parent instanceof UBinaryExpression && ((operator = ((UBinaryExpression)parent).getOperator()) == UastBinaryOperator.EQUALS || operator == UastBinaryOperator.NOT_EQUALS)) {
            UExpression left = ((UBinaryExpression)parent).getLeftOperand();
            UExpression right = ((UBinaryExpression)parent).getRightOperand();
            if (AnnotationContext.expressionsAreEquivalent((UExpression)left, (UExpression)expression)) {
                return NlsInfo.fromVariableReference(right);
            }
            if (AnnotationContext.expressionsAreEquivalent((UExpression)right, (UExpression)expression)) {
                return NlsInfo.fromVariableReference(left);
            }
        }
        NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
        if (nlsUnspecified == null) {
            NlsInfo.$$$reportNull$$$0(8);
        }
        return nlsUnspecified;
    }

    @NotNull
    private static NlsInfo fromVariableReference(UExpression receiver) {
        PsiElement target;
        if (receiver instanceof UReferenceExpression && TypeUtils.isJavaLangString((PsiType)receiver.getExpressionType()) && (target = ((UReferenceExpression)receiver).resolve()) instanceof PsiVariable) {
            NlsInfo nlsInfo = NlsInfo.factory().fromModifierListOwner((PsiModifierListOwner)((PsiVariable)target));
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(9);
            }
            return nlsInfo;
        }
        NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
        if (nlsUnspecified == null) {
            NlsInfo.$$$reportNull$$$0(10);
        }
        return nlsUnspecified;
    }

    @NotNull
    public static NlsInfo forType(@NotNull PsiType type) {
        if (type == null) {
            NlsInfo.$$$reportNull$$$0(11);
        }
        return NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)type);
    }

    @NotNull
    public static NlsInfo forModifierListOwner(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(12);
        }
        return NlsInfo.fromAnnotationContext(null, AnnotationContext.fromModifierListOwner((PsiModifierListOwner)owner));
    }

    @NotNull
    public static Nls.Capitalization getCapitalization(@NotNull PsiModifierListOwner owner) {
        NlsInfo info;
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(13);
        }
        if ((info = NlsInfo.forModifierListOwner(owner)) instanceof Localized) {
            Nls.Capitalization capitalization = ((Localized)info).getCapitalization();
            if (capitalization == null) {
                NlsInfo.$$$reportNull$$$0(14);
            }
            return capitalization;
        }
        Nls.Capitalization capitalization = Nls.Capitalization.NotSpecified;
        if (capitalization == null) {
            NlsInfo.$$$reportNull$$$0(15);
        }
        return capitalization;
    }

    @NotNull
    private static NlsInfo fromAnnotationContext(UElement parent, AnnotationContext context) {
        PsiMember member;
        ULocalVariable uLocal;
        NlsInfo info = NlsInfo.fromType(context.getType());
        if (info != NlsUnspecified.UNKNOWN) {
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(16);
            }
            return nlsInfo;
        }
        PsiModifierListOwner owner = context.getOwner();
        if (owner == null) {
            NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
            if (nlsUnspecified == null) {
                NlsInfo.$$$reportNull$$$0(17);
            }
            return nlsUnspecified;
        }
        info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)owner.getModifierList());
        if (info != NlsUnspecified.UNKNOWN) {
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(18);
            }
            return nlsInfo;
        }
        if (owner instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)owner;
            if (parameter.isVarArgs() && context.getType() instanceof PsiEllipsisType) {
                info = NlsInfo.fromType(((PsiEllipsisType)context.getType()).getComponentType());
            }
        } else if (owner instanceof PsiVariable && (uLocal = (ULocalVariable)UastContextKt.toUElement((PsiElement)owner, ULocalVariable.class)) != null) {
            info = NlsInfo.fromUVariable((UVariable)uLocal);
        }
        if (info.getKind() != RestrictionInfo.RestrictionInfoKind.KNOWN) {
            info = context.secondaryItems().map(item -> NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)item.getModifierList())).filter(inf -> inf != NlsUnspecified.UNKNOWN).findFirst().orElse(info);
        }
        if (info == NlsUnspecified.UNKNOWN && (member = (PsiMember)ObjectUtils.tryCast((Object)(owner instanceof PsiParameter ? ((PsiParameter)owner).getDeclarationScope() : owner), PsiMember.class)) != null) {
            info = NlsInfo.fromContainer(member);
        }
        if (info == NlsUnspecified.UNKNOWN && (!(parent instanceof UCallExpression) || owner instanceof PsiParameter)) {
            info = new NlsUnspecified(owner);
        }
        NlsInfo nlsInfo = info;
        if (nlsInfo == null) {
            NlsInfo.$$$reportNull$$$0(19);
        }
        return nlsInfo;
    }

    @NotNull
    private static NlsInfo fromType(PsiType type) {
        if (type == null) {
            NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
            if (nlsUnspecified == null) {
                NlsInfo.$$$reportNull$$$0(20);
            }
            return nlsUnspecified;
        }
        Ref result = Ref.create((Object)NlsUnspecified.UNKNOWN);
        InheritanceUtil.processSuperTypes((PsiType)type, (boolean)true, eachType -> {
            NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)eachType);
            if (info != NlsUnspecified.UNKNOWN) {
                result.set((Object)info);
                return false;
            }
            return !(eachType instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly((PsiType)eachType) instanceof PsiTypeParameter;
        });
        NlsInfo nlsInfo = (NlsInfo)result.get();
        if (nlsInfo == null) {
            NlsInfo.$$$reportNull$$$0(21);
        }
        return nlsInfo;
    }

    @NotNull
    static NlsInfo fromUVariable(@NotNull UVariable owner) {
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(22);
        }
        for (UAnnotation annotation : owner.getUAnnotations()) {
            NlsInfo info = NlsInfo.fromAnnotation(annotation);
            if (info != NlsUnspecified.UNKNOWN) {
                NlsInfo nlsInfo = info;
                if (nlsInfo == null) {
                    NlsInfo.$$$reportNull$$$0(23);
                }
                return nlsInfo;
            }
            info = NlsInfo.fromMetaAnnotation(annotation.resolve());
            if (info == NlsUnspecified.UNKNOWN) continue;
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(24);
            }
            return nlsInfo;
        }
        NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
        if (nlsUnspecified == null) {
            NlsInfo.$$$reportNull$$$0(25);
        }
        return nlsUnspecified;
    }

    @NotNull
    private static NlsInfo fromAnnotationOwner(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
            if (nlsUnspecified == null) {
                NlsInfo.$$$reportNull$$$0(26);
            }
            return nlsUnspecified;
        }
        if (owner instanceof PsiModifierList) {
            NlsInfo nlsInfo = (NlsInfo)CachedValuesManager.getCachedValue((PsiElement)((PsiModifierList)owner), () -> CachedValueProvider.Result.create((Object)NlsInfo.computeFromAnnotationOwner(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(27);
            }
            return nlsInfo;
        }
        return NlsInfo.computeFromAnnotationOwner(owner);
    }

    @NotNull
    private static NlsInfo computeFromAnnotationOwner(@NotNull PsiAnnotationOwner owner) {
        PsiAnnotation annotation;
        PsiElement parent;
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(28);
        }
        for (PsiAnnotation annotation2 : owner.getAnnotations()) {
            NlsInfo info = NlsInfo.fromAnnotation(annotation2);
            if (info != NlsUnspecified.UNKNOWN) {
                NlsInfo nlsInfo = info;
                if (nlsInfo == null) {
                    NlsInfo.$$$reportNull$$$0(29);
                }
                return nlsInfo;
            }
            UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)annotation2, UAnnotation.class);
            if (uAnnotation != null) {
                info = NlsInfo.fromMetaAnnotation(uAnnotation.resolve());
            } else {
                String name = annotation2.getQualifiedName();
                if (name != null) {
                    info = NlsInfo.fromMetaAnnotation(JavaPsiFacade.getInstance((Project)annotation2.getProject()).findClass(name, annotation2.getResolveScope()));
                }
            }
            if (info == NlsUnspecified.UNKNOWN) continue;
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(30);
            }
            return nlsInfo;
        }
        if (owner instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)parent), ANNOTATION_NAMES, (boolean)false)) != null) {
            return NlsInfo.fromAnnotation(annotation);
        }
        NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
        if (nlsUnspecified == null) {
            NlsInfo.$$$reportNull$$$0(31);
        }
        return nlsUnspecified;
    }

    @NotNull
    private static NlsInfo fromMetaAnnotation(@Nullable PsiClass annotationClass) {
        if (annotationClass == null) {
            NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
            if (nlsUnspecified == null) {
                NlsInfo.$$$reportNull$$$0(32);
            }
            return nlsUnspecified;
        }
        NlsInfo baseInfo = NlsUnspecified.UNKNOWN;
        String prefix = "";
        String suffix = "";
        for (PsiAnnotation metaAnno : annotationClass.getAnnotations()) {
            if (metaAnno.hasQualifiedName(NLS_CONTEXT)) {
                prefix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"prefix"));
                suffix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"suffix"));
                continue;
            }
            NlsInfo info = NlsInfo.fromAnnotation(metaAnno);
            if (info == NlsUnspecified.UNKNOWN) continue;
            baseInfo = info;
        }
        if (baseInfo instanceof Localized) {
            Localized localized = ((Localized)baseInfo).withPrefixAndSuffix(prefix, suffix).withAnnotation(annotationClass.getQualifiedName());
            if (localized == null) {
                NlsInfo.$$$reportNull$$$0(33);
            }
            return localized;
        }
        NlsUnspecified nlsUnspecified = baseInfo;
        if (nlsUnspecified == null) {
            NlsInfo.$$$reportNull$$$0(34);
        }
        return nlsUnspecified;
    }

    @NotNull
    private static NlsInfo fromAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NlsInfo.$$$reportNull$$$0(35);
        }
        return NlsInfo.fromAnnotationInfo(annotation.getQualifiedName(), () -> (UExpression)UastContextKt.toUElement((PsiElement)annotation.findAttributeValue("capitalization"), UExpression.class));
    }

    @NotNull
    private static NlsInfo fromAnnotation(@NotNull UAnnotation annotation) {
        if (annotation == null) {
            NlsInfo.$$$reportNull$$$0(36);
        }
        return NlsInfo.fromAnnotationInfo(annotation.getQualifiedName(), () -> annotation.findAttributeValue("capitalization"));
    }

    @NotNull
    private static NlsInfo fromAnnotationInfo(String qualifiedName, Supplier<? extends UExpression> capitalization) {
        if (qualifiedName == null) {
            NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
            if (nlsUnspecified == null) {
                NlsInfo.$$$reportNull$$$0(37);
            }
            return nlsUnspecified;
        }
        if (qualifiedName.equals("org.jetbrains.annotations.NonNls") || qualifiedName.equals("org.jetbrains.annotations.PropertyKey")) {
            NonLocalized nonLocalized = NonLocalized.INSTANCE;
            if (nonLocalized == null) {
                NlsInfo.$$$reportNull$$$0(38);
            }
            return nonLocalized;
        }
        if (qualifiedName.equals(NLS_SAFE) || qualifiedName.equals("org.intellij.lang.annotations.RegExp")) {
            NlsSafe nlsSafe = NlsSafe.INSTANCE;
            if (nlsSafe == null) {
                NlsInfo.$$$reportNull$$$0(39);
            }
            return nlsSafe;
        }
        if (qualifiedName.equals("org.jetbrains.annotations.Nls")) {
            UExpression value = capitalization.get();
            String name = null;
            if (value instanceof UReferenceExpression) {
                name = ((UReferenceExpression)value).getResolvedName();
            }
            if (name != null) {
                if (Nls.Capitalization.Title.name().equals(name)) {
                    Localized localized = Localized.NLS_TITLE;
                    if (localized == null) {
                        NlsInfo.$$$reportNull$$$0(40);
                    }
                    return localized;
                }
                if (Nls.Capitalization.Sentence.name().equals(name)) {
                    Localized localized = Localized.NLS_SENTENCE;
                    if (localized == null) {
                        NlsInfo.$$$reportNull$$$0(41);
                    }
                    return localized;
                }
            }
            Localized localized = Localized.NLS;
            if (localized == null) {
                NlsInfo.$$$reportNull$$$0(42);
            }
            return localized;
        }
        NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
        if (nlsUnspecified == null) {
            NlsInfo.$$$reportNull$$$0(43);
        }
        return nlsUnspecified;
    }

    @NotNull
    private static NlsInfo fromContainer(@NotNull PsiMember member) {
        if (member == null) {
            NlsInfo.$$$reportNull$$$0(44);
        }
        for (PsiClass containingClass = member.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            NlsInfo classInfo = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)containingClass.getModifierList());
            if (classInfo == NlsUnspecified.UNKNOWN) continue;
            NlsInfo nlsInfo = classInfo;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(45);
            }
            return nlsInfo;
        }
        PsiFile containingFile = member.getContainingFile();
        if (containingFile instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)member.getProject()).findPackage(packageName);
            if (aPackage != null) {
                NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)aPackage.getAnnotationList());
                if (info != NlsUnspecified.UNKNOWN) {
                    NlsInfo nlsInfo = info;
                    if (nlsInfo == null) {
                        NlsInfo.$$$reportNull$$$0(46);
                    }
                    return nlsInfo;
                }
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, ANNOTATION_NAMES, (boolean)false);
                if (annotation != null) {
                    return NlsInfo.fromAnnotation(annotation);
                }
            }
        }
        NlsUnspecified nlsUnspecified = NlsUnspecified.UNKNOWN;
        if (nlsUnspecified == null) {
            NlsInfo.$$$reportNull$$$0(47);
        }
        return nlsUnspecified;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nls";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/NlsInfo";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 13: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/NlsInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNlsStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "localized";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "nonLocalized";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromEqualityCheck";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromVariableReference";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapitalization";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotationContext";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fromType";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUVariable";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotationOwner";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFromAnnotationOwner";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMetaAnnotation";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotationInfo";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "fromContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromEqualityCheck";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forModifierListOwner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCapitalization";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fromUVariable";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "computeFromAnnotationOwner";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fromContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class NlsUnspecified
    extends NlsInfo {
        private static final NlsUnspecified UNKNOWN = new NlsUnspecified(null);
        @Nullable
        private final PsiModifierListOwner myCandidate;

        private NlsUnspecified(@Nullable PsiModifierListOwner candidate) {
            super(ThreeState.UNSURE);
            this.myCandidate = candidate;
        }

        @Nullable
        public PsiModifierListOwner getAnnotationCandidate() {
            return this.myCandidate;
        }

        @NotNull
        public RestrictionInfo.RestrictionInfoKind getKind() {
            RestrictionInfo.RestrictionInfoKind restrictionInfoKind = this == UNKNOWN ? RestrictionInfo.RestrictionInfoKind.UNKNOWN : RestrictionInfo.RestrictionInfoKind.UNSPECIFIED;
            if (restrictionInfoKind == null) {
                NlsUnspecified.$$$reportNull$$$0(0);
            }
            return restrictionInfoKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/NlsInfo$NlsUnspecified", "getKind"));
        }
    }

    public static final class NonLocalized
    extends NlsInfo {
        private static final NonLocalized INSTANCE = new NonLocalized();

        private NonLocalized() {
            super(ThreeState.NO);
        }

        @NotNull
        public RestrictionInfo.RestrictionInfoKind getKind() {
            RestrictionInfo.RestrictionInfoKind restrictionInfoKind = RestrictionInfo.RestrictionInfoKind.KNOWN;
            if (restrictionInfoKind == null) {
                NonLocalized.$$$reportNull$$$0(0);
            }
            return restrictionInfoKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/NlsInfo$NonLocalized", "getKind"));
        }
    }

    public static final class NlsSafe
    extends NlsInfo {
        private static final NlsSafe INSTANCE = new NlsSafe();

        private NlsSafe() {
            super(ThreeState.NO);
        }

        @NotNull
        public RestrictionInfo.RestrictionInfoKind getKind() {
            RestrictionInfo.RestrictionInfoKind restrictionInfoKind = RestrictionInfo.RestrictionInfoKind.KNOWN;
            if (restrictionInfoKind == null) {
                NlsSafe.$$$reportNull$$$0(0);
            }
            return restrictionInfoKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/NlsInfo$NlsSafe", "getKind"));
        }
    }

    public static final class Localized
    extends NlsInfo {
        private static final Localized NLS = new Localized(Nls.Capitalization.NotSpecified, "", "", null);
        private static final Localized NLS_TITLE = new Localized(Nls.Capitalization.Title, "", "", null);
        private static final Localized NLS_SENTENCE = new Localized(Nls.Capitalization.Sentence, "", "", null);
        @NotNull
        private final Nls.Capitalization myCapitalization;
        @NotNull
        @NonNls
        private final String myPrefix;
        @NotNull
        @NonNls
        private final String mySuffix;
        private final String myAnnotationName;

        private Localized(@NotNull Nls.Capitalization capitalization, @NotNull @NonNls String prefix, @NotNull @NonNls String suffix, @Nullable @NonNls String annotationName) {
            if (capitalization == null) {
                Localized.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                Localized.$$$reportNull$$$0(1);
            }
            if (suffix == null) {
                Localized.$$$reportNull$$$0(2);
            }
            super(ThreeState.YES);
            this.myCapitalization = capitalization;
            this.myPrefix = prefix;
            this.mySuffix = suffix;
            this.myAnnotationName = annotationName;
        }

        @NotNull
        public Nls.Capitalization getCapitalization() {
            Nls.Capitalization capitalization = this.myCapitalization;
            if (capitalization == null) {
                Localized.$$$reportNull$$$0(3);
            }
            return capitalization;
        }

        @NotNull
        public String suggestAnnotation(PsiElement context) {
            if (this.myAnnotationName != null && JavaPsiFacade.getInstance((Project)context.getProject()).findClass(this.myAnnotationName, context.getResolveScope()) != null) {
                String string = this.myAnnotationName;
                if (string == null) {
                    Localized.$$$reportNull$$$0(4);
                }
                return string;
            }
            return "org.jetbrains.annotations.Nls";
        }

        @NotNull
        @NonNls
        public String getPrefix() {
            String string = this.myPrefix;
            if (string == null) {
                Localized.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String getSuffix() {
            String string = this.mySuffix;
            if (string == null) {
                Localized.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        private Localized withPrefixAndSuffix(@NotNull String prefix, @NotNull String suffix) {
            if (prefix == null) {
                Localized.$$$reportNull$$$0(7);
            }
            if (suffix == null) {
                Localized.$$$reportNull$$$0(8);
            }
            if (prefix.equals(this.myPrefix) && suffix.equals(this.mySuffix)) {
                Localized localized = this;
                if (localized == null) {
                    Localized.$$$reportNull$$$0(9);
                }
                return localized;
            }
            return new Localized(this.myCapitalization, prefix, suffix, this.myAnnotationName);
        }

        @NotNull
        private Localized withAnnotation(@Nullable String qualifiedName) {
            if (Objects.equals(qualifiedName, this.myAnnotationName)) {
                Localized localized = this;
                if (localized == null) {
                    Localized.$$$reportNull$$$0(10);
                }
                return localized;
            }
            return new Localized(this.myCapitalization, this.myPrefix, this.mySuffix, qualifiedName);
        }

        @NotNull
        public RestrictionInfo.RestrictionInfoKind getKind() {
            RestrictionInfo.RestrictionInfoKind restrictionInfoKind = RestrictionInfo.RestrictionInfoKind.KNOWN;
            if (restrictionInfoKind == null) {
                Localized.$$$reportNull$$$0(11);
            }
            return restrictionInfoKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/NlsInfo$Localized";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/NlsInfo$Localized";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCapitalization";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestAnnotation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixAndSuffix";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAnnotation";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixAndSuffix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NlsInfoFactory
    implements RestrictionInfoFactory<NlsInfo> {
        private static final NlsInfoFactory INSTANCE = new NlsInfoFactory();

        private NlsInfoFactory() {
        }

        @NotNull
        public NlsInfo fromAnnotationOwner(@Nullable PsiAnnotationOwner annotationOwner) {
            NlsInfo nlsInfo = NlsInfo.fromAnnotationOwner(annotationOwner);
            if (nlsInfo == null) {
                NlsInfoFactory.$$$reportNull$$$0(0);
            }
            return nlsInfo;
        }

        @NotNull
        public NlsInfo fromModifierListOwner(@NotNull PsiModifierListOwner modifierListOwner) {
            if (modifierListOwner == null) {
                NlsInfoFactory.$$$reportNull$$$0(1);
            }
            NlsInfo nlsInfo = NlsInfo.fromAnnotationContext(null, AnnotationContext.fromModifierListOwner((PsiModifierListOwner)modifierListOwner));
            if (nlsInfo == null) {
                NlsInfoFactory.$$$reportNull$$$0(2);
            }
            return nlsInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/NlsInfo$NlsInfoFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierListOwner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromAnnotationOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/NlsInfo$NlsInfoFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromModifierListOwner";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromModifierListOwner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

