/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api.util;

import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.intellij.pom.java.LanguageLevel;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageLevelUtil {
    @Nullable
    public static LanguageLevel parseFromGradleString(@NotNull String gradleString) {
        if (gradleString == null) {
            LanguageLevelUtil.$$$reportNull$$$0(0);
        }
        String digitalVersion = gradleString.startsWith("JavaVersion.VERSION_") ? gradleString.substring("JavaVersion.VERSION_".length()).replace('_', '.') : (gradleString.startsWith("VERSION_") ? gradleString.substring("VERSION_".length()).replace('_', '.') : (gradleString.startsWith("'") || gradleString.startsWith("\"") ? gradleString.substring(1, gradleString.length() - 1) : gradleString));
        return LanguageLevel.parse((String)digitalVersion);
    }

    @NotNull
    public static Object convertToGradleString(@NotNull LanguageLevel languageLevel, @Nullable String sampleGradleString) {
        if (languageLevel == null) {
            LanguageLevelUtil.$$$reportNull$$$0(1);
        }
        String underscoreVersion = languageLevel.name().substring("JDK_".length());
        String dotVersion = underscoreVersion.replace('_', '.');
        if (sampleGradleString != null) {
            if (sampleGradleString.startsWith("JavaVersion.VERSION_")) {
                return new RawText("JavaVersion.VERSION_" + underscoreVersion, "JavaVersion.VERSION_" + underscoreVersion);
            }
            if (sampleGradleString.startsWith("VERSION_")) {
                return new RawText("VERSION_" + underscoreVersion, "VERSION_" + underscoreVersion);
            }
            if (sampleGradleString.startsWith("'")) {
                String string = "'" + dotVersion + "'";
                if (string == null) {
                    LanguageLevelUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (sampleGradleString.startsWith("\"")) {
                String string = "\"" + dotVersion + "\"";
                if (string == null) {
                    LanguageLevelUtil.$$$reportNull$$$0(3);
                }
                return string;
            }
            try {
                return new BigDecimal(dotVersion);
            }
            catch (NumberFormatException e) {
                String string = dotVersion;
                if (string == null) {
                    LanguageLevelUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        return new RawText("JavaVersion.VERSION_" + underscoreVersion, "JavaVersion.VERSION_" + underscoreVersion);
    }

    @Nullable
    public static String getStringToParse(ResolvedPropertyModel model) {
        Object stringToParse;
        switch (model.getValueType()) {
            case BIG_DECIMAL: 
            case INTEGER: 
            case REFERENCE: 
            case CUSTOM: {
                stringToParse = model.toString();
                break;
            }
            case STRING: {
                stringToParse = "'" + model.toString() + "'";
                break;
            }
            default: {
                stringToParse = null;
            }
        }
        return stringToParse;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/api/util/LanguageLevelUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/api/util/LanguageLevelUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToGradleString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFromGradleString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertToGradleString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

