/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.execution.Location;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a(\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u0011\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\nH\u0002\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\nH\u0002\u00a8\u0006\u0018"}, d2={"createLocationName", "", "aClass", "method", "createTestFilter", "filter", "createTestFilterFrom", "location", "Lcom/intellij/execution/Location;", "psiClass", "Lcom/intellij/psi/PsiClass;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "methodName", "psiPackage", "Lcom/intellij/psi/PsiPackage;", "createTestFilterFromClass", "createTestFilterFromMethod", "createTestFilterFromPackage", "aPackage", "createTestWildcardFilter", "getRuntimeQualifiedName", "isParameterized", "", "intellij.gradle.java"})
@JvmName(name="GradleExecutionSettingsUtil")
public final class GradleExecutionSettingsUtil {
    private static final String createTestFilter(String filter) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "--tests %s";
        Object[] objectArray = new Object[]{filter};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final String createTestFilterFrom(String filter) {
        String escaped = StringsKt.replace$default((String)filter, (char)'\"', (char)'*', (boolean)false, (int)4, null);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "\"%s\"";
        Object[] objectArray = new Object[]{escaped};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String wrapped = string2;
        return GradleExecutionSettingsUtil.createTestFilter(wrapped);
    }

    private static final String createLocationName(String aClass, String method) {
        if (aClass == null) {
            return "";
        }
        String string = method;
        String escapedMethod = string != null ? StringsKt.replace$default((String)string, (char)'.', (char)'*', (boolean)false, (int)4, null) : null;
        return aClass + (String)(escapedMethod == null ? "" : "." + escapedMethod);
    }

    @NotNull
    public static final String createTestFilterFromMethod(@Nullable String aClass, @Nullable String method) {
        return GradleExecutionSettingsUtil.createTestFilterFrom(GradleExecutionSettingsUtil.createLocationName(aClass, method));
    }

    @NotNull
    public static final String createTestFilterFromClass(@Nullable String aClass) {
        if (aClass == null) {
            return "";
        }
        return GradleExecutionSettingsUtil.createTestFilterFrom(aClass);
    }

    @NotNull
    public static final String createTestWildcardFilter() {
        return GradleExecutionSettingsUtil.createTestFilter("*");
    }

    @NotNull
    public static final String createTestFilterFromPackage(@NotNull String aPackage) {
        Intrinsics.checkNotNullParameter((Object)aPackage, (String)"aPackage");
        CharSequence charSequence = aPackage;
        if (charSequence.length() == 0) {
            return GradleExecutionSettingsUtil.createTestWildcardFilter();
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s.*";
        Object[] objectArray = new Object[]{aPackage};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String packageFilter = string2;
        return GradleExecutionSettingsUtil.createTestFilterFrom(packageFilter);
    }

    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return GradleExecutionSettingsUtil.createTestFilterFromClass(GradleExecutionSettingsUtil.getRuntimeQualifiedName(psiClass));
    }

    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiClass psiClass, @Nullable String methodName) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return GradleExecutionSettingsUtil.createTestFilterFromMethod(GradleExecutionSettingsUtil.getRuntimeQualifiedName(psiClass), methodName);
    }

    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiClass psiClass, @NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        return GradleExecutionSettingsUtil.createTestFilterFrom(psiClass, psiMethod.getName());
    }

    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiPackage psiPackage) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        String string = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiPackage.qualifiedName");
        return GradleExecutionSettingsUtil.createTestFilterFromPackage(string);
    }

    @NotNull
    public static final String createTestFilterFrom(@Nullable Location<?> location, @Nullable PsiClass psiClass, @Nullable PsiMethod psiMethod) {
        PsiClass psiClass2 = psiClass;
        String className = psiClass2 != null ? GradleExecutionSettingsUtil.getRuntimeQualifiedName(psiClass2) : null;
        PsiMethod psiMethod2 = psiMethod;
        String methodName = psiMethod2 != null ? psiMethod2.getName() : null;
        Object locationName = GradleExecutionSettingsUtil.createLocationName(className, methodName);
        if (location instanceof PsiMemberParameterizedLocation) {
            String wrappedParamSetName;
            String string = wrappedParamSetName = ((PsiMemberParameterizedLocation)location).getParamSetName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrappedParamSetName");
            CharSequence charSequence = string;
            if (charSequence.length() > 0) {
                String paramSetName = StringsKt.removeSurrounding((String)wrappedParamSetName, (CharSequence)"[", (CharSequence)"]");
                locationName = (String)locationName + "[*" + paramSetName + "*]";
            }
        } else if (psiClass != null && GradleExecutionSettingsUtil.isParameterized(psiClass)) {
            locationName = (String)locationName + "[*]";
        }
        return GradleExecutionSettingsUtil.createTestFilterFrom((String)locationName);
    }

    private static final String getRuntimeQualifiedName(PsiClass $this$getRuntimeQualifiedName) {
        PsiElement parent = $this$getRuntimeQualifiedName.getParent();
        return parent instanceof PsiClass ? GradleExecutionSettingsUtil.getRuntimeQualifiedName((PsiClass)parent) + "$" + $this$getRuntimeQualifiedName.getName() : $this$getRuntimeQualifiedName.getQualifiedName();
    }

    private static final boolean isParameterized(PsiClass $this$isParameterized) {
        PsiAnnotation annotation = JUnitUtil.getRunWithAnnotation((PsiClass)$this$isParameterized);
        return annotation != null && JUnitUtil.isParameterized((PsiAnnotation)annotation);
    }
}

