/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;

public class AntBuildTrigger
extends AbstractTrigger
implements Trigger {
    private boolean onlyOnce = true;
    private String target = null;
    private Collection<String> builds = new ArrayList<String>();
    private String buildFilePattern;
    private String prefix;

    @Override
    public void progress(IvyEvent event2) {
        File f = this.getBuildFile(event2);
        if (f.exists()) {
            if (this.onlyOnce && this.isBuilt(f)) {
                Message.verbose("target build file already built, skipping: " + f);
            } else {
                Ant ant = new Ant();
                Project project2 = (Project)IvyContext.peekInContextStack("ant-project");
                if (project2 == null) {
                    project2 = new Project();
                    project2.init();
                }
                ant.setProject(project2);
                ant.setTaskName("ant");
                ant.setAntfile(f.getAbsolutePath());
                ant.setInheritAll(false);
                String target = this.getTarget();
                if (target != null) {
                    ant.setTarget(target);
                }
                for (Map.Entry<String, String> entry : event2.getAttributes().entrySet()) {
                    if (entry.getValue() == null) continue;
                    Property p2 = ant.createProperty();
                    p2.setName(this.prefix == null ? entry.getKey() : this.prefix + entry.getKey());
                    p2.setValue(entry.getValue());
                }
                Message.verbose("triggering build: " + f + " target=" + target + " for " + event2);
                try {
                    ant.execute();
                }
                catch (BuildException e) {
                    Message.verbose("Exception occurred while executing target " + target);
                    throw e;
                }
                this.markBuilt(f);
                Message.debug("triggered build finished: " + f + " target=" + target + " for " + event2);
            }
        } else {
            Message.verbose("no build file found for dependency, skipping: " + f);
        }
    }

    private void markBuilt(File f) {
        this.builds.add(f.getAbsolutePath());
    }

    private boolean isBuilt(File f) {
        return this.builds.contains(f.getAbsolutePath());
    }

    private File getBuildFile(IvyEvent event2) {
        return IvyContext.getContext().getSettings().resolveFile(IvyPatternHelper.substituteTokens(this.getBuildFilePattern(), event2.getAttributes()));
    }

    public String getBuildFilePattern() {
        return this.buildFilePattern;
    }

    public void setAntfile(String pattern2) {
        this.buildFilePattern = pattern2;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isOnlyonce() {
        return this.onlyOnce;
    }

    public void setOnlyonce(boolean onlyonce) {
        this.onlyOnce = onlyonce;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (!prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }
}

