/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.blobs;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import libraries.io.blobs.MessageDigestPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Llibraries/io/blobs/MessageDigestsPools;", "", "()V", "algorithmNameAliases", "Ljava/util/TreeMap;", "", "pools", "", "Llibraries/io/blobs/MessageDigestPool;", "getAlgorithmName", "algorithm", "getPool", "libraries-io"})
public final class MessageDigestsPools {
    @NotNull
    public static final MessageDigestsPools INSTANCE;
    @NotNull
    private static final Map<String, MessageDigestPool> pools;
    @NotNull
    private static final TreeMap<String, String> algorithmNameAliases;

    private MessageDigestsPools() {
    }

    @NotNull
    public final MessageDigestPool getPool(@NotNull String algorithm) {
        MessageDigestPool messageDigestPool;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        String algorithmName = this.getAlgorithmName(algorithm);
        Map<String, MessageDigestPool> $this$getOrPut$iv = pools;
        boolean $i$f$getOrPut = false;
        MessageDigestPool value$iv = $this$getOrPut$iv.get(algorithmName);
        if (value$iv == null) {
            boolean bl = false;
            MessageDigestPool answer$iv = new MessageDigestPool(algorithmName);
            $this$getOrPut$iv.put(algorithmName, answer$iv);
            messageDigestPool = answer$iv;
        } else {
            messageDigestPool = value$iv;
        }
        return messageDigestPool;
    }

    private final String getAlgorithmName(String algorithm) {
        return algorithmNameAliases.getOrDefault(algorithm, algorithm);
    }

    static {
        TreeMap<String, String> treeMap;
        INSTANCE = new MessageDigestsPools();
        pools = new LinkedHashMap();
        TreeMap<String, String> $this$algorithmNameAliases_u24lambda_u2d0 = treeMap = new TreeMap<String, String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        boolean bl = false;
        $this$algorithmNameAliases_u24lambda_u2d0.put("SHA1", "SHA");
        $this$algorithmNameAliases_u24lambda_u2d0.put("SHA256", "SHA-256");
        $this$algorithmNameAliases_u24lambda_u2d0.put("SHA512", "SHA-512");
        algorithmNameAliases = treeMap;
    }
}

