/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangePreviewLayoutAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "layout", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "(Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "EditorAndPreview", "EditorOnly", "PreviewOnly", "intellij.markdown.core"})
public abstract class ChangePreviewLayoutAction
extends ToggleAction
implements DumbAware {
    private final TextEditorWithPreview.Layout layout;

    public boolean isSelected(@NotNull AnActionEvent event) {
        MarkdownEditorWithPreview editor2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownEditorWithPreview markdownEditorWithPreview = editor2 = MarkdownActionUtil.findSplitEditor(event);
        return (markdownEditorWithPreview != null ? markdownEditorWithPreview.getLayout() : null) == this.layout;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownEditorWithPreview markdownEditorWithPreview = MarkdownActionUtil.findSplitEditor(event);
        if (markdownEditorWithPreview == null) {
            return;
        }
        MarkdownEditorWithPreview editor2 = markdownEditorWithPreview;
        if (state) {
            editor2.setLayout(this.layout);
        } else if (this.layout == TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW) {
            editor2.setVerticalSplit(!editor2.isVerticalSplit());
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        MarkdownEditorWithPreview markdownEditorWithPreview = MarkdownActionUtil.findSplitEditor(event);
        if (markdownEditorWithPreview == null) {
            return;
        }
        MarkdownEditorWithPreview editor2 = markdownEditorWithPreview;
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        presentation.setIcon(this.layout.getIcon((TextEditorWithPreview)editor2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public ChangePreviewLayoutAction(@NotNull TextEditorWithPreview.Layout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        super(layout.getName(), layout.getName(), layout.getIcon(null));
        this.layout = layout;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangePreviewLayoutAction$EditorOnly;", "Lorg/intellij/plugins/markdown/ui/actions/ChangePreviewLayoutAction;", "()V", "intellij.markdown.core"})
    public static final class EditorOnly
    extends ChangePreviewLayoutAction {
        public EditorOnly() {
            super(TextEditorWithPreview.Layout.SHOW_EDITOR);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangePreviewLayoutAction$EditorAndPreview;", "Lorg/intellij/plugins/markdown/ui/actions/ChangePreviewLayoutAction;", "()V", "intellij.markdown.core"})
    public static final class EditorAndPreview
    extends ChangePreviewLayoutAction {
        public EditorAndPreview() {
            super(TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangePreviewLayoutAction$PreviewOnly;", "Lorg/intellij/plugins/markdown/ui/actions/ChangePreviewLayoutAction;", "()V", "intellij.markdown.core"})
    public static final class PreviewOnly
    extends ChangePreviewLayoutAction {
        public PreviewOnly() {
            super(TextEditorWithPreview.Layout.SHOW_PREVIEW);
        }
    }
}

