/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaSystemPropertiesProxySettings
implements HttpProxySettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaSystemPropertiesProxySettings.class);
    private final HttpProxySettings.HttpProxy proxy;
    private final List<Pattern> nonProxyHosts;
    private final String propertyPrefix;
    private final int defaultPort;

    public JavaSystemPropertiesProxySettings(String propertyPrefix, int defaultPort) {
        this(propertyPrefix, defaultPort, System.getProperty(propertyPrefix + ".proxyHost"), System.getProperty(propertyPrefix + ".proxyPort"), System.getProperty(propertyPrefix + ".proxyUser"), System.getProperty(propertyPrefix + ".proxyPassword"), System.getProperty(propertyPrefix + ".nonProxyHosts"));
    }

    JavaSystemPropertiesProxySettings(String propertyPrefix, int defaultPort, String proxyHost, String proxyPortString, String proxyUser, String proxyPassword, String nonProxyHostsString) {
        this.propertyPrefix = propertyPrefix;
        this.defaultPort = defaultPort;
        this.proxy = StringUtils.isBlank((String)proxyHost) ? null : new HttpProxySettings.HttpProxy(proxyHost, this.initProxyPort(proxyPortString), proxyUser, proxyPassword);
        this.nonProxyHosts = this.initNonProxyHosts(nonProxyHostsString);
    }

    private int initProxyPort(String proxyPortString) {
        if (StringUtils.isBlank((String)proxyPortString)) {
            return this.defaultPort;
        }
        try {
            return Integer.parseInt(proxyPortString);
        }
        catch (NumberFormatException e) {
            String key = this.propertyPrefix + ".proxyPort";
            LOGGER.warn("Invalid value for java system property '{}': {}. Default port '{}' will be used.", new Object[]{key, System.getProperty(key), this.defaultPort});
            return this.defaultPort;
        }
    }

    private List<Pattern> initNonProxyHosts(String nonProxyHostsString) {
        if (StringUtils.isBlank((String)nonProxyHostsString)) {
            return Collections.emptyList();
        }
        LOGGER.debug("Found java system property 'http.nonProxyHosts': {}. Will ignore proxy settings for these hosts.", (Object)nonProxyHostsString);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String nonProxyHost : nonProxyHostsString.split("\\|")) {
            patterns.add(this.createHostMatcher(nonProxyHost));
        }
        return patterns;
    }

    private Pattern createHostMatcher(String nonProxyHost) {
        if (nonProxyHost.startsWith("*")) {
            return Pattern.compile(".*" + Pattern.quote(nonProxyHost.substring(1)));
        }
        if (nonProxyHost.endsWith("*")) {
            return Pattern.compile(Pattern.quote(nonProxyHost.substring(0, nonProxyHost.length() - 1)) + ".*");
        }
        return Pattern.compile(Pattern.quote(nonProxyHost));
    }

    @Override
    public HttpProxySettings.HttpProxy getProxy() {
        return this.proxy;
    }

    @Override
    public HttpProxySettings.HttpProxy getProxy(String host) {
        if (this.proxy == null || this.isNonProxyHost(host)) {
            return null;
        }
        return this.proxy;
    }

    private boolean isNonProxyHost(String host) {
        for (Pattern nonProxyHost : this.nonProxyHosts) {
            if (!nonProxyHost.matcher(host).matches()) continue;
            return true;
        }
        return false;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }
}

