/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.events.UpdateNowEvent;
import org.gradle.internal.logging.format.LogHeaderFormatter;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.util.internal.GUtil;

public class GroupingProgressLogEventGenerator
implements OutputEventListener {
    private static final long HIGH_WATERMARK_FLUSH_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long LOW_WATERMARK_FLUSH_TIMEOUT = TimeUnit.SECONDS.toMillis(2L);
    private final OutputEventListener listener;
    private final LogHeaderFormatter headerFormatter;
    private final boolean verbose;
    private final Map<OperationIdentifier, OperationState> operationsInProgress = new LinkedHashMap<OperationIdentifier, OperationState>();
    private Object lastRenderedBuildOpId;
    private boolean needHeaderSeparator;
    private long currentTimePeriod;

    public GroupingProgressLogEventGenerator(OutputEventListener listener2, LogHeaderFormatter headerFormatter, boolean verbose) {
        this.listener = listener2;
        this.headerFormatter = headerFormatter;
        this.verbose = verbose;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            this.onStart((ProgressStartEvent)event);
        } else if (event instanceof RenderableOutputEvent) {
            this.handleOutput((RenderableOutputEvent)event);
        } else if (event instanceof ProgressCompleteEvent) {
            this.onComplete((ProgressCompleteEvent)event);
        } else if (event instanceof EndOutputEvent) {
            this.onEnd((EndOutputEvent)event);
        } else if (event instanceof UpdateNowEvent) {
            this.onUpdateNow((UpdateNowEvent)event);
        } else if (!(event instanceof ProgressEvent)) {
            this.listener.onOutput(event);
        }
    }

    private void onStart(ProgressStartEvent startEvent) {
        boolean isGrouped = startEvent.getBuildOperationCategory().isGrouped();
        OperationIdentifier progressId = startEvent.getProgressOperationId();
        if (startEvent.isBuildOperationStart() && isGrouped) {
            this.operationsInProgress.put(progressId, new OperationGroup(startEvent.getCategory(), startEvent.getDescription(), startEvent.getTimestamp(), startEvent.getParentProgressOperationId(), progressId, startEvent.getBuildOperationCategory()));
        } else {
            this.operationsInProgress.put(progressId, new OperationState(startEvent.getParentProgressOperationId(), progressId));
        }
        if (!isGrouped && GUtil.isTrue(startEvent.getLoggingHeader())) {
            this.onUngroupedOutput(new LogEvent(startEvent.getTimestamp(), startEvent.getCategory(), startEvent.getLogLevel(), startEvent.getLoggingHeader(), null, null));
        }
    }

    private void handleOutput(RenderableOutputEvent event) {
        OperationGroup group = this.getGroupFor(event.getBuildOperationId());
        if (group != null) {
            group.bufferOutput(event);
        } else {
            this.onUngroupedOutput(event);
        }
    }

    private void onComplete(ProgressCompleteEvent completeEvent) {
        OperationState state2 = this.operationsInProgress.remove(completeEvent.getProgressOperationId());
        if (state2 instanceof OperationGroup) {
            OperationGroup group = (OperationGroup)state2;
            group.setStatus(completeEvent.getStatus(), completeEvent.isFailed());
            group.flushOutput();
            if (group.hasForeground()) {
                this.lastRenderedBuildOpId = null;
            }
        }
    }

    private void onEnd(EndOutputEvent event) {
        for (OperationState state2 : this.operationsInProgress.values()) {
            state2.flushOutput();
        }
        this.listener.onOutput(event);
        this.operationsInProgress.clear();
    }

    private void onUpdateNow(UpdateNowEvent event) {
        this.currentTimePeriod = event.getTimestamp();
        for (OperationState state2 : this.operationsInProgress.values()) {
            state2.maybeFlushOutput(event.getTimestamp());
        }
    }

    private void onUngroupedOutput(RenderableOutputEvent event) {
        if (this.lastRenderedBuildOpId != null) {
            this.listener.onOutput(GroupingProgressLogEventGenerator.spacerLine(event.getTimestamp(), event.getCategory()));
            this.lastRenderedBuildOpId = null;
            this.needHeaderSeparator = true;
        }
        this.listener.onOutput(event);
    }

    private OperationGroup getGroupFor(@Nullable OperationIdentifier progressId) {
        OperationState state2;
        OperationIdentifier current = progressId;
        while (current != null && (state2 = this.operationsInProgress.get(current)) != null) {
            if (state2 instanceof OperationGroup) {
                return (OperationGroup)state2;
            }
            current = state2.parentProgressOp;
        }
        return null;
    }

    private static LogEvent spacerLine(long timestamp, String category) {
        return new LogEvent(timestamp, category, LogLevel.LIFECYCLE, "", null);
    }

    private class OperationGroup
    extends OperationState {
        private final String category;
        private long lastUpdateTime;
        private final String description;
        private final BuildOperationCategory buildOperationCategory;
        private String status;
        private String lastHeaderStatus;
        private boolean failed;
        private boolean headerSent;
        private boolean outputRendered;
        private List<RenderableOutputEvent> bufferedLogs;

        OperationGroup(String category, String description, @Nullable long startTime, OperationIdentifier parentBuildOp, OperationIdentifier buildOpIdentifier, BuildOperationCategory buildOperationCategory) {
            super(parentBuildOp, buildOpIdentifier);
            this.status = "";
            this.lastHeaderStatus = "";
            this.bufferedLogs = new ArrayList<RenderableOutputEvent>();
            this.category = category;
            this.lastUpdateTime = startTime;
            this.description = description;
            this.buildOperationCategory = buildOperationCategory;
        }

        private StyledTextOutputEvent header() {
            return new StyledTextOutputEvent(this.lastUpdateTime, this.category, LogLevel.LIFECYCLE, this.buildOpIdentifier, GroupingProgressLogEventGenerator.this.headerFormatter.format(this.description, this.status, this.failed));
        }

        void bufferOutput(RenderableOutputEvent output) {
            if (Objects.equal((Object)this.buildOpIdentifier, (Object)GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId)) {
                GroupingProgressLogEventGenerator.this.listener.onOutput(output);
                this.lastUpdateTime = GroupingProgressLogEventGenerator.this.currentTimePeriod;
                GroupingProgressLogEventGenerator.this.needHeaderSeparator = true;
            } else {
                this.bufferedLogs.add(output);
            }
        }

        @Override
        void flushOutput() {
            if (this.shouldForward()) {
                boolean hasContent;
                boolean bl = hasContent = !this.bufferedLogs.isEmpty();
                if (!this.hasForeground() || this.statusHasChanged()) {
                    if (GroupingProgressLogEventGenerator.this.needHeaderSeparator || hasContent) {
                        GroupingProgressLogEventGenerator.this.listener.onOutput(GroupingProgressLogEventGenerator.spacerLine(this.lastUpdateTime, this.category));
                    }
                    GroupingProgressLogEventGenerator.this.listener.onOutput(this.header());
                    this.headerSent = true;
                    this.lastHeaderStatus = this.status;
                }
                for (RenderableOutputEvent renderableEvent : this.bufferedLogs) {
                    this.outputRendered = true;
                    GroupingProgressLogEventGenerator.this.listener.onOutput(renderableEvent);
                }
                GroupingProgressLogEventGenerator.this.needHeaderSeparator = hasContent;
                this.bufferedLogs.clear();
                this.lastUpdateTime = GroupingProgressLogEventGenerator.this.currentTimePeriod;
                GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId = this.buildOpIdentifier;
            }
        }

        @Override
        void maybeFlushOutput(long eventTimestamp) {
            if (this.timeoutExpired(eventTimestamp, HIGH_WATERMARK_FLUSH_TIMEOUT) || this.timeoutExpired(eventTimestamp, LOW_WATERMARK_FLUSH_TIMEOUT) && this.canClaimForeground()) {
                this.flushOutput();
            }
        }

        private boolean timeoutExpired(long eventTimestamp, long timeout) {
            return eventTimestamp - this.lastUpdateTime > timeout;
        }

        private boolean canClaimForeground() {
            return this.hasForeground() || !this.bufferedLogs.isEmpty() && GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId == null;
        }

        private boolean hasForeground() {
            return this.buildOpIdentifier.equals(GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId);
        }

        private boolean statusHasChanged() {
            return !this.status.equals(this.lastHeaderStatus);
        }

        private void setStatus(String status, boolean failed) {
            this.status = status;
            this.failed = failed;
        }

        private boolean shouldPrintHeader() {
            return !(!GroupingProgressLogEventGenerator.this.verbose && !this.outputRendered || this.headerSent && !this.statusHasChanged());
        }

        private boolean statusIsFailed() {
            return this.failed && this.statusHasChanged();
        }

        private boolean shouldForward() {
            return !this.bufferedLogs.isEmpty() || this.buildOperationCategory.isShowHeader() && (this.shouldPrintHeader() || this.statusIsFailed());
        }
    }

    private static class OperationState {
        @Nullable
        final OperationIdentifier parentProgressOp;
        final OperationIdentifier buildOpIdentifier;

        OperationState(@Nullable OperationIdentifier parentProgressOp, OperationIdentifier buildOpIdentifier) {
            this.parentProgressOp = parentProgressOp;
            this.buildOpIdentifier = buildOpIdentifier;
        }

        void flushOutput() {
        }

        void maybeFlushOutput(long timestamp) {
        }
    }
}

