/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.util.Optional;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.IncrementalChangesContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.work.InputChanges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveInputChangesStep<C extends IncrementalChangesContext, R extends Result>
implements Step<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveInputChangesStep.class);
    private final Step<? super InputChangesContext, ? extends R> delegate;

    public ResolveInputChangesStep(Step<? super InputChangesContext, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        final Optional<InputChangesInternal> inputChanges = ResolveInputChangesStep.determineInputChanges(work, context);
        return this.delegate.execute(work, new InputChangesContext((IncrementalChangesContext)context){
            final /* synthetic */ IncrementalChangesContext val$context;
            {
                this.val$context = incrementalChangesContext;
            }

            @Override
            public Optional<InputChangesInternal> getInputChanges() {
                return inputChanges;
            }

            @Override
            public boolean isIncrementalExecution() {
                return inputChanges.map(InputChanges::isIncremental).orElse(false);
            }

            @Override
            public Optional<String> getNonIncrementalReason() {
                return this.val$context.getNonIncrementalReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return this.val$context.getValidationContext();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.val$context.getInputProperties();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.val$context.getInputFileProperties();
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return this.val$context.getIdentity();
            }

            @Override
            public File getWorkspace() {
                return this.val$context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return this.val$context.getHistory();
            }

            @Override
            public Optional<PreviousExecutionState> getPreviousExecutionState() {
                return this.val$context.getPreviousExecutionState();
            }

            @Override
            public Optional<ValidationFinishedContext.ValidationResult> getValidationProblems() {
                return this.val$context.getValidationProblems();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return this.val$context.getBeforeExecutionState();
            }
        });
    }

    private static Optional<InputChangesInternal> determineInputChanges(UnitOfWork work, IncrementalChangesContext context) {
        if (!work.getInputChangeTrackingStrategy().requiresInputChanges()) {
            return Optional.empty();
        }
        ExecutionStateChanges changes = context.getChanges().orElseThrow(() -> new IllegalStateException("Changes are not tracked, unable determine incremental changes."));
        InputChangesInternal inputChanges = changes.createInputChanges();
        if (!inputChanges.isIncremental()) {
            LOGGER.info("The input changes require a full rebuild for incremental {}.", (Object)work.getDisplayName());
        }
        return Optional.of(inputChanges);
    }
}

