/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.time.Duration;
import java.util.Map;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultPreviousExecutionState;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshotSerializer;
import org.gradle.internal.snapshot.impl.SnapshotSerializer;

public class DefaultPreviousExecutionStateSerializer
extends AbstractSerializer<PreviousExecutionState> {
    private final Serializer<FileCollectionFingerprint> fileCollectionFingerprintSerializer;
    private final Serializer<FileSystemSnapshot> fileSystemSnapshotSerializer;
    private final Serializer<ImplementationSnapshot> implementationSnapshotSerializer;
    private final Serializer<ValueSnapshot> valueSnapshotSerializer;

    public DefaultPreviousExecutionStateSerializer(Serializer<FileCollectionFingerprint> fileCollectionFingerprintSerializer, Serializer<FileSystemSnapshot> fileSystemSnapshotSerializer, ClassLoaderHierarchyHasher classLoaderHasher) {
        this.fileCollectionFingerprintSerializer = fileCollectionFingerprintSerializer;
        this.fileSystemSnapshotSerializer = fileSystemSnapshotSerializer;
        this.implementationSnapshotSerializer = new ImplementationSnapshotSerializer();
        this.valueSnapshotSerializer = new SnapshotSerializer(classLoaderHasher);
    }

    @Override
    public PreviousExecutionState read(Decoder decoder) throws Exception {
        OriginMetadata originMetadata = new OriginMetadata(decoder.readString(), Duration.ofMillis(decoder.readLong()));
        ImplementationSnapshot taskImplementation = this.implementationSnapshotSerializer.read(decoder);
        int taskActionsCount = decoder.readSmallInt();
        ImmutableList.Builder taskActionImplementationsBuilder = ImmutableList.builder();
        for (int j = 0; j < taskActionsCount; ++j) {
            ImplementationSnapshot actionImpl = this.implementationSnapshotSerializer.read(decoder);
            taskActionImplementationsBuilder.add((Object)actionImpl);
        }
        ImmutableList taskActionImplementations = taskActionImplementationsBuilder.build();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = this.readInputProperties(decoder);
        ImmutableSortedMap<String, FileCollectionFingerprint> inputFilesFingerprints = this.readFingerprints(decoder);
        ImmutableSortedMap<String, FileSystemSnapshot> outputFilesSnapshots = this.readSnapshots(decoder);
        boolean successful = decoder.readBoolean();
        return new DefaultPreviousExecutionState(originMetadata, taskImplementation, (ImmutableList<ImplementationSnapshot>)taskActionImplementations, inputProperties, inputFilesFingerprints, outputFilesSnapshots, successful);
    }

    @Override
    public void write(Encoder encoder, PreviousExecutionState execution) throws Exception {
        OriginMetadata originMetadata = execution.getOriginMetadata();
        encoder.writeString(originMetadata.getBuildInvocationId());
        encoder.writeLong(originMetadata.getExecutionTime().toMillis());
        this.implementationSnapshotSerializer.write(encoder, execution.getImplementation());
        ImmutableList<ImplementationSnapshot> additionalImplementations = execution.getAdditionalImplementations();
        encoder.writeSmallInt(additionalImplementations.size());
        for (ImplementationSnapshot actionImpl : additionalImplementations) {
            this.implementationSnapshotSerializer.write(encoder, actionImpl);
        }
        this.writeInputProperties(encoder, (ImmutableMap<String, ValueSnapshot>)execution.getInputProperties());
        this.writeFingerprints(encoder, (Map<String, FileCollectionFingerprint>)execution.getInputFileProperties());
        this.writeSnapshots(encoder, execution.getOutputFilesProducedByWork());
        encoder.writeBoolean(execution.isSuccessful());
    }

    public ImmutableSortedMap<String, ValueSnapshot> readInputProperties(Decoder decoder) throws Exception {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableSortedMap.of();
        }
        if (size == 1) {
            return ImmutableSortedMap.of((Comparable)((Object)decoder.readString()), (Object)this.readValueSnapshot(decoder));
        }
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)decoder.readString(), (Object)this.readValueSnapshot(decoder));
        }
        return builder.build();
    }

    public void writeInputProperties(Encoder encoder, ImmutableMap<String, ValueSnapshot> properties) throws Exception {
        encoder.writeSmallInt(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.writeValueSnapshot(encoder, (ValueSnapshot)entry.getValue());
        }
    }

    private ImmutableSortedMap<String, FileCollectionFingerprint> readFingerprints(Decoder decoder) throws Exception {
        int count = decoder.readSmallInt();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int fingerprintIdx = 0; fingerprintIdx < count; ++fingerprintIdx) {
            String property = decoder.readString();
            FileCollectionFingerprint fingerprint = this.fileCollectionFingerprintSerializer.read(decoder);
            builder.put((Object)property, (Object)fingerprint);
        }
        return builder.build();
    }

    private void writeFingerprints(Encoder encoder, Map<String, FileCollectionFingerprint> fingerprints) throws Exception {
        encoder.writeSmallInt(fingerprints.size());
        for (Map.Entry<String, FileCollectionFingerprint> entry : fingerprints.entrySet()) {
            encoder.writeString(entry.getKey());
            this.fileCollectionFingerprintSerializer.write(encoder, entry.getValue());
        }
    }

    private ImmutableSortedMap<String, FileSystemSnapshot> readSnapshots(Decoder decoder) throws Exception {
        int count = decoder.readSmallInt();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int snapshotIdx = 0; snapshotIdx < count; ++snapshotIdx) {
            String property = decoder.readString();
            FileSystemSnapshot snapshot = this.fileSystemSnapshotSerializer.read(decoder);
            builder.put((Object)property, (Object)snapshot);
        }
        return builder.build();
    }

    private void writeSnapshots(Encoder encoder, ImmutableSortedMap<String, FileSystemSnapshot> snapshots) throws Exception {
        encoder.writeSmallInt(snapshots.size());
        for (Map.Entry entry : snapshots.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.fileSystemSnapshotSerializer.write(encoder, (FileSystemSnapshot)entry.getValue());
        }
    }

    private ValueSnapshot readValueSnapshot(Decoder decoder) throws Exception {
        return this.valueSnapshotSerializer.read(decoder);
    }

    private void writeValueSnapshot(Encoder encoder, ValueSnapshot snapshot) throws Exception {
        this.valueSnapshotSerializer.write(encoder, snapshot);
    }
}

