/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.DispatchException;
import org.gradle.internal.dispatch.DispatchFailureHandler;
import org.slf4j.Logger;

public class ExceptionTrackingFailureHandler
implements DispatchFailureHandler<Object>,
Stoppable {
    private final Logger logger;
    private DispatchException failure;

    public ExceptionTrackingFailureHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void dispatchFailed(Object message2, Throwable failure) {
        if (this.failure != null && !Thread.currentThread().isInterrupted()) {
            this.logger.error(failure.getMessage(), failure);
        } else {
            this.failure = new DispatchException(String.format("Could not dispatch message %s.", message2), failure);
        }
    }

    @Override
    public void stop() throws DispatchException {
        if (this.failure != null) {
            try {
                throw this.failure;
            }
            catch (Throwable throwable) {
                this.failure = null;
                throw throwable;
            }
        }
    }
}

