/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.gradle.execution.WorkValidationWarningReporter;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.ValidateStep;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkValidationWarningRecorder
implements ValidateStep.ValidationWarningRecorder,
WorkValidationWarningReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkValidationWarningRecorder.class);
    private final AtomicInteger workWithFailuresCount = new AtomicInteger();

    @Override
    public void recordValidationWarnings(UnitOfWork work, Collection<String> warnings) {
        this.workWithFailuresCount.incrementAndGet();
        ImmutableSortedSet uniqueSortedWarnings = ImmutableSortedSet.copyOf(warnings);
        LOGGER.warn("Execution optimizations have been disabled for {} to ensure correctness due to the following reasons:{}", (Object)work.getDisplayName(), (Object)uniqueSortedWarnings.stream().map(warning -> "\n  - " + warning).collect(Collectors.joining()));
        uniqueSortedWarnings.forEach(warning -> ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour(warning).withContext("Execution optimizations are disabled to ensure correctness.")).willBeRemovedInGradle8().withUserManual("more_about_tasks", "sec:up_to_date_checks").nagUser());
    }

    @Override
    public void reportWorkValidationWarningsAtEndOfBuild() {
        int workWithFailures = this.workWithFailuresCount.getAndSet(0);
        if (workWithFailures > 0) {
            LOGGER.warn("\nExecution optimizations have been disabled for {} invalid unit(s) of work during this build to ensure correctness.\nPlease consult deprecation warnings for more details.", (Object)workWithFailures);
        }
    }
}

