/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.UserCodeAction;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenDependency;
import org.gradle.api.publish.maven.MavenPomCiManagement;
import org.gradle.api.publish.maven.MavenPomContributor;
import org.gradle.api.publish.maven.MavenPomContributorSpec;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomDistributionManagement;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomMailingList;
import org.gradle.api.publish.maven.MavenPomMailingListSpec;
import org.gradle.api.publish.maven.MavenPomOrganization;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPomDeveloper;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPomDistributionManagement;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPomLicense;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPomMailingList;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPomOrganization;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPomProjectManagement;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPomScm;
import org.gradle.api.publish.maven.internal.publication.MavenPomDistributionManagementInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.reflect.Instantiator;

public class DefaultMavenPom
implements MavenPomInternal,
MavenPomLicenseSpec,
MavenPomDeveloperSpec,
MavenPomContributorSpec,
MavenPomMailingListSpec {
    private final MutableActionSet<XmlProvider> xmlAction = new MutableActionSet();
    private final MavenPublicationInternal mavenPublication;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private String packaging;
    private Property<String> name;
    private Property<String> description;
    private Property<String> url;
    private Property<String> inceptionYear;
    private final List<MavenPomLicense> licenses = new ArrayList<MavenPomLicense>();
    private MavenPomOrganization organization;
    private final List<MavenPomDeveloper> developers = new ArrayList<MavenPomDeveloper>();
    private final List<MavenPomContributor> contributors = new ArrayList<MavenPomContributor>();
    private MavenPomScm scm;
    private MavenPomIssueManagement issueManagement;
    private MavenPomCiManagement ciManagement;
    private MavenPomDistributionManagementInternal distributionManagement;
    private final List<MavenPomMailingList> mailingLists = new ArrayList<MavenPomMailingList>();
    private final MapProperty<String, String> properties;

    public DefaultMavenPom(MavenPublicationInternal mavenPublication, Instantiator instantiator, ObjectFactory objectFactory) {
        this.mavenPublication = mavenPublication;
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.name = objectFactory.property(String.class);
        this.description = objectFactory.property(String.class);
        this.url = objectFactory.property(String.class);
        this.inceptionYear = objectFactory.property(String.class);
        this.properties = objectFactory.mapProperty(String.class, String.class);
    }

    @Override
    public void withXml(Action<? super XmlProvider> action) {
        this.xmlAction.add(new UserCodeAction<XmlProvider>("Could not apply withXml() to generated POM", action));
    }

    @Override
    public Action<XmlProvider> getXmlAction() {
        return this.xmlAction;
    }

    @Override
    public VersionMappingStrategyInternal getVersionMappingStrategy() {
        return this.mavenPublication.getVersionMappingStrategy();
    }

    @Override
    public boolean writeGradleMetadataMarker() {
        return this.mavenPublication.writeGradleMetadataMarker();
    }

    @Override
    public String getPackaging() {
        if (this.packaging == null) {
            return this.mavenPublication.determinePackagingFromArtifacts();
        }
        return this.packaging;
    }

    @Override
    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    @Override
    public Property<String> getName() {
        return this.name;
    }

    @Override
    public Property<String> getDescription() {
        return this.description;
    }

    @Override
    public Property<String> getUrl() {
        return this.url;
    }

    @Override
    public Property<String> getInceptionYear() {
        return this.inceptionYear;
    }

    @Override
    public void licenses(Action<? super MavenPomLicenseSpec> action) {
        action.execute(this);
    }

    @Override
    public void license(Action<? super MavenPomLicense> action) {
        this.configureAndAdd(DefaultMavenPomLicense.class, action, this.licenses);
    }

    @Override
    public List<MavenPomLicense> getLicenses() {
        return this.licenses;
    }

    @Override
    public void organization(Action<? super MavenPomOrganization> action) {
        if (this.organization == null) {
            this.organization = this.instantiator.newInstance(DefaultMavenPomOrganization.class, this.objectFactory);
        }
        action.execute(this.organization);
    }

    @Override
    public MavenPomOrganization getOrganization() {
        return this.organization;
    }

    @Override
    public void developers(Action<? super MavenPomDeveloperSpec> action) {
        action.execute(this);
    }

    @Override
    public void developer(Action<? super MavenPomDeveloper> action) {
        this.configureAndAdd(DefaultMavenPomDeveloper.class, action, this.developers);
    }

    @Override
    public List<MavenPomDeveloper> getDevelopers() {
        return this.developers;
    }

    @Override
    public void contributors(Action<? super MavenPomContributorSpec> action) {
        action.execute(this);
    }

    @Override
    public void contributor(Action<? super MavenPomContributor> action) {
        this.configureAndAdd(DefaultMavenPomDeveloper.class, action, this.contributors);
    }

    @Override
    public List<MavenPomContributor> getContributors() {
        return this.contributors;
    }

    @Override
    public MavenPomScm getScm() {
        return this.scm;
    }

    @Override
    public void scm(Action<? super MavenPomScm> action) {
        if (this.scm == null) {
            this.scm = this.instantiator.newInstance(DefaultMavenPomScm.class, this.objectFactory);
        }
        action.execute(this.scm);
    }

    @Override
    public void issueManagement(Action<? super MavenPomIssueManagement> action) {
        if (this.issueManagement == null) {
            this.issueManagement = this.instantiator.newInstance(DefaultMavenPomProjectManagement.class, this.objectFactory);
        }
        action.execute(this.issueManagement);
    }

    @Override
    public MavenPomIssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    @Override
    public void ciManagement(Action<? super MavenPomCiManagement> action) {
        if (this.ciManagement == null) {
            this.ciManagement = this.instantiator.newInstance(DefaultMavenPomProjectManagement.class, this.objectFactory);
        }
        action.execute(this.ciManagement);
    }

    @Override
    public MavenPomCiManagement getCiManagement() {
        return this.ciManagement;
    }

    @Override
    public void distributionManagement(Action<? super MavenPomDistributionManagement> action) {
        if (this.distributionManagement == null) {
            this.distributionManagement = this.instantiator.newInstance(DefaultMavenPomDistributionManagement.class, this.instantiator, this.objectFactory);
        }
        action.execute(this.distributionManagement);
    }

    @Override
    public MavenPomDistributionManagementInternal getDistributionManagement() {
        return this.distributionManagement;
    }

    @Override
    public void mailingLists(Action<? super MavenPomMailingListSpec> action) {
        action.execute(this);
    }

    @Override
    public void mailingList(Action<? super MavenPomMailingList> action) {
        this.configureAndAdd(DefaultMavenPomMailingList.class, action, this.mailingLists);
    }

    @Override
    public List<MavenPomMailingList> getMailingLists() {
        return this.mailingLists;
    }

    @Override
    public MapProperty<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public MavenProjectIdentity getProjectIdentity() {
        return this.mavenPublication.getMavenProjectIdentity();
    }

    @Override
    public Set<MavenDependencyInternal> getApiDependencies() {
        return this.mavenPublication.getApiDependencies();
    }

    @Override
    public Set<MavenDependencyInternal> getOptionalDependencies() {
        return this.mavenPublication.getOptionalDependencies();
    }

    @Override
    public Set<MavenDependencyInternal> getRuntimeDependencies() {
        return this.mavenPublication.getRuntimeDependencies();
    }

    @Override
    public Set<MavenDependency> getApiDependencyManagement() {
        return this.mavenPublication.getApiDependencyConstraints();
    }

    @Override
    public Set<MavenDependency> getRuntimeDependencyManagement() {
        return this.mavenPublication.getRuntimeDependencyConstraints();
    }

    @Override
    public Set<MavenDependency> getImportDependencyManagement() {
        return this.mavenPublication.getImportDependencyConstraints();
    }

    private <T> void configureAndAdd(Class<? extends T> clazz, Action<? super T> action, List<T> items) {
        T item = this.instantiator.newInstance(clazz, this.objectFactory);
        action.execute(item);
        items.add(item);
    }
}

