/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.testing.TestClassLoaderFactory;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.testng.TestNGDetector;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestClassProcessor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.testng.TestNGOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public class TestNGTestFramework
implements TestFramework {
    private final TestNGOptions options;
    private TestNGDetector detector;
    private final DefaultTestFilter filter;
    private final ObjectFactory objects;
    private final String testTaskPath;
    private final FileCollection testTaskClasspath;
    private final Factory<File> testTaskTemporaryDir;
    private transient ClassLoader testClassLoader;

    public TestNGTestFramework(Test testTask, FileCollection classpath, DefaultTestFilter filter, ObjectFactory objects) {
        this.filter = filter;
        this.objects = objects;
        this.testTaskPath = testTask.getPath();
        this.testTaskClasspath = classpath;
        this.testTaskTemporaryDir = testTask.getTemporaryDirFactory();
        this.options = objects.newInstance(TestNGOptions.class, new Object[0]);
        TestNGTestFramework.conventionMapOutputDirectory(this.options, testTask.getReports().getHtml());
        this.detector = new TestNGDetector(new ClassFileExtractionManager(testTask.getTemporaryDirFactory()));
    }

    private static void conventionMapOutputDirectory(TestNGOptions options, final DirectoryReport html) {
        new DslObject(options).getConventionMapping().map("outputDirectory", new Callable<File>(){

            @Override
            public File call() {
                return html.getOutputLocation().getAsFile().getOrNull();
            }
        });
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        this.verifyConfigFailurePolicy();
        this.verifyPreserveOrder();
        this.verifyGroupByInstances();
        List<File> suiteFiles = this.options.getSuites(this.testTaskTemporaryDir.create());
        TestNGSpec spec = new TestNGSpec(this.options, this.filter);
        return new TestClassProcessorFactoryImpl(this.options.getOutputDirectory(), spec, suiteFiles);
    }

    private void verifyConfigFailurePolicy() {
        if (!this.options.getConfigFailurePolicy().equals("skip")) {
            this.verifyMethodExists("setConfigFailurePolicy", String.class, String.format("The version of TestNG used does not support setting config failure policy to '%s'.", this.options.getConfigFailurePolicy()));
        }
    }

    private void verifyPreserveOrder() {
        if (this.options.getPreserveOrder()) {
            this.verifyMethodExists("setPreserveOrder", Boolean.TYPE, "Preserving the order of tests is not supported by this version of TestNG.");
        }
    }

    private void verifyGroupByInstances() {
        if (this.options.getGroupByInstances()) {
            this.verifyMethodExists("setGroupByInstances", Boolean.TYPE, "Grouping tests by instances is not supported by this version of TestNG.");
        }
    }

    private void verifyMethodExists(String methodName, Class<?> parameterType, String failureMessage) {
        try {
            this.createTestNg().getMethod(methodName, parameterType);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidUserDataException(failureMessage, e);
        }
    }

    private Class<?> createTestNg() {
        if (this.testClassLoader == null) {
            TestClassLoaderFactory factory = this.objects.newInstance(TestClassLoaderFactory.class, this.testTaskPath, this.testTaskClasspath);
            this.testClassLoader = factory.create();
        }
        try {
            return this.testClassLoader.loadClass("org.gradle.internal.impldep.org.testng.TestNG");
        }
        catch (ClassNotFoundException e) {
            throw new GradleException("Could not load TestNG.", e);
        }
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return new Action<WorkerProcessBuilder>(){

            @Override
            public void execute(WorkerProcessBuilder workerProcessBuilder) {
                workerProcessBuilder.sharedPackages("org.gradle.internal.impldep.org.testng");
            }
        };
    }

    @Override
    public List<String> getTestWorkerImplementationModules() {
        return Collections.emptyList();
    }

    @Override
    public TestNGOptions getOptions() {
        return this.options;
    }

    @Override
    public TestNGDetector getDetector() {
        return this.detector;
    }

    @Override
    public void close() throws IOException {
        this.testClassLoader = null;
        this.detector = null;
    }

    private static class TestClassProcessorFactoryImpl
    implements WorkerTestClassProcessorFactory,
    Serializable {
        private final File testReportDir;
        private final TestNGSpec options;
        private final List<File> suiteFiles;

        public TestClassProcessorFactoryImpl(File testReportDir, TestNGSpec options, List<File> suiteFiles) {
            this.testReportDir = testReportDir;
            this.options = options;
            this.suiteFiles = suiteFiles;
        }

        @Override
        public TestClassProcessor create(ServiceRegistry serviceRegistry) {
            return new TestNGTestClassProcessor(this.testReportDir, this.options, this.suiteFiles, serviceRegistry.get(IdGenerator.class), serviceRegistry.get(Clock.class), serviceRegistry.get(ActorFactory.class));
        }
    }
}

