/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.tasks.properties.ModifierAnnotationCategory;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.internal.tasks.properties.annotations.AbstractOutputPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.TypeAnnotationHandler;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.ReplayingTypeValidationContext;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class DefaultTypeMetadataStore
implements TypeMetadataStore {
    private final Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers;
    private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> propertyAnnotationHandlers;
    private final ImmutableSet<Class<? extends Annotation>> allowedPropertyModifiers;
    private final CrossBuildInMemoryCache<Class<?>, TypeMetadata> cache;
    private final TypeAnnotationMetadataStore typeAnnotationMetadataStore;
    private final String displayName;
    private final Function<Class<?>, TypeMetadata> typeMetadataFactory = this::createTypeMetadata;

    public DefaultTypeMetadataStore(Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers, Collection<? extends PropertyAnnotationHandler> propertyAnnotationHandlers, Collection<Class<? extends Annotation>> allowedPropertyModifiers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, CrossBuildInMemoryCacheFactory cacheFactory) {
        this.typeAnnotationHandlers = ImmutableSet.copyOf(typeAnnotationHandlers);
        this.propertyAnnotationHandlers = Maps.uniqueIndex(propertyAnnotationHandlers, PropertyAnnotationHandler::getAnnotationType);
        this.allowedPropertyModifiers = ImmutableSet.copyOf(allowedPropertyModifiers);
        this.typeAnnotationMetadataStore = typeAnnotationMetadataStore;
        this.displayName = DefaultTypeMetadataStore.calculateDisplayName(propertyAnnotationHandlers);
        this.cache = cacheFactory.newClassCache();
    }

    private static String calculateDisplayName(Iterable<? extends PropertyAnnotationHandler> annotationHandlers) {
        for (PropertyAnnotationHandler propertyAnnotationHandler : annotationHandlers) {
            if (!(propertyAnnotationHandler instanceof AbstractOutputPropertyAnnotationHandler)) continue;
            return "an input or output annotation";
        }
        return "an input annotation";
    }

    @Override
    public <T> TypeMetadata getTypeMetadata(Class<T> type) {
        return this.cache.get(type, this.typeMetadataFactory);
    }

    private <T> TypeMetadata createTypeMetadata(Class<T> type) {
        Class<?> publicType = GeneratedSubclasses.unpack(type);
        ReplayingTypeValidationContext validationContext = new ReplayingTypeValidationContext();
        TypeAnnotationMetadata annotationMetadata = this.typeAnnotationMetadataStore.getTypeAnnotationMetadata(publicType);
        annotationMetadata.visitValidationFailures(validationContext);
        for (TypeAnnotationHandler typeAnnotationHandler : this.typeAnnotationHandlers) {
            if (!annotationMetadata.isAnnotationPresent(typeAnnotationHandler.getAnnotationType())) continue;
            typeAnnotationHandler.validateTypeMetadata(publicType, validationContext);
        }
        ImmutableSet.Builder effectiveProperties = ImmutableSet.builderWithExpectedSize((int)annotationMetadata.getPropertiesAnnotationMetadata().size());
        for (PropertyAnnotationMetadata propertyAnnotationMetadata : annotationMetadata.getPropertiesAnnotationMetadata()) {
            Annotation normalizationAnnotation;
            ImmutableMap<AnnotationCategory, Annotation> propertyAnnotations = propertyAnnotationMetadata.getAnnotations();
            Annotation typeAnnotation = (Annotation)propertyAnnotations.get(AnnotationCategory.TYPE);
            Class<? extends Annotation> propertyType = this.determinePropertyType(typeAnnotation, normalizationAnnotation = (Annotation)propertyAnnotations.get(ModifierAnnotationCategory.NORMALIZATION));
            if (propertyType == null) {
                validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.MISSING_ANNOTATION)).forProperty(propertyAnnotationMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> "is missing " + this.displayName)).happensBecause("A property without annotation isn't considered during up-to-date checking")).addPossibleSolution(() -> "Add " + this.displayName)).addPossibleSolution("Mark it as @Internal")).documentedAt("validation_problems", "missing_annotation"));
                continue;
            }
            PropertyAnnotationHandler annotationHandler = (PropertyAnnotationHandler)this.propertyAnnotationHandlers.get(propertyType);
            if (annotationHandler == null) {
                validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.ANNOTATION_INVALID_IN_CONTEXT)).forProperty(propertyAnnotationMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> String.format("is annotated with invalid property type @%s", propertyType.getSimpleName()))).happensBecause(() -> "The '@" + propertyType.getSimpleName() + "' annotation cannot be used in this context")).addPossibleSolution("Remove the property")).addPossibleSolution(() -> "Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations((ImmutableSet<Class<? extends Annotation>>)this.propertyAnnotationHandlers.keySet()))).documentedAt("validation_problems", "annotation_invalid_in_context"));
                continue;
            }
            ImmutableSet<? extends AnnotationCategory> allowedModifiersForPropertyType = annotationHandler.getAllowedModifiers();
            for (Map.Entry entry : propertyAnnotations.entrySet()) {
                AnnotationCategory annotationCategory = (AnnotationCategory)entry.getKey();
                if (annotationCategory == AnnotationCategory.TYPE) continue;
                Class<? extends Annotation> annotationType = ((Annotation)entry.getValue()).annotationType();
                if (!allowedModifiersForPropertyType.contains((Object)annotationCategory)) {
                    validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.INCOMPATIBLE_ANNOTATIONS)).forProperty(propertyAnnotationMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> "is annotated with @" + annotationType.getSimpleName() + " but that is not allowed for '" + propertyType.getSimpleName() + "' properties")).happensBecause(() -> "This modifier is used in conjunction with a property of type '" + propertyType.getSimpleName() + "' but this doesn't have semantics")).withLongDescription(() -> "The list of allowed modifiers for '" + propertyType.getSimpleName() + "' is " + DefaultTypeMetadataStore.toListOfAnnotations(this.allowedPropertyModifiers))).addPossibleSolution(() -> "Remove the '@" + annotationType.getSimpleName() + "' annotation")).documentedAt("validation_problems", "incompatible_annotations"));
                    continue;
                }
                if (this.allowedPropertyModifiers.contains(annotationType)) continue;
                validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.ANNOTATION_INVALID_IN_CONTEXT)).forProperty(propertyAnnotationMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> String.format("is annotated with invalid modifier @%s", annotationType.getSimpleName()))).happensBecause(() -> "The '@" + annotationType.getSimpleName() + "' annotation cannot be used in this context")).addPossibleSolution("Remove the annotation")).addPossibleSolution(() -> "Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations(this.allowedPropertyModifiers))).documentedAt("validation_problems", "annotation_invalid_in_context"));
            }
            DefaultPropertyMetadata property = new DefaultPropertyMetadata(propertyType, propertyAnnotationMetadata);
            annotationHandler.validatePropertyMetadata(property, validationContext);
            if (!annotationHandler.isPropertyRelevant()) continue;
            effectiveProperties.add((Object)property);
        }
        return new DefaultTypeMetadata((ImmutableSet<PropertyMetadata>)effectiveProperties.build(), validationContext, this.propertyAnnotationHandlers);
    }

    private static String toListOfAnnotations(ImmutableSet<Class<? extends Annotation>> classes) {
        return classes.stream().map(Class::getSimpleName).map(s -> "@" + s).sorted().collect(DefaultTypeMetadataStore.forDisplay());
    }

    @Nullable
    private Class<? extends Annotation> determinePropertyType(@Nullable Annotation typeAnnotation, @Nullable Annotation normalizationAnnotation) {
        if (typeAnnotation != null) {
            return typeAnnotation.annotationType();
        }
        if (normalizationAnnotation != null && (normalizationAnnotation.annotationType().equals(Classpath.class) || normalizationAnnotation.annotationType().equals(CompileClasspath.class))) {
            return InputFiles.class;
        }
        return null;
    }

    private static Collector<? super String, ?, String> forDisplay() {
        return Collectors.collectingAndThen(Collectors.toList(), stringList -> {
            if (stringList.isEmpty()) {
                return "";
            }
            if (stringList.size() == 1) {
                return (String)stringList.get(0);
            }
            int bound = stringList.size() - 1;
            return String.join((CharSequence)", ", stringList.subList(0, bound)) + " or " + (String)stringList.get(bound);
        });
    }

    private static class DefaultPropertyMetadata
    implements PropertyMetadata {
        private final Class<? extends Annotation> propertyType;
        private final PropertyAnnotationMetadata annotationMetadata;

        public DefaultPropertyMetadata(Class<? extends Annotation> propertyType, PropertyAnnotationMetadata annotationMetadata) {
            this.propertyType = propertyType;
            this.annotationMetadata = annotationMetadata;
        }

        @Override
        public String getPropertyName() {
            return this.annotationMetadata.getPropertyName();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotationMetadata.isAnnotationPresent(annotationType);
        }

        @Override
        @Nullable
        public Annotation getAnnotationForCategory(AnnotationCategory category) {
            return (Annotation)this.annotationMetadata.getAnnotations().get((Object)category);
        }

        @Override
        public boolean hasAnnotationForCategory(AnnotationCategory category) {
            return this.annotationMetadata.getAnnotations().get((Object)category) != null;
        }

        @Override
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public Method getGetterMethod() {
            return this.annotationMetadata.getMethod();
        }

        public String toString() {
            return String.format("@%s %s", this.propertyType.getSimpleName(), this.getPropertyName());
        }
    }

    private static class DefaultTypeMetadata
    implements TypeMetadata {
        private final ImmutableSet<PropertyMetadata> propertiesMetadata;
        private final ReplayingTypeValidationContext validationProblems;
        private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers;

        DefaultTypeMetadata(ImmutableSet<PropertyMetadata> propertiesMetadata, ReplayingTypeValidationContext validationProblems, ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers) {
            this.propertiesMetadata = propertiesMetadata;
            this.validationProblems = validationProblems;
            this.annotationHandlers = annotationHandlers;
        }

        @Override
        public void visitValidationFailures(@Nullable String ownerPropertyPath, TypeValidationContext validationContext) {
            this.validationProblems.replay(ownerPropertyPath, validationContext);
        }

        @Override
        public Set<PropertyMetadata> getPropertiesMetadata() {
            return this.propertiesMetadata;
        }

        @Override
        public boolean hasAnnotatedProperties() {
            return !this.propertiesMetadata.isEmpty();
        }

        @Override
        public PropertyAnnotationHandler getAnnotationHandlerFor(PropertyMetadata propertyMetadata) {
            return (PropertyAnnotationHandler)this.annotationHandlers.get(propertyMetadata.getPropertyType());
        }
    }
}

