/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.Serializable;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.util.MergeOptionsUtil;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ForkedWorkerRequirement;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.IsolationMode;
import org.gradle.workers.internal.ProvidesWorkResult;
import org.gradle.workers.internal.WorkerFactory;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final WorkerFactory workerFactory;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public AbstractDaemonCompiler(WorkerFactory workerFactory, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.workerFactory = workerFactory;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    @Override
    public WorkResult execute(T spec) {
        CompilerParameters parameters;
        IsolatedClassLoaderWorkerRequirement workerRequirement = this.getWorkerRequirement(this.workerFactory.getIsolationMode(), spec);
        BuildOperationAwareWorker worker = this.workerFactory.getWorker(workerRequirement);
        DefaultWorkResult result2 = worker.execute(this.actionExecutionSpecFactory.newIsolatedSpec("compiler daemon", CompilerWorkAction.class, parameters = this.getCompilerParameters(spec), workerRequirement, true));
        if (result2.isSuccess()) {
            return result2;
        }
        throw UncheckedException.throwAsUncheckedException(result2.getException());
    }

    private IsolatedClassLoaderWorkerRequirement getWorkerRequirement(IsolationMode isolationMode, T spec) {
        DaemonForkOptions daemonForkOptions = this.toDaemonForkOptions(spec);
        switch (isolationMode) {
            case CLASSLOADER: {
                return new IsolatedClassLoaderWorkerRequirement(daemonForkOptions.getJavaForkOptions().getWorkingDir(), daemonForkOptions.getClassLoaderStructure());
            }
            case PROCESS: {
                return new ForkedWorkerRequirement(daemonForkOptions.getJavaForkOptions().getWorkingDir(), daemonForkOptions);
            }
        }
        throw new IllegalArgumentException("Received worker with unsupported isolation mode: " + (Object)((Object)isolationMode));
    }

    protected abstract DaemonForkOptions toDaemonForkOptions(T var1);

    protected abstract CompilerParameters getCompilerParameters(T var1);

    protected BaseForkOptions mergeForkOptions(BaseForkOptions left, BaseForkOptions right) {
        BaseForkOptions merged = new BaseForkOptions();
        merged.setMemoryInitialSize(MergeOptionsUtil.mergeHeapSize(left.getMemoryInitialSize(), right.getMemoryInitialSize()));
        merged.setMemoryMaximumSize(MergeOptionsUtil.mergeHeapSize(left.getMemoryMaximumSize(), right.getMemoryMaximumSize()));
        Set<String> mergedJvmArgs = MergeOptionsUtil.normalized(left.getJvmArgs());
        mergedJvmArgs.addAll(MergeOptionsUtil.normalized(right.getJvmArgs()));
        merged.setJvmArgs(Lists.newArrayList(mergedJvmArgs));
        return merged;
    }

    public static class CompilerWorkAction
    implements WorkAction<CompilerParameters>,
    ProvidesWorkResult {
        private DefaultWorkResult workResult;
        private final CompilerParameters parameters;
        private final Instantiator instantiator;

        @Inject
        public CompilerWorkAction(CompilerParameters parameters, Instantiator instantiator) {
            this.parameters = parameters;
            this.instantiator = instantiator;
        }

        @Override
        public CompilerParameters getParameters() {
            return this.parameters;
        }

        @Override
        public void execute() {
            Class compilerClass = (Class)Cast.uncheckedCast(ClassLoaderUtils.classFromContextLoader(this.getParameters().getCompilerClassName()));
            Compiler compiler = (Compiler)this.instantiator.newInstance(compilerClass, this.getParameters().getCompilerInstanceParameters());
            this.setWorkResult(compiler.execute((CompileSpec)Cast.uncheckedCast(this.getParameters().getCompileSpec())));
        }

        private void setWorkResult(WorkResult workResult) {
            this.workResult = workResult instanceof DefaultWorkResult ? (DefaultWorkResult)workResult : new DefaultWorkResult(workResult.getDidWork(), null);
        }

        @Override
        public DefaultWorkResult getWorkResult() {
            return this.workResult;
        }
    }

    public static abstract class CompilerParameters
    implements WorkParameters,
    Serializable {
        private final String compilerClassName;
        private final Object[] compilerInstanceParameters;

        public CompilerParameters(String compilerClassName, Object[] compilerInstanceParameters) {
            this.compilerClassName = compilerClassName;
            this.compilerInstanceParameters = compilerInstanceParameters;
        }

        public String getCompilerClassName() {
            return this.compilerClassName;
        }

        public Object[] getCompilerInstanceParameters() {
            return this.compilerInstanceParameters;
        }

        public abstract CompileSpec getCompileSpec();
    }
}

