/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.internal.resolve.LibraryResolutionErrorMessageBuilder;
import org.gradle.api.internal.resolve.LibraryResolutionResult;
import org.gradle.api.internal.resolve.LocalLibraryMetaDataAdapter;
import org.gradle.api.internal.resolve.LocalLibraryResolver;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.internal.resolve.VariantBinarySelector;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.MetadataSourcedComponentArtifacts;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.Binary;
import org.gradle.platform.base.VariantComponent;

public class LocalLibraryDependencyResolver
implements DependencyToComponentIdResolver,
ComponentMetaDataResolver,
ArtifactResolver,
OriginArtifactSelector,
ComponentResolvers {
    private final VariantBinarySelector variantSelector;
    private final LibraryResolutionErrorMessageBuilder errorMessageBuilder;
    private final LocalLibraryMetaDataAdapter libraryMetaDataAdapter;
    private final LocalLibraryResolver libraryResolver;
    private final Class<? extends Binary> binaryType;
    private final Predicate<VariantComponent> binaryPredicate;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ProjectModelResolver projectModelResolver;

    public LocalLibraryDependencyResolver(final Class<? extends Binary> binaryType, ProjectModelResolver projectModelResolver, LocalLibraryResolver libraryResolver, VariantBinarySelector variantSelector, LocalLibraryMetaDataAdapter libraryMetaDataAdapter, LibraryResolutionErrorMessageBuilder errorMessageBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.libraryMetaDataAdapter = libraryMetaDataAdapter;
        this.variantSelector = variantSelector;
        this.errorMessageBuilder = errorMessageBuilder;
        this.projectModelResolver = projectModelResolver;
        this.libraryResolver = libraryResolver;
        this.binaryType = binaryType;
        this.binaryPredicate = new Predicate<VariantComponent>(){

            public boolean apply(VariantComponent input) {
                return Iterables.any(input.getVariants(), (Predicate)new Predicate<Binary>(){

                    public boolean apply(Binary input) {
                        return binaryType.isAssignableFrom(input.getClass());
                    }
                });
            }
        };
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this;
    }

    @Override
    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this;
    }

    @Override
    public ComponentMetaDataResolver getComponentResolver() {
        return this;
    }

    @Override
    public OriginArtifactSelector getArtifactSelector() {
        return this;
    }

    @Override
    public void resolve(DependencyMetadata dependency, VersionSelector acceptor, VersionSelector rejector, BuildableComponentIdResolveResult result2) {
        if (dependency.getSelector() instanceof LibraryComponentSelector) {
            LibraryComponentSelector selector = (LibraryComponentSelector)dependency.getSelector();
            this.resolveLibraryAndChooseBinary(result2, selector);
        }
    }

    private void resolveLibraryAndChooseBinary(BuildableComponentIdResolveResult result2, LibraryComponentSelector selector) {
        String selectorProjectPath = selector.getProjectPath();
        final String libraryName = selector.getLibraryName();
        String variant = selector.getVariant();
        LibraryResolutionResult resolutionResult = this.doResolve(selectorProjectPath, libraryName);
        VariantComponent selectedLibrary = resolutionResult.getSelectedLibrary();
        if (selectedLibrary == null) {
            String message2 = resolutionResult.toResolutionErrorMessage(selector);
            ModuleVersionResolveException failure = new ModuleVersionResolveException((ComponentSelector)selector, (Throwable)new LibraryResolveException(message2));
            result2.failed(failure);
            return;
        }
        final Collection<? extends Binary> matchingVariants = this.chooseMatchingVariants(selectedLibrary, variant);
        if (matchingVariants.isEmpty()) {
            final Iterable<? extends Binary> values = selectedLibrary.getVariants();
            result2.failed(new ModuleVersionResolveException((ComponentSelector)selector, new Factory<String>(){

                @Override
                @Nullable
                public String create() {
                    return LocalLibraryDependencyResolver.this.errorMessageBuilder.noCompatibleVariantErrorMessage(libraryName, values);
                }
            }));
        } else if (matchingVariants.size() > 1) {
            result2.failed(new ModuleVersionResolveException((ComponentSelector)selector, new Factory<String>(){

                @Override
                @Nullable
                public String create() {
                    return LocalLibraryDependencyResolver.this.errorMessageBuilder.multipleCompatibleVariantsErrorMessage(libraryName, matchingVariants);
                }
            }));
        } else {
            Binary selectedBinary = matchingVariants.iterator().next();
            LocalComponentMetadata metaData = variant == null ? this.libraryMetaDataAdapter.createLocalComponentMetaData(selectedBinary, selectorProjectPath, false) : this.libraryMetaDataAdapter.createLocalComponentMetaData(selectedBinary, selectorProjectPath, true);
            result2.resolved(metaData);
        }
    }

    private LibraryResolutionResult doResolve(String selectorProjectPath, String libraryName) {
        try {
            ModelRegistry projectModel = this.projectModelResolver.resolveProjectModel(selectorProjectPath);
            Collection<VariantComponent> candidates = this.libraryResolver.resolveCandidates(projectModel, libraryName);
            if (candidates.isEmpty()) {
                return LibraryResolutionResult.emptyResolutionResult(this.binaryType);
            }
            return LibraryResolutionResult.of(this.binaryType, candidates, libraryName, this.binaryPredicate);
        }
        catch (UnknownProjectException e) {
            return LibraryResolutionResult.projectNotFound(this.binaryType);
        }
    }

    private Collection<? extends Binary> chooseMatchingVariants(VariantComponent selectedLibrary, String variant) {
        return this.variantSelector.selectVariants(selectedLibrary, variant);
    }

    @Override
    public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result2) {
        if (this.isLibrary(identifier)) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    @Override
    public boolean isFetchingMetadataCheap(ComponentIdentifier identifier) {
        return true;
    }

    private boolean isLibrary(ComponentIdentifier identifier) {
        return identifier instanceof LibraryBinaryIdentifier;
    }

    @Override
    @Nullable
    public ArtifactSet resolveArtifacts(ComponentResolveMetadata component, ConfigurationMetadata configuration2, ArtifactTypeRegistry artifactTypeRegistry, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
        ComponentIdentifier componentId = component.getId();
        if (this.isLibrary(componentId)) {
            return new MetadataSourcedComponentArtifacts().getArtifactsFor(component, configuration2, this, new ConcurrentHashMap<ComponentArtifactIdentifier, ResolvableArtifact>(), artifactTypeRegistry, exclusions, overriddenAttributes, this.calculatedValueContainerFactory);
        }
        return null;
    }

    @Override
    public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result2) {
        if (this.isLibrary(component.getId())) {
            result2.resolved(Collections.emptySet());
        }
    }

    @Override
    public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactResolveResult result2) {
        if (this.isLibrary(artifact.getComponentId())) {
            if (artifact instanceof PublishArtifactLocalArtifactMetadata) {
                result2.resolved(((PublishArtifactLocalArtifactMetadata)artifact).getFile());
            } else {
                result2.failed(new ArtifactResolveException("Unsupported artifact metadata type: " + artifact));
            }
        }
    }
}

