/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import com.intellij.vcs.editor.GsonComplexPathSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.SimpleGHPRIdentifier;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\nH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem;", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem$GHPRFilePath;", "()V", "findOrCreateFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "path", "getPath", "", "fileManagerId", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "id", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "isDiff", "", "getProtocol", "Companion", "GHPRFilePath", "intellij.vcs.github"})
public final class GHPRVirtualFileSystem
extends ComplexPathVirtualFileSystem<GHPRFilePath> {
    private static final String PROTOCOL = "ghpr";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    protected VirtualFile findOrCreateFile(@NotNull Project project, @NotNull GHPRFilePath path) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = GHPRDataContextRepository.Companion.getInstance(project).findContext(path.getRepository());
        if (object == null || (object = ((GHPRDataContext)object).getFilesManager()) == null) {
            return null;
        }
        Object filesManager = object;
        SimpleGHPRIdentifier pullRequest = path.getPrId();
        return pullRequest == null ? (VirtualFile)filesManager.getNewPRDiffFile() : (path.isDiff() ? (VirtualFile)filesManager.findDiffFile(pullRequest) : (VirtualFile)filesManager.findTimelineFile(pullRequest));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPath(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @Nullable GHPRIdentifier id, boolean isDiff) {
        SimpleGHPRIdentifier simpleGHPRIdentifier;
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        GHPRVirtualFileSystem gHPRVirtualFileSystem = this;
        String string = fileManagerId;
        String string2 = project.getLocationHash();
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.locationHash");
        GHRepositoryCoordinates gHRepositoryCoordinates = repository;
        GHPRIdentifier gHPRIdentifier = id;
        if (gHPRIdentifier != null) {
            void it;
            GHPRIdentifier gHPRIdentifier2;
            GHPRIdentifier gHPRIdentifier3 = gHPRIdentifier2 = gHPRIdentifier;
            GHRepositoryCoordinates gHRepositoryCoordinates2 = gHRepositoryCoordinates;
            String string4 = string3;
            String string5 = string;
            GHPRVirtualFileSystem gHPRVirtualFileSystem2 = gHPRVirtualFileSystem;
            boolean bl = false;
            SimpleGHPRIdentifier simpleGHPRIdentifier2 = new SimpleGHPRIdentifier((GHPRIdentifier)it);
            gHPRVirtualFileSystem = gHPRVirtualFileSystem2;
            string = string5;
            string3 = string4;
            gHRepositoryCoordinates = gHRepositoryCoordinates2;
            simpleGHPRIdentifier = simpleGHPRIdentifier2;
        } else {
            simpleGHPRIdentifier = null;
        }
        boolean bl = isDiff;
        SimpleGHPRIdentifier simpleGHPRIdentifier3 = simpleGHPRIdentifier;
        GHRepositoryCoordinates gHRepositoryCoordinates3 = gHRepositoryCoordinates;
        String string6 = string3;
        String string7 = string;
        return gHPRVirtualFileSystem.getPath(new GHPRFilePath(string7, string6, gHRepositoryCoordinates3, simpleGHPRIdentifier3, bl));
    }

    public static /* synthetic */ String getPath$default(GHPRVirtualFileSystem gHPRVirtualFileSystem, String string, Project project, GHRepositoryCoordinates gHRepositoryCoordinates, GHPRIdentifier gHPRIdentifier, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return gHPRVirtualFileSystem.getPath(string, project, gHRepositoryCoordinates, gHPRIdentifier, bl);
    }

    public GHPRVirtualFileSystem() {
        super((ComplexPathVirtualFileSystem.ComplexPathSerializer)new GsonComplexPathSerializer(GHPRFilePath.class, null, 2, null));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J=\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem$GHPRFilePath;", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "sessionId", "", "projectHash", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "prId", "Lorg/jetbrains/plugins/github/pullrequest/data/SimpleGHPRIdentifier;", "isDiff", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/SimpleGHPRIdentifier;Z)V", "()Z", "getPrId", "()Lorg/jetbrains/plugins/github/pullrequest/data/SimpleGHPRIdentifier;", "getProjectHash", "()Ljava/lang/String;", "getRepository", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getSessionId", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.vcs.github"})
    public static final class GHPRFilePath
    implements ComplexPathVirtualFileSystem.ComplexPath {
        @NotNull
        private final String sessionId;
        @NotNull
        private final String projectHash;
        @NotNull
        private final GHRepositoryCoordinates repository;
        @Nullable
        private final SimpleGHPRIdentifier prId;
        private final boolean isDiff;

        @NotNull
        public String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public String getProjectHash() {
            return this.projectHash;
        }

        @NotNull
        public final GHRepositoryCoordinates getRepository() {
            return this.repository;
        }

        @Nullable
        public final SimpleGHPRIdentifier getPrId() {
            return this.prId;
        }

        public final boolean isDiff() {
            return this.isDiff;
        }

        public GHPRFilePath(@NotNull String sessionId, @NotNull String projectHash, @NotNull GHRepositoryCoordinates repository, @Nullable SimpleGHPRIdentifier prId, boolean isDiff) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            this.sessionId = sessionId;
            this.projectHash = projectHash;
            this.repository = repository;
            this.prId = prId;
            this.isDiff = isDiff;
        }

        @NotNull
        public final String component1() {
            return this.getSessionId();
        }

        @NotNull
        public final String component2() {
            return this.getProjectHash();
        }

        @NotNull
        public final GHRepositoryCoordinates component3() {
            return this.repository;
        }

        @Nullable
        public final SimpleGHPRIdentifier component4() {
            return this.prId;
        }

        public final boolean component5() {
            return this.isDiff;
        }

        @NotNull
        public final GHPRFilePath copy(@NotNull String sessionId, @NotNull String projectHash, @NotNull GHRepositoryCoordinates repository, @Nullable SimpleGHPRIdentifier prId, boolean isDiff) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            return new GHPRFilePath(sessionId, projectHash, repository, prId, isDiff);
        }

        public static /* synthetic */ GHPRFilePath copy$default(GHPRFilePath gHPRFilePath, String string, String string2, GHRepositoryCoordinates gHRepositoryCoordinates, SimpleGHPRIdentifier simpleGHPRIdentifier, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = gHPRFilePath.getSessionId();
            }
            if ((n & 2) != 0) {
                string2 = gHPRFilePath.getProjectHash();
            }
            if ((n & 4) != 0) {
                gHRepositoryCoordinates = gHPRFilePath.repository;
            }
            if ((n & 8) != 0) {
                simpleGHPRIdentifier = gHPRFilePath.prId;
            }
            if ((n & 0x10) != 0) {
                bl = gHPRFilePath.isDiff;
            }
            return gHPRFilePath.copy(string, string2, gHRepositoryCoordinates, simpleGHPRIdentifier, bl);
        }

        @NotNull
        public String toString() {
            return "GHPRFilePath(sessionId=" + this.getSessionId() + ", projectHash=" + this.getProjectHash() + ", repository=" + this.repository + ", prId=" + this.prId + ", isDiff=" + this.isDiff + ")";
        }

        public int hashCode() {
            String string = this.getSessionId();
            String string2 = this.getProjectHash();
            GHRepositoryCoordinates gHRepositoryCoordinates = this.repository;
            SimpleGHPRIdentifier simpleGHPRIdentifier = this.prId;
            int n = ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (gHRepositoryCoordinates != null ? ((Object)gHRepositoryCoordinates).hashCode() : 0)) * 31 + (simpleGHPRIdentifier != null ? ((Object)simpleGHPRIdentifier).hashCode() : 0)) * 31;
            int n2 = this.isDiff ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GHPRFilePath)) break block3;
                    GHPRFilePath gHPRFilePath = (GHPRFilePath)object;
                    if (!Intrinsics.areEqual((Object)this.getSessionId(), (Object)gHPRFilePath.getSessionId()) || !Intrinsics.areEqual((Object)this.getProjectHash(), (Object)gHPRFilePath.getProjectHash()) || !Intrinsics.areEqual((Object)this.repository, (Object)gHPRFilePath.repository) || !Intrinsics.areEqual((Object)this.prId, (Object)gHPRFilePath.prId) || this.isDiff != gHPRFilePath.isDiff) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem$Companion;", "", "()V", "PROTOCOL", "", "getInstance", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem;", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final GHPRVirtualFileSystem getInstance() {
            boolean $i$f$service = false;
            Class<VirtualFileManager> serviceClass$iv = VirtualFileManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            VirtualFileSystem virtualFileSystem = ((VirtualFileManager)object).getFileSystem(GHPRVirtualFileSystem.PROTOCOL);
            if (virtualFileSystem == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
            }
            return (GHPRVirtualFileSystem)virtualFileSystem;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

