/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalSplitAction;
import com.intellij.terminal.actions.TerminalActionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ProxyTtyConnector;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalShellCommandHandlerHelper;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.TerminalView;

public class ShellTerminalWidget
extends JBTerminalWidget {
    private static final Logger LOG = Logger.getInstance(ShellTerminalWidget.class);
    private boolean myEscapePressed;
    private String myCommandHistoryFilePath;
    private final Prompt myPrompt;
    private final Queue<String> myPendingCommandsToExecute;
    private final Queue<Consumer<TtyConnector>> myPendingActionsToExecute;
    private final TerminalShellCommandHandlerHelper myShellCommandHandlerHelper;

    public ShellTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull Disposable parent) {
        if (project == null) {
            ShellTerminalWidget.$$$reportNull$$$0(0);
        }
        if (settingsProvider == null) {
            ShellTerminalWidget.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            ShellTerminalWidget.$$$reportNull$$$0(2);
        }
        super(project, settingsProvider, parent);
        this.myEscapePressed = false;
        this.myPrompt = new Prompt();
        this.myPendingCommandsToExecute = new LinkedList<String>();
        this.myPendingActionsToExecute = new LinkedList<Consumer<TtyConnector>>();
        this.myShellCommandHandlerHelper = new TerminalShellCommandHandlerHelper(this);
        this.getTerminalPanel().addPreKeyEventHandler(e -> {
            if (e.getID() != 401) {
                return;
            }
            if (e.getKeyCode() == 27) {
                this.myEscapePressed = true;
            }
            this.handleAnyKeyPressed();
            if (e.getKeyCode() == 10 || TerminalShellCommandHandlerHelper.matchedExecutor(e) != null) {
                TerminalUsageTriggerCollector.Companion.triggerCommandExecuted(project);
                if (this.myShellCommandHandlerHelper.processEnterKeyPressed((KeyEvent)e)) {
                    e.consume();
                }
                if (!e.isConsumed()) {
                    this.handleEnterPressed();
                    this.myEscapePressed = false;
                }
            } else {
                this.myShellCommandHandlerHelper.processKeyPressed((KeyEvent)e);
            }
        });
    }

    public void handleEnterPressed() {
        this.myPrompt.reset();
    }

    public void handleAnyKeyPressed() {
        this.myPrompt.onKeyPressed();
    }

    public void setCommandHistoryFilePath(@Nullable String commandHistoryFilePath) {
        this.myCommandHistoryFilePath = commandHistoryFilePath;
    }

    @Nullable
    public static String getCommandHistoryFilePath(@Nullable JBTerminalWidget terminalWidget) {
        return terminalWidget instanceof ShellTerminalWidget ? ((ShellTerminalWidget)terminalWidget).myCommandHistoryFilePath : null;
    }

    @NotNull
    public String getTypedShellCommand() {
        String string = this.myPrompt.getTypedShellCommand();
        if (string == null) {
            ShellTerminalWidget.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T processTerminalBuffer(@NotNull Function<TerminalTextBuffer, T> processor) {
        if (processor == null) {
            ShellTerminalWidget.$$$reportNull$$$0(4);
        }
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        textBuffer.lock();
        try {
            T t = processor.apply(textBuffer);
            return t;
        }
        finally {
            textBuffer.unlock();
        }
    }

    int getLineNumberAtCursor() {
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        Terminal terminal = this.getTerminal();
        return Math.max(0, Math.min(terminal.getCursorY() - 1, textBuffer.getHeight() - 1));
    }

    public void executeCommand(@NotNull String shellCommand) throws IOException {
        String typedCommand;
        if (shellCommand == null) {
            ShellTerminalWidget.$$$reportNull$$$0(5);
        }
        if (!(typedCommand = this.getTypedShellCommand()).isEmpty()) {
            throw new IOException("Cannot execute command when another command is typed: " + typedCommand);
        }
        TtyConnector connector = this.getTtyConnector();
        if (connector != null) {
            this.doExecuteCommand(shellCommand, connector);
        } else {
            this.myPendingCommandsToExecute.add(shellCommand);
        }
    }

    public void executeWithTtyConnector(@NotNull Consumer<TtyConnector> consumer) {
        TtyConnector connector;
        if (consumer == null) {
            ShellTerminalWidget.$$$reportNull$$$0(6);
        }
        if ((connector = this.getTtyConnector()) != null) {
            consumer.consume((Object)connector);
        } else {
            this.myPendingActionsToExecute.add(consumer);
        }
    }

    public String getSessionName() {
        ProcessTtyConnector connector = this.getProcessTtyConnector();
        if (connector instanceof PtyProcessTtyConnector) {
            return TerminalOptionsProvider.getInstance().getTabName();
        }
        return super.getSessionName();
    }

    public void setTtyConnector(@NotNull TtyConnector ttyConnector) {
        Consumer<TtyConnector> consumer;
        String command;
        if (ttyConnector == null) {
            ShellTerminalWidget.$$$reportNull$$$0(7);
        }
        super.setTtyConnector(ttyConnector);
        while ((command = this.myPendingCommandsToExecute.poll()) != null) {
            try {
                this.doExecuteCommand(command, ttyConnector);
            }
            catch (IOException e) {
                LOG.warn("Cannot execute " + command, (Throwable)e);
            }
        }
        while ((consumer = this.myPendingActionsToExecute.poll()) != null) {
            consumer.consume((Object)ttyConnector);
        }
    }

    private void doExecuteCommand(@NotNull String shellCommand, @NotNull TtyConnector connector) throws IOException {
        if (shellCommand == null) {
            ShellTerminalWidget.$$$reportNull$$$0(8);
        }
        if (connector == null) {
            ShellTerminalWidget.$$$reportNull$$$0(9);
        }
        StringBuilder result = new StringBuilder();
        if (this.myEscapePressed) {
            result.append('\b');
        }
        String enterCode = new String(this.getTerminalStarter().getCode(10, 0), StandardCharsets.UTF_8);
        result.append(shellCommand).append(enterCode);
        connector.write(result.toString());
    }

    public boolean hasRunningCommands() throws IllegalStateException {
        TtyConnector connector = this.getTtyConnector();
        if (connector == null) {
            return false;
        }
        ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector(connector);
        if (processTtyConnector != null) {
            return TerminalUtil.hasRunningCommands(processTtyConnector);
        }
        throw new IllegalStateException("Cannot determine if there are running processes for " + connector.getClass());
    }

    public List<TerminalAction> getActions() {
        ArrayList<TerminalAction> actions = new ArrayList<TerminalAction>(super.getActions());
        if (TerminalView.isInTerminalToolWindow(this)) {
            ContainerUtil.addIfNotNull(actions, (Object)TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (String)"Terminal.RenameSession", (boolean)true));
        }
        JBTerminalWidgetListener listener = this.getListener();
        JBTerminalSystemSettingsProviderBase settingsProvider = this.getSettingsProvider();
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getNewSessionActionPresentation(), l -> {
            l.onNewSession();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getCloseSessionActionPresentation(), l -> {
            l.onSessionClosed();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalSplitAction.create((boolean)true, (JBTerminalWidgetListener)this.getListener()).withMnemonicKey(Integer.valueOf(86)).separatorBefore(true));
        actions.add(TerminalSplitAction.create((boolean)false, (JBTerminalWidgetListener)this.getListener()).withMnemonicKey(Integer.valueOf(72)));
        if (listener != null && listener.isGotoNextSplitTerminalAvailable()) {
            actions.add(settingsProvider.getGotoNextSplitTerminalAction(listener, true));
            actions.add(settingsProvider.getGotoNextSplitTerminalAction(listener, false));
        }
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getPreviousTabActionPresentation(), l -> {
            l.onPreviousTabSelected();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getNextTabActionPresentation(), l -> {
            l.onNextTabSelected();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getMoveTabRightActionPresentation(), l -> {
            l.moveTabRight();
            return true;
        }).withMnemonicKey(Integer.valueOf(82)).withEnabledSupplier(() -> listener != null && listener.canMoveTabRight()));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getMoveTabLeftActionPresentation(), l -> {
            l.moveTabLeft();
            return true;
        }).withMnemonicKey(Integer.valueOf(76)).withEnabledSupplier(() -> listener != null && listener.canMoveTabLeft()));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getShowTabsActionPresentation(), l -> {
            l.showTabs();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        return actions;
    }

    @Nullable
    public TerminalLineIntervalHighlighting highlightLineInterval(int lineNumber, int intervalStartOffset, int intervalLength, @NotNull TextStyle style) {
        TerminalLine line;
        if (style == null) {
            ShellTerminalWidget.$$$reportNull$$$0(10);
        }
        if ((line = this.getTerminalTextBuffer().getLine(lineNumber)) == null) {
            LOG.error("No line found");
            return null;
        }
        TerminalLineIntervalHighlighting highlighting = line.addCustomHighlighting(intervalStartOffset, intervalLength, style);
        this.getTerminalPanel().repaint();
        return highlighting;
    }

    @Nullable
    public ProcessTtyConnector getProcessTtyConnector() {
        return ShellTerminalWidget.getProcessTtyConnector(this.getTtyConnector());
    }

    @Nullable
    public static ProcessTtyConnector getProcessTtyConnector(@Nullable TtyConnector connector) {
        if (connector instanceof ProcessTtyConnector) {
            return (ProcessTtyConnector)connector;
        }
        if (connector instanceof ProxyTtyConnector) {
            return ShellTerminalWidget.getProcessTtyConnector(((ProxyTtyConnector)connector).getConnector());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/ShellTerminalWidget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ttyConnector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/ShellTerminalWidget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedShellCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processTerminalBuffer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeWithTtyConnector";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTtyConnector";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteCommand";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "highlightLineInterval";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Prompt {
        @NotNull
        private volatile String myPrompt = "";
        private final AtomicInteger myTypings = new AtomicInteger(0);
        private TerminalLine myTerminalLine;
        private int myMaxCursorX = -1;

        private Prompt() {
        }

        private void reset() {
            this.myTypings.set(0);
            this.myTerminalLine = null;
            this.myMaxCursorX = -1;
        }

        private void onKeyPressed() {
            TerminalLine terminalLine = ShellTerminalWidget.this.processTerminalBuffer(this::getLineAtCursor);
            if (terminalLine != this.myTerminalLine) {
                this.myTypings.set(0);
                this.myTerminalLine = terminalLine;
                this.myMaxCursorX = -1;
            }
            String prompt = this.getLineTextUpToCursor(terminalLine);
            if (this.myTypings.get() == 0) {
                this.myPrompt = prompt;
                this.myTerminalLine = terminalLine;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Guessed shell prompt: " + this.myPrompt);
                }
            } else if (prompt.startsWith(this.myPrompt)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Guessed prompt confirmed by typing# " + (this.myTypings.get() + 1));
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prompt rejected by typing#" + (this.myTypings.get() + 1) + ", new prompt: " + prompt);
                }
                this.myPrompt = prompt;
                this.myTypings.set(1);
            }
            this.myTypings.incrementAndGet();
        }

        @NotNull
        private String getTypedShellCommand() {
            if (this.myTypings.get() == 0) {
                return "";
            }
            TerminalLine terminalLine = ShellTerminalWidget.this.processTerminalBuffer(this::getLineAtCursor);
            if (terminalLine != this.myTerminalLine) {
                return "";
            }
            String lineTextUpToCursor = this.getLineTextUpToCursor(terminalLine);
            if (lineTextUpToCursor.startsWith(this.myPrompt)) {
                String string = lineTextUpToCursor.substring(this.myPrompt.length());
                if (string == null) {
                    Prompt.$$$reportNull$$$0(0);
                }
                return string;
            }
            return "";
        }

        @NotNull
        private TerminalLine getLineAtCursor(@NotNull TerminalTextBuffer textBuffer) {
            if (textBuffer == null) {
                Prompt.$$$reportNull$$$0(1);
            }
            TerminalLine terminalLine = textBuffer.getLine(ShellTerminalWidget.this.getLineNumberAtCursor());
            if (terminalLine == null) {
                Prompt.$$$reportNull$$$0(2);
            }
            return terminalLine;
        }

        @NotNull
        private String getLineTextUpToCursor(@Nullable TerminalLine line) {
            if (line == null) {
                return "";
            }
            String string = ShellTerminalWidget.this.processTerminalBuffer(textBuffer -> {
                int maxCursorX;
                int cursorX = ShellTerminalWidget.this.getTerminal().getCursorX() - 1;
                String lineStr = line.getText();
                for (maxCursorX = Math.max(this.myMaxCursorX, cursorX); maxCursorX < lineStr.length() && !Character.isWhitespace(lineStr.charAt(maxCursorX)); ++maxCursorX) {
                }
                this.myMaxCursorX = maxCursorX;
                return lineStr.substring(0, Math.min(maxCursorX, lineStr.length()));
            });
            if (string == null) {
                Prompt.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/ShellTerminalWidget$Prompt";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypedShellCommand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/ShellTerminalWidget$Prompt";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineAtCursor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineTextUpToCursor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLineAtCursor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

