/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LayeredIcon;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import icons.DvcsImplIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lgit4idea/ui/branch/BranchIconUtil;", "", "()V", "Companion", "intellij.vcs.git"})
public final class BranchIconUtil {
    private static final Icon INCOMING_LAYERED;
    private static final Icon INCOMING_OUTGOING_LAYERED;
    private static final Icon OUTGOING_LAYERED;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        INCOMING_LAYERED = (Icon)new LayeredIcon(new Icon[]{AllIcons.Vcs.Branch, DvcsImplIcons.IncomingLayer});
        INCOMING_OUTGOING_LAYERED = (Icon)new LayeredIcon(new Icon[]{AllIcons.Vcs.Branch, DvcsImplIcons.IncomingOutgoingLayer});
        OUTGOING_LAYERED = (Icon)new LayeredIcon(new Icon[]{AllIcons.Vcs.Branch, DvcsImplIcons.OutgoingLayer});
    }

    @JvmStatic
    @NotNull
    public static final Icon getBranchIcon(@NotNull GitRepository repository) {
        return Companion.getBranchIcon(repository);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/ui/branch/BranchIconUtil$Companion;", "", "()V", "INCOMING_LAYERED", "Ljavax/swing/Icon;", "INCOMING_OUTGOING_LAYERED", "OUTGOING_LAYERED", "getBranchIcon", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Icon getBranchIcon(@NotNull GitRepository repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            if (repository.getState() != Repository.State.NORMAL) {
                Icon icon = AllIcons.General.Warning;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.General.Warning");
                return icon;
            }
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
            Project project2 = project;
            String currentBranchName = repository.getCurrentBranchName();
            if (repository.getState() == Repository.State.NORMAL && currentBranchName != null) {
                boolean moreThanOneRoot = GitRepositoryManager.getInstance(project2).moreThanOneRoot();
                GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(project2);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
                boolean doNotSyncRepos = gitVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC;
                GitRepository indicatorRepo = moreThanOneRoot && doNotSyncRepos ? repository : null;
                GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(project2);
                Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"GitBranchIncomingOutgoin\u2026ager.getInstance(project)");
                GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
                boolean hasIncoming = incomingOutgoingManager.hasIncomingFor(indicatorRepo, currentBranchName);
                boolean hasOutgoing = incomingOutgoingManager.hasOutgoingFor(indicatorRepo, currentBranchName);
                if (hasIncoming && hasOutgoing) {
                    return INCOMING_OUTGOING_LAYERED;
                }
                if (hasIncoming) {
                    return INCOMING_LAYERED;
                }
                if (hasOutgoing) {
                    return OUTGOING_LAYERED;
                }
            }
            Icon icon = AllIcons.Vcs.Branch;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Vcs.Branch");
            return icon;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

