/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.classMembers;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.VisibilityIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrMemberInfo;

public class GrMemberSelectionTable
extends AbstractMemberSelectionTable<GrMember, GrMemberInfo> {
    public GrMemberSelectionTable(List<GrMemberInfo> memberInfos, @NlsContexts.ColumnName String abstractColumnHeader) {
        this(memberInfos, null, abstractColumnHeader);
    }

    public GrMemberSelectionTable(List<GrMemberInfo> memberInfos, MemberInfoModel<GrMember, GrMemberInfo> memberInfoModel, @NlsContexts.ColumnName String abstractColumnHeader) {
        super(memberInfos, memberInfoModel, abstractColumnHeader);
    }

    @Nullable
    protected Object getAbstractColumnValue(GrMemberInfo memberInfo) {
        Boolean fixedAbstract;
        if (!(memberInfo.getMember() instanceof PsiMethod)) {
            return null;
        }
        if (memberInfo.isStatic()) {
            return null;
        }
        PsiMethod method = (PsiMethod)memberInfo.getMember();
        if (method.hasModifierProperty("abstract") && (fixedAbstract = this.myMemberInfoModel.isFixedAbstract((MemberInfoBase)memberInfo)) != null) {
            return fixedAbstract;
        }
        if (!this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)memberInfo)) {
            return this.myMemberInfoModel.isAbstractWhenDisabled((MemberInfoBase)memberInfo);
        }
        return memberInfo.isToAbstract();
    }

    protected boolean isAbstractColumnEditable(int rowIndex) {
        GrMemberInfo info = (GrMemberInfo)((Object)this.myMemberInfos.get(rowIndex));
        if (!(info.getMember() instanceof PsiMethod)) {
            return false;
        }
        if (info.isStatic()) {
            return false;
        }
        PsiMethod method = (PsiMethod)info.getMember();
        if (method.hasModifierProperty("abstract") && this.myMemberInfoModel.isFixedAbstract((MemberInfoBase)info) != null) {
            return false;
        }
        return info.isChecked() && this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)info);
    }

    protected void setVisibilityIcon(GrMemberInfo memberInfo, RowIcon icon) {
        PsiModifierList modifiers;
        PsiMember member = (PsiMember)memberInfo.getMember();
        PsiModifierList psiModifierList = modifiers = member != null ? member.getModifierList() : null;
        if (modifiers != null) {
            VisibilityIcons.setVisibilityIcon((PsiModifierList)modifiers, (RowIcon)icon);
        } else {
            icon.setIcon(IconUtil.getEmptyIcon((boolean)true), 1);
        }
    }

    protected Icon getOverrideIcon(GrMemberInfo memberInfo) {
        PsiMember member = (PsiMember)memberInfo.getMember();
        Icon overrideIcon = EMPTY_OVERRIDE_ICON;
        if (member instanceof PsiMethod) {
            overrideIcon = Boolean.TRUE.equals(memberInfo.getOverrides()) ? AllIcons.General.OverridingMethod : (Boolean.FALSE.equals(memberInfo.getOverrides()) ? AllIcons.General.ImplementingMethod : EMPTY_OVERRIDE_ICON);
        }
        return overrideIcon;
    }
}

