/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StarImport;

public final class GroovyImportHelper {
    public static boolean isImplicitlyImported(PsiElement element, String expectedName, GroovyFile file) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)element;
        if (!expectedName.equals(psiClass.getName())) {
            return false;
        }
        String qname = psiClass.getQualifiedName();
        if (qname == null) {
            return false;
        }
        for (String importedClass : GroovyFileBase.IMPLICITLY_IMPORTED_CLASSES) {
            if (!qname.equals(importedClass)) continue;
            return true;
        }
        for (String pkg : GroovyImportHelper.getImplicitlyImportedPackages(file)) {
            if (!qname.equals(pkg + "." + expectedName) && (!pkg.isEmpty() || !qname.equals(expectedName))) continue;
            return true;
        }
        return false;
    }

    public static LinkedHashSet<String> getImplicitlyImportedPackages(@NotNull GroovyFile file) {
        if (file == null) {
            GroovyImportHelper.$$$reportNull$$$0(0);
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        ContainerUtil.addAll(result2, (Object[])GroovyFileBase.IMPLICITLY_IMPORTED_PACKAGES);
        GroovyFileImports fileImports = file.getImports();
        for (StarImport starImport : fileImports.getStarImports()) {
            if (!fileImports.isImplicit(starImport)) continue;
            result2.add(starImport.getPackageFqn());
        }
        result2.add(file.getPackageName());
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyImportHelper", "getImplicitlyImportedPackages"));
    }
}

