/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.LazyKt;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.DFAFlowInfo;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InitialTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;
import org.jetbrains.plugins.groovy.util.GraphKt;

final class InferenceCache {
    @NotNull
    private final GrControlFlowOwner myScope;
    private final GroovyControlFlow myFlow;
    private final Map<PsiElement, List<Instruction>> myFromByElements;
    private final Lazy<List<DefinitionMap>> myDefinitionMaps;
    private final AtomicReference<Int2ObjectMap<DFAType>>[] myVarTypes;
    private final Set<Instruction> myTooComplexInstructions;
    private final Lazy<BitSet> simpleInstructions;

    InferenceCache(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            InferenceCache.$$$reportNull$$$0(0);
        }
        this.myTooComplexInstructions = ContainerUtil.newConcurrentSet();
        this.myScope = scope;
        this.myFlow = TypeInferenceHelper.getFlatControlFlow(scope);
        this.myDefinitionMaps = LazyKt.lazyPub(() -> TypeInferenceHelper.getDefUseMaps(this.myFlow));
        this.myFromByElements = Arrays.stream(this.myFlow.getFlow()).filter(it -> it.getElement() != null).collect(Collectors.groupingBy(Instruction::getElement));
        AtomicReference[] basicTypes = new AtomicReference[this.myFlow.getFlow().length];
        for (int i = 0; i < this.myFlow.getFlow().length; ++i) {
            basicTypes[i] = new AtomicReference<Int2ObjectOpenHashMap>(new Int2ObjectOpenHashMap());
        }
        this.myVarTypes = basicTypes;
        this.simpleInstructions = LazyKt.lazyPub(() -> UtilKt.getSimpleInstructions(this.myFlow.getFlow()));
    }

    boolean isTooComplexToAnalyze() {
        return this.myDefinitionMaps.getValue() == null;
    }

    @Nullable
    PsiType getInferredType(int descriptor, @NotNull Instruction instruction, boolean mixinOnly) {
        DFAType dfaType;
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(1);
        }
        if (this.myTooComplexInstructions.contains(instruction)) {
            return null;
        }
        List definitionMaps = (List)this.myDefinitionMaps.getValue();
        if (definitionMaps == null) {
            return null;
        }
        Int2ObjectMap<DFAType> cache2 = this.myVarTypes[instruction.num()].get();
        if (descriptor != 0 && !cache2.containsKey(descriptor)) {
            Predicate<Instruction> mixinPredicate = mixinOnly ? e -> e instanceof MixinTypeInstruction : e -> true;
            DFAFlowInfo flowInfo = this.collectFlowInfo(definitionMaps, instruction, descriptor, mixinPredicate);
            List<TypeDfaState> dfaResult = this.performTypeDfa(this.myScope, this.myFlow, flowInfo);
            if (dfaResult == null) {
                this.myTooComplexInstructions.addAll(flowInfo.getInterestingInstructions());
            } else {
                Set<Instruction> stored = flowInfo.getInterestingInstructions();
                stored.add(instruction);
                this.cacheDfaResult(dfaResult, stored);
            }
        }
        return (dfaType = this.getCachedInferredType(descriptor, instruction)) == null ? null : dfaType.getResultType();
    }

    @Nullable
    private @Nullable List<@Nullable TypeDfaState> performTypeDfa(@NotNull GrControlFlowOwner owner, @NotNull GroovyControlFlow flow, @NotNull DFAFlowInfo flowInfo) {
        if (owner == null) {
            InferenceCache.$$$reportNull$$$0(2);
        }
        if (flow == null) {
            InferenceCache.$$$reportNull$$$0(3);
        }
        if (flowInfo == null) {
            InferenceCache.$$$reportNull$$$0(4);
        }
        TypeDfaInstance dfaInstance = new TypeDfaInstance(flow, flowInfo, this, owner.getManager(), new InitialTypeProvider(owner, this.myFlow.getVarIndices()));
        TypesSemilattice semilattice = new TypesSemilattice(owner.getManager());
        return new DFAEngine<TypeDfaState>(flow.getFlow(), dfaInstance, semilattice).performDFAWithTimeout();
    }

    @Nullable
    DFAType getCachedInferredType(int descriptorId, @NotNull Instruction instruction) {
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(5);
        }
        if (descriptorId == 0) {
            return null;
        }
        return (DFAType)this.myVarTypes[instruction.num()].get().get(descriptorId);
    }

    void publishDescriptor(@NotNull TypeDfaState intermediateState, @NotNull Instruction instruction) {
        if (intermediateState == null) {
            InferenceCache.$$$reportNull$$$0(6);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(7);
        }
        if (((BitSet)this.simpleInstructions.getValue()).get(instruction.num()) && TypeInferenceHelper.getCurrentContext() == TypeInferenceHelper.getTopContext()) {
            this.myVarTypes[instruction.num()].getAndUpdate(oldState -> TypesSemilattice.mergeForCaching((Int2ObjectMap<DFAType>)oldState, intermediateState));
        }
    }

    private DFAFlowInfo collectFlowInfo(@NotNull List<DefinitionMap> definitionMaps, @NotNull Instruction instruction, int descriptorId, @NotNull Predicate<? super Instruction> predicate2) {
        if (definitionMaps == null) {
            InferenceCache.$$$reportNull$$$0(8);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(9);
        }
        if (predicate2 == null) {
            InferenceCache.$$$reportNull$$$0(10);
        }
        LinkedHashMap<Pair, Set<Pair<Instruction, Integer>>> interesting = new LinkedHashMap<Pair, Set<Pair<Instruction, Integer>>>();
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(Pair.create((Object)instruction, (Object)descriptorId));
        HashMap<PsiElement, Collection<ReadWriteVariableInstruction>> scopeCache = new HashMap<PsiElement, Collection<ReadWriteVariableInstruction>>();
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            if (interesting.containsKey(pair)) continue;
            Set<Pair<Instruction, Integer>> dependencies = this.findDependencies(definitionMaps, (Instruction)pair.first, (Integer)pair.second, scopeCache);
            interesting.put(pair, dependencies);
            dependencies.forEach(queue::addLast);
        }
        Set interestingInstructions = interesting.keySet().stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        Set acyclicInstructions = GraphKt.findNodesOutsideCycles(GraphKt.mapGraph(interesting)).stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        Set<Integer> interestingDescriptors = interesting.keySet().stream().map(it -> (Integer)it.getSecond()).collect(Collectors.toSet());
        return new DFAFlowInfo(interestingInstructions, acyclicInstructions, interestingDescriptors);
    }

    @NotNull
    private Set<Pair<Instruction, Integer>> findDependencies(@NotNull List<DefinitionMap> definitionMaps, @NotNull Instruction instruction, int descriptorId, Map<PsiElement, Collection<ReadWriteVariableInstruction>> scopeCache) {
        if (definitionMaps == null) {
            InferenceCache.$$$reportNull$$$0(11);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(12);
        }
        DefinitionMap definitionMap = definitionMaps.get(instruction.num());
        IntSet definitions = definitionMap.getDefinitions(descriptorId);
        LinkedHashSet<Pair<Instruction, Integer>> pairs = new LinkedHashSet<Pair<Instruction, Integer>>();
        if (definitions == null) {
            LinkedHashSet<Pair<Instruction, Integer>> linkedHashSet = pairs;
            if (linkedHashSet == null) {
                InferenceCache.$$$reportNull$$$0(13);
            }
            return linkedHashSet;
        }
        IntIterator intIterator = definitions.iterator();
        while (intIterator.hasNext()) {
            int defIndex = (Integer)intIterator.next();
            Instruction write = this.myFlow.getFlow()[defIndex];
            if (write != instruction) {
                pairs.add((Pair<Instruction, Integer>)Pair.create((Object)write, (Object)descriptorId));
            }
            for (ReadWriteVariableInstruction dependency : UtilKt.findReadDependencies(write, (Function1<? super PsiElement, ? extends Collection<? extends Instruction>>)((Function1)it -> this.myFromByElements.getOrDefault(it, Collections.emptyList())), scopeCache)) {
                pairs.add((Pair<Instruction, Integer>)Pair.create((Object)dependency, (Object)dependency.getDescriptor()));
            }
        }
        LinkedHashSet<Pair<Instruction, Integer>> linkedHashSet = pairs;
        if (linkedHashSet == null) {
            InferenceCache.$$$reportNull$$$0(14);
        }
        return linkedHashSet;
    }

    private void cacheDfaResult(@NotNull List<@Nullable TypeDfaState> dfaResult, Set<Instruction> storingInstructions) {
        if (dfaResult == null) {
            InferenceCache.$$$reportNull$$$0(15);
        }
        for (Instruction instruction : storingInstructions) {
            int index = instruction.num();
            this.myVarTypes[index].getAndUpdate(oldState -> TypesSemilattice.mergeForCaching((Int2ObjectMap<DFAType>)oldState, (TypeDfaState)dfaResult.get(index)));
        }
    }

    public DefinitionMap getDefinitionMaps(int instructionNum) {
        return (DefinitionMap)((List)this.myDefinitionMaps.getValue()).get(instructionNum);
    }

    GroovyControlFlow getGroovyFlow() {
        return this.myFlow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intermediateState";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionMaps";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/InferenceCache";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/InferenceCache";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performTypeDfa";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInferredType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "publishDescriptor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectFlowInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findDependencies";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cacheDfaResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

