/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.lang.jvm.actions.CreateConstantActionGroup;
import com.intellij.lang.jvm.actions.CreateFieldActionGroup;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.JvmActionGroup;
import com.intellij.lang.jvm.actions.JvmGroupIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.util.JavaElementKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldActionBase;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.GroovyFieldRenderer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateFieldAction;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateFieldActionBase;", "Lcom/intellij/lang/jvm/actions/JvmGroupIntentionAction;", "target", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "constantField", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateFieldRequest;Z)V", "getActionGroup", "Lcom/intellij/lang/jvm/actions/JvmActionGroup;", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.groovy"})
public final class CreateFieldAction
extends CreateFieldActionBase
implements JvmGroupIntentionAction {
    private final boolean constantField;

    @NotNull
    public JvmActionGroup getActionGroup() {
        return this.constantField ? (JvmActionGroup)CreateConstantActionGroup.INSTANCE : (JvmActionGroup)CreateFieldActionGroup.INSTANCE;
    }

    @NotNull
    public String getText() {
        String string = this.getRequest().getFieldName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.fieldName");
        String what = string;
        String where = ClassPresentationUtil.getNameForClass((PsiClass)this.getTarget(), (boolean)false);
        JavaElementKind kind = this.constantField ? JavaElementKind.CONSTANT : JavaElementKind.FIELD;
        String string2 = QuickFixBundle.message((String)"create.element.in.class", (Object[])new Object[]{kind.object(), what, where});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"create.element.\u2026.`object`(), what, where)");
        return string2;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        new GroovyFieldRenderer(project, this.constantField, this.getTarget(), this.getRequest()).doRender();
    }

    public CreateFieldAction(@NotNull GrTypeDefinition target, @NotNull CreateFieldRequest request, boolean constantField) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(target, request);
        this.constantField = constantField;
    }
}

