/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.transport;

import org.gradle.internal.impldep.org.eclipse.jgit.lib.Config;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.HMACSHA1NonceGenerator;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.NonceGenerator;

public class SignedPushConfig {
    public static final Config.SectionParser<SignedPushConfig> KEY = SignedPushConfig::new;
    private String certNonceSeed;
    private int certNonceSlopLimit;
    private NonceGenerator nonceGenerator;

    public SignedPushConfig() {
    }

    SignedPushConfig(Config cfg) {
        this.setCertNonceSeed(cfg.getString("receive", null, "certnonceseed"));
        this.certNonceSlopLimit = cfg.getInt("receive", "certnonceslop", 0);
    }

    public void setCertNonceSeed(String seed) {
        this.certNonceSeed = seed;
    }

    public String getCertNonceSeed() {
        return this.certNonceSeed;
    }

    public void setCertNonceSlopLimit(int limit) {
        this.certNonceSlopLimit = limit;
    }

    public int getCertNonceSlopLimit() {
        return this.certNonceSlopLimit;
    }

    public void setNonceGenerator(NonceGenerator generator) {
        this.nonceGenerator = generator;
    }

    public NonceGenerator getNonceGenerator() {
        if (this.nonceGenerator != null) {
            return this.nonceGenerator;
        }
        if (this.certNonceSeed != null) {
            return new HMACSHA1NonceGenerator(this.certNonceSeed);
        }
        return null;
    }
}

