/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePBEProtectionRemoverFactory
implements PBEProtectionRemoverFactory {
    private final char[] passPhrase;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PGPDigestCalculatorProvider calculatorProvider;
    private JcaPGPDigestCalculatorProviderBuilder calculatorProviderBuilder;

    public JcePBEProtectionRemoverFactory(char[] cArray) {
        this.passPhrase = cArray;
        this.calculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    }

    public JcePBEProtectionRemoverFactory(char[] cArray, PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.passPhrase = cArray;
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public JcePBEProtectionRemoverFactory setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(provider);
        }
        return this;
    }

    public JcePBEProtectionRemoverFactory setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(string);
        }
        return this;
    }

    public PBESecretKeyDecryptor createDecryptor(String string) throws PGPException {
        if (this.calculatorProvider == null) {
            this.calculatorProvider = this.calculatorProviderBuilder.build();
        }
        return new PBESecretKeyDecryptor(this.passPhrase, this.calculatorProvider){

            public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws PGPException {
                try {
                    Cipher cipher = JcePBEProtectionRemoverFactory.this.helper.createCipher(PGPUtil.getSymmetricCipherName(n) + "/CBC/NoPadding");
                    cipher.init(2, (Key)JcaJcePGPUtil.makeSymmetricKey(n, byArray), new IvParameterSpec(byArray2));
                    return cipher.doFinal(byArray3, n2, n3);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
                }
                catch (BadPaddingException badPaddingException) {
                    throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new PGPException("invalid parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
                }
            }
        };
    }
}

