/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.obr.xml;

import java.text.ParseException;
import java.util.Iterator;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleCapability;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleInfo;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.ExportPackage;
import org.gradle.internal.impldep.org.apache.ivy.osgi.obr.xml.Capability;
import org.gradle.internal.impldep.org.apache.ivy.osgi.obr.xml.CapabilityProperty;
import org.gradle.internal.impldep.org.apache.ivy.osgi.util.Version;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class CapabilityAdapter {
    public static void adapt(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String name = capability.getName();
        if ("package".equals(name)) {
            ExportPackage exportPackage = CapabilityAdapter.getExportPackage(bundleInfo, capability);
            bundleInfo.addCapability(exportPackage);
        } else if (!"bundle".equals(name)) {
            if ("service".equals(name)) {
                BundleCapability service = CapabilityAdapter.getOSGiService(bundleInfo, capability);
                bundleInfo.addCapability(service);
            } else {
                Message.warn("Unsupported capability '" + name + "' on the bundle '" + bundleInfo.getSymbolicName() + "'");
            }
        }
    }

    private static ExportPackage getExportPackage(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String pkgName = null;
        Version version = null;
        String uses = null;
        Iterator itCapability = capability.getProperties().iterator();
        while (itCapability.hasNext()) {
            CapabilityProperty property = (CapabilityProperty)itCapability.next();
            String propName = property.getName();
            if ("package".equals(propName)) {
                pkgName = property.getValue();
                continue;
            }
            if ("version".equals(propName)) {
                version = new Version(property.getValue());
                continue;
            }
            if ("uses".equals(propName)) {
                uses = property.getValue();
                continue;
            }
            Message.warn("Unsupported property '" + propName + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (pkgName == null) {
            throw new ParseException("No package name for the capability", 0);
        }
        ExportPackage exportPackage = new ExportPackage(pkgName, version);
        if (uses != null) {
            String[] split = uses.trim().split(",");
            for (int i = 0; i < split.length; ++i) {
                String u = split[i];
                exportPackage.addUse(u.trim());
            }
        }
        return exportPackage;
    }

    private static BundleCapability getOSGiService(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String name = null;
        Version version = null;
        Iterator itCapability = capability.getProperties().iterator();
        while (itCapability.hasNext()) {
            CapabilityProperty property = (CapabilityProperty)itCapability.next();
            String propName = property.getName();
            if ("service".equals(propName)) {
                name = property.getValue();
                continue;
            }
            if ("version".equals(propName)) {
                version = new Version(property.getValue());
                continue;
            }
            Message.warn("Unsupported property '" + propName + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (name == null) {
            throw new ParseException("No service name for the capability", 0);
        }
        BundleCapability service = new BundleCapability("service", name, version);
        return service;
    }
}

