/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenModuleDirectoryNode;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J8\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00142\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenTreeStructureProvider;", "Lcom/intellij/ide/projectView/TreeStructureProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getMavenModuleNode", "Lorg/jetbrains/idea/maven/utils/MavenModuleDirectoryNode;", "project", "Lcom/intellij/openapi/project/Project;", "directoryNode", "Lcom/intellij/ide/projectView/impl/nodes/PsiDirectoryNode;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "getModuleShortName", "", "module", "Lcom/intellij/openapi/module/Module;", "isMavenModule", "", "modify", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "parent", "children", "MavenPomFileNode", "intellij.maven"})
public final class MavenTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<? extends AbstractTreeNode<?>> children, @NotNull ViewSettings settings) {
        MavenProjectsManager manager;
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Project project2 = parent.getProject();
        if (project2 == null) {
            return children;
        }
        Project project3 = project2;
        MavenProjectsManager mavenProjectsManager = manager = MavenProjectsManager.getInstance(project3);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        if (!mavenProjectsManager.isMavenizedProject()) {
            return children;
        }
        if (parent instanceof ProjectViewProjectNode || parent instanceof PsiDirectoryNode) {
            Collection modifiedChildren = (Collection)new SmartList();
            Iterator<AbstractTreeNode<?>> iterator = children.iterator();
            while (iterator.hasNext()) {
                AbstractTreeNode child;
                AbstractTreeNode childToAdd = child = iterator.next();
                if (child instanceof PsiFileNode && ((PsiFileNode)child).getVirtualFile() != null) {
                    VirtualFile virtualFile = ((PsiFileNode)child).getVirtualFile();
                    Intrinsics.checkNotNull((Object)virtualFile);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"child.virtualFile!!");
                    if (MavenUtil.isPotentialPomFile(virtualFile.getName())) {
                        VirtualFile virtualFile2 = ((PsiFileNode)child).getVirtualFile();
                        Intrinsics.checkNotNull((Object)virtualFile2);
                        MavenProject mavenProject2 = manager.findProject(virtualFile2);
                        if (mavenProject2 != null) {
                            PsiFile psiFile = (PsiFile)((PsiFileNode)child).getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"child.value");
                            childToAdd = (AbstractTreeNode)new MavenPomFileNode(project3, psiFile, settings, manager.isIgnored(mavenProject2));
                        }
                    }
                }
                if (MavenProjectImporter.Companion.isImportToTreeStructureEnabled(project3) && child instanceof PsiDirectoryNode && parent instanceof PsiDirectoryNode) {
                    MavenModuleDirectoryNode mavenModuleDirectoryNode = this.getMavenModuleNode(project3, (PsiDirectoryNode)child, settings);
                    childToAdd = mavenModuleDirectoryNode != null ? (AbstractTreeNode)mavenModuleDirectoryNode : child;
                }
                modifiedChildren.add(childToAdd);
            }
            return modifiedChildren;
        }
        return children;
    }

    private final MavenModuleDirectoryNode getMavenModuleNode(Project project2, PsiDirectoryNode directoryNode, ViewSettings settings) {
        PsiDirectory psiDirectory = (PsiDirectory)directoryNode.getValue();
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory psiDirectory2 = psiDirectory;
        VirtualFile virtualFile = psiDirectory2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"psiDirectory.virtualFile");
        VirtualFile virtualFile2 = virtualFile;
        if (!ProjectRootsUtil.isModuleContentRoot((VirtualFile)virtualFile2, (Project)project2)) {
            return null;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        Module module = fileIndex.getModuleForFile(virtualFile2);
        if (!this.isMavenModule(module)) {
            return null;
        }
        String string = this.getModuleShortName(module);
        if (string == null) {
            return null;
        }
        String moduleShortName = string;
        return new MavenModuleDirectoryNode(project2, psiDirectory2, settings, moduleShortName, directoryNode.getFilter());
    }

    private final boolean isMavenModule(Module module) {
        return module != null && !module.isDisposed() ? ExternalSystemModulePropertyManager.Companion.getInstance(module).isMavenized() : false;
    }

    private final String getModuleShortName(Module module) {
        if (module != null) {
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
            if (StringsKt.endsWith$default((String)string, (String)".test", (boolean)false, (int)2, null)) {
                return "test";
            }
            String string2 = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"module.name");
            if (StringsKt.endsWith$default((String)string2, (String)".main", (boolean)false, (int)2, null)) {
                return "main";
            }
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenTreeStructureProvider$MavenPomFileNode;", "Lcom/intellij/ide/projectView/impl/nodes/PsiFileNode;", "project", "Lcom/intellij/openapi/project/Project;", "value", "Lcom/intellij/psi/PsiFile;", "viewSettings", "Lcom/intellij/ide/projectView/ViewSettings;", "myIgnored", "", "(Lorg/jetbrains/idea/maven/utils/MavenTreeStructureProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/ide/projectView/ViewSettings;Z)V", "getMyIgnored", "()Z", "strikeAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getStrikeAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "getTestPresentation", "", "updateImpl", "", "data", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.maven"})
    private final class MavenPomFileNode
    extends PsiFileNode {
        @NotNull
        private final SimpleTextAttributes strikeAttributes;
        private final boolean myIgnored;

        @NotNull
        public final SimpleTextAttributes getStrikeAttributes() {
            return this.strikeAttributes;
        }

        protected void updateImpl(@NotNull PresentationData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (this.myIgnored) {
                PsiFile psiFile = (PsiFile)this.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"value");
                data.addText(psiFile.getName(), this.strikeAttributes);
            }
            super.updateImpl(data);
        }

        @NotNull
        public String getTestPresentation() {
            if (this.myIgnored) {
                return "-MavenPomFileNode:" + super.getTestPresentation() + " (ignored)";
            }
            return "-MavenPomFileNode:" + super.getTestPresentation();
        }

        public final boolean getMyIgnored() {
            return this.myIgnored;
        }

        public MavenPomFileNode(@NotNull Project project2, @Nullable PsiFile value, ViewSettings viewSettings, boolean myIgnored) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(project2, value, viewSettings);
            this.myIgnored = myIgnored;
            this.strikeAttributes = new SimpleTextAttributes(4, UIUtil.getInactiveTextColor());
        }
    }
}

