/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

public final class MavenProjectsTree {
    private static final Logger LOG = Logger.getInstance(MavenProjectsTree.class);
    private static final String STORAGE_VERSION = MavenProjectsTree.class.getSimpleName() + ".7";
    private final Object myStateLock;
    private final ReentrantReadWriteLock myStructureLock;
    private final Lock myStructureReadLock;
    private final Lock myStructureWriteLock;
    private volatile Set<String> myManagedFilesPaths;
    private volatile List<String> myIgnoredFilesPaths;
    private volatile List<String> myIgnoredFilesPatterns;
    private volatile Pattern myIgnoredFilesPatternsCache;
    private MavenExplicitProfiles myExplicitProfiles;
    private final MavenExplicitProfiles myTemporarilyRemovedExplicitProfiles;
    private final List<MavenProject> myRootProjects;
    private final Map<MavenProject, MavenProjectTimestamp> myTimestamps;
    private final MavenWorkspaceMap myWorkspaceMap;
    private final Map<MavenId, MavenProject> myMavenIdToProjectMapping;
    private final Map<VirtualFile, MavenProject> myVirtualFileToProjectMapping;
    private final Map<MavenProject, List<MavenProject>> myAggregatorToModuleMapping;
    private final Map<MavenProject, MavenProject> myModuleToAggregatorMapping;
    private final DisposableWrapperList<Listener> myListeners;
    private final Project myProject;
    private final MavenProjectReaderProjectLocator myProjectLocator;

    public MavenProjectsTree(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(0);
        }
        this.myStateLock = new Object();
        this.myStructureLock = new ReentrantReadWriteLock();
        this.myStructureReadLock = this.myStructureLock.readLock();
        this.myStructureWriteLock = this.myStructureLock.writeLock();
        this.myManagedFilesPaths = new LinkedHashSet<String>();
        this.myIgnoredFilesPaths = new ArrayList<String>();
        this.myIgnoredFilesPatterns = new ArrayList<String>();
        this.myExplicitProfiles = MavenExplicitProfiles.NONE;
        this.myTemporarilyRemovedExplicitProfiles = new MavenExplicitProfiles(new HashSet(), new HashSet());
        this.myRootProjects = new ArrayList<MavenProject>();
        this.myTimestamps = new HashMap<MavenProject, MavenProjectTimestamp>();
        this.myWorkspaceMap = new MavenWorkspaceMap();
        this.myMavenIdToProjectMapping = new HashMap<MavenId, MavenProject>();
        this.myVirtualFileToProjectMapping = new HashMap<VirtualFile, MavenProject>();
        this.myAggregatorToModuleMapping = new HashMap<MavenProject, List<MavenProject>>();
        this.myModuleToAggregatorMapping = new HashMap<MavenProject, MavenProject>();
        this.myListeners = new DisposableWrapperList();
        this.myProjectLocator = new MavenProjectReaderProjectLocator(){

            @Override
            public VirtualFile findProjectFile(MavenId coordinates) {
                MavenProject project2 = MavenProjectsTree.this.findProject(coordinates);
                return project2 == null ? null : project2.getFile();
            }
        };
        this.myProject = project2;
    }

    Project getProject() {
        return this.myProject;
    }

    public MavenProjectReaderProjectLocator getProjectLocator() {
        return this.myProjectLocator;
    }

    @Nullable
    public static MavenProjectsTree read(Project project2, Path file) throws IOException {
        DataInputStream in;
        MavenProjectsTree result;
        block9: {
            result = new MavenProjectsTree(project2);
            in = new DataInputStream(new BufferedInputStream(PathKt.inputStream((Path)file)));
            if (STORAGE_VERSION.equals(in.readUTF())) break block9;
            MavenProjectsTree mavenProjectsTree = null;
            in.close();
            return mavenProjectsTree;
        }
        try {
            try {
                result.myManagedFilesPaths = MavenProjectsTree.readCollection(in, new LinkedHashSet());
                result.myIgnoredFilesPaths = MavenProjectsTree.readCollection(in, new ArrayList());
                result.myIgnoredFilesPatterns = MavenProjectsTree.readCollection(in, new ArrayList());
                result.myExplicitProfiles = new MavenExplicitProfiles(MavenProjectsTree.readCollection(in, new HashSet()), MavenProjectsTree.readCollection(in, new HashSet()));
                result.myRootProjects.addAll(MavenProjectsTree.readProjectsRecursively(in, result));
            }
            catch (IOException e) {
                in.close();
                PathKt.delete((Path)file);
                throw e;
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    private static <T extends Collection<String>> T readCollection(DataInputStream in, T result) throws IOException {
        int count = in.readInt();
        while (count-- > 0) {
            result.add((String)in.readUTF());
        }
        return result;
    }

    private static void writeCollection(DataOutputStream out, Collection<String> list) throws IOException {
        out.writeInt(list.size());
        for (String each : list) {
            out.writeUTF(each);
        }
    }

    private static List<MavenProject> readProjectsRecursively(DataInputStream in, MavenProjectsTree tree) throws IOException {
        int count = in.readInt();
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(count);
        while (count-- > 0) {
            MavenProject project2 = MavenProject.read(in);
            MavenProjectTimestamp timestamp = MavenProjectTimestamp.read(in);
            List<MavenProject> modules2 = MavenProjectsTree.readProjectsRecursively(in, tree);
            if (project2 == null) continue;
            result.add(project2);
            tree.myTimestamps.put(project2, timestamp);
            tree.myVirtualFileToProjectMapping.put(project2.getFile(), project2);
            tree.fillIDMaps(project2);
            tree.myAggregatorToModuleMapping.put(project2, modules2);
            for (MavenProject eachModule : modules2) {
                tree.myModuleToAggregatorMapping.put(eachModule, project2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull Path file) throws IOException {
        if (file == null) {
            MavenProjectsTree.$$$reportNull$$$0(1);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.readLock();
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(PathKt.outputStream((Path)file)));){
                out.writeUTF(STORAGE_VERSION);
                MavenProjectsTree.writeCollection(out, this.myManagedFilesPaths);
                MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPaths);
                MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPatterns);
                MavenProjectsTree.writeCollection(out, this.myExplicitProfiles.getEnabledProfiles());
                MavenProjectsTree.writeCollection(out, this.myExplicitProfiles.getDisabledProfiles());
                this.writeProjectsRecursively(out, this.myRootProjects);
            }
            finally {
                this.readUnlock();
            }
        }
    }

    private void writeProjectsRecursively(DataOutputStream out, List<MavenProject> list) throws IOException {
        out.writeInt(list.size());
        for (MavenProject each : list) {
            each.write(out);
            this.myTimestamps.get(each).write(out);
            this.writeProjectsRecursively(out, this.getModules(each));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getManagedFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myManagedFilesPaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetManagedFilesPathsAndProfiles(List<String> paths, MavenExplicitProfiles profiles2) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths = new LinkedHashSet<String>(paths);
        }
        this.setExplicitProfiles(profiles2);
    }

    @TestOnly
    public void resetManagedFilesAndProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles2) {
        this.resetManagedFilesPathsAndProfiles(MavenUtil.collectPaths(files), profiles2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedFilesWithProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles2) {
        MavenExplicitProfiles newProfiles;
        ArrayList<String> newFiles;
        Object object = this.myStateLock;
        synchronized (object) {
            newFiles = new ArrayList<String>(this.myManagedFilesPaths);
            newFiles.addAll(MavenUtil.collectPaths(files));
            newProfiles = this.myExplicitProfiles.clone();
            newProfiles.getEnabledProfiles().addAll(profiles2.getEnabledProfiles());
            newProfiles.getDisabledProfiles().addAll(profiles2.getDisabledProfiles());
        }
        this.resetManagedFilesPathsAndProfiles(newFiles, newProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedFiles(List<VirtualFile> files) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths.removeAll(MavenUtil.collectPaths(files));
        }
    }

    public List<VirtualFile> getExistingManagedFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : this.getManagedFilesPaths()) {
            VirtualFile f = LocalFileSystem.getInstance().findFileByPath(path);
            if (f == null || !f.exists()) continue;
            result.add(f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPaths);
        }
    }

    public void setIgnoredFilesPaths(List<String> paths) {
        this.doChangeIgnoreStatus(() -> {
            this.myIgnoredFilesPaths = new ArrayList<String>(paths);
        });
    }

    public void removeIgnoredFilesPaths(Collection<String> paths) {
        this.doChangeIgnoreStatus(() -> this.myIgnoredFilesPaths.removeAll(paths));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIgnoredState(MavenProject project2) {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(project2.getPath());
        }
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored) {
        this.setIgnoredState(projects, ignored, false);
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored, boolean fromImport) {
        this.doSetIgnoredState(projects, ignored, fromImport);
    }

    private void doSetIgnoredState(List<MavenProject> projects, boolean ignored, boolean fromImport) {
        List<String> paths = MavenUtil.collectPaths(MavenUtil.collectFiles(projects));
        this.doChangeIgnoreStatus(() -> {
            if (ignored) {
                this.myIgnoredFilesPaths.addAll(paths);
            } else {
                this.myIgnoredFilesPaths.removeAll(paths);
            }
        }, fromImport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPatterns() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPatterns);
        }
    }

    public void setIgnoredFilesPatterns(List<String> patterns) {
        this.doChangeIgnoreStatus(() -> {
            this.myIgnoredFilesPatternsCache = null;
            this.myIgnoredFilesPatterns = new ArrayList<String>(patterns);
        });
    }

    private void doChangeIgnoreStatus(Runnable runnable) {
        this.doChangeIgnoreStatus(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeIgnoreStatus(Runnable runnable, boolean fromImport) {
        List<MavenProject> ignoredAfter;
        List<MavenProject> ignoredBefore;
        Object object = this.myStateLock;
        synchronized (object) {
            ignoredBefore = this.getIgnoredProjects();
            runnable.run();
            ignoredAfter = this.getIgnoredProjects();
        }
        ArrayList<MavenProject> ignored = new ArrayList<MavenProject>(ignoredAfter);
        ignored.removeAll(ignoredBefore);
        ArrayList<MavenProject> unignored = new ArrayList<MavenProject>(ignoredBefore);
        unignored.removeAll(ignoredAfter);
        if (ignored.isEmpty() && unignored.isEmpty()) {
            return;
        }
        this.fireProjectsIgnoredStateChanged(ignored, unignored, fromImport);
    }

    private List<MavenProject> getIgnoredProjects() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject each : this.getProjects()) {
            if (!this.isIgnored(each)) continue;
            result.add(each);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnored(MavenProject project2) {
        String path = project2.getPath();
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(path) || this.matchesIgnoredFilesPatterns(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesIgnoredFilesPatterns(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            if (this.myIgnoredFilesPatternsCache == null) {
                this.myIgnoredFilesPatternsCache = Pattern.compile(Strings.translateMasks(this.myIgnoredFilesPatterns));
            }
            return this.myIgnoredFilesPatternsCache.matcher(path).matches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExplicitProfiles getExplicitProfiles() {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myExplicitProfiles.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitProfiles(MavenExplicitProfiles explicitProfiles) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myExplicitProfiles = explicitProfiles.clone();
        }
        this.fireProfilesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExplicitProfiles() {
        Collection<String> available = this.getAvailableProfiles();
        Object object = this.myStateLock;
        synchronized (object) {
            MavenProjectsTree.updateExplicitProfiles(this.myExplicitProfiles.getEnabledProfiles(), this.myTemporarilyRemovedExplicitProfiles.getEnabledProfiles(), available);
            MavenProjectsTree.updateExplicitProfiles(this.myExplicitProfiles.getDisabledProfiles(), this.myTemporarilyRemovedExplicitProfiles.getDisabledProfiles(), available);
        }
    }

    private static void updateExplicitProfiles(Collection<String> explicitProfiles, Collection<String> temporarilyRemovedExplicitProfiles, Collection<String> available) {
        HashSet<String> removedProfiles = new HashSet<String>(explicitProfiles);
        removedProfiles.removeAll(available);
        temporarilyRemovedExplicitProfiles.addAll(removedProfiles);
        HashSet<String> restoredProfiles = new HashSet<String>(temporarilyRemovedExplicitProfiles);
        restoredProfiles.retainAll(available);
        temporarilyRemovedExplicitProfiles.removeAll(restoredProfiles);
        explicitProfiles.removeAll(removedProfiles);
        explicitProfiles.addAll(restoredProfiles);
    }

    public Collection<String> getAvailableProfiles() {
        HashSet<String> res = new HashSet<String>();
        for (MavenProject each : this.getProjects()) {
            res.addAll(each.getProfilesIds());
        }
        return res;
    }

    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        ArrayListSet result = new ArrayListSet();
        HashSet<String> available = new HashSet<String>();
        HashSet active = new HashSet();
        for (MavenProject each : this.getProjects()) {
            available.addAll(each.getProfilesIds());
            active.addAll(each.getActivatedProfilesIds().getEnabledProfiles());
        }
        Collection enabledProfiles = this.getExplicitProfiles().getEnabledProfiles();
        Collection disabledProfiles = this.getExplicitProfiles().getDisabledProfiles();
        for (String each : available) {
            MavenProfileKind state2 = disabledProfiles.contains(each) ? MavenProfileKind.NONE : (enabledProfiles.contains(each) ? MavenProfileKind.EXPLICIT : (active.contains(each) ? MavenProfileKind.IMPLICIT : MavenProfileKind.NONE));
            result.add(Pair.create((Object)each, (Object)state2));
        }
        return result;
    }

    public void updateAll(boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        List<VirtualFile> managedFiles = this.getExistingManagedFiles();
        MavenExplicitProfiles explicitProfiles = this.getExplicitProfiles();
        MavenProjectReader projectReader = new MavenProjectReader(this.myProject);
        this.update(managedFiles, true, force, explicitProfiles, projectReader, generalSettings, process2);
        List<VirtualFile> obsoleteFiles = this.getRootProjectsFiles();
        obsoleteFiles.removeAll(managedFiles);
        this.delete(projectReader, obsoleteFiles, explicitProfiles, generalSettings, process2);
    }

    public void update(Collection<VirtualFile> files, boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        this.update(files, false, force, this.getExplicitProfiles(), new MavenProjectReader(this.myProject), generalSettings, process2);
    }

    private void update(Collection<VirtualFile> files, boolean recursive, boolean force, MavenExplicitProfiles explicitProfiles, MavenProjectReader projectReader, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        if (files.isEmpty()) {
            return;
        }
        UpdateContext updateContext = new UpdateContext();
        Stack updateStack = new Stack();
        for (VirtualFile each : files) {
            MavenProject mavenProject2 = this.findProject(each);
            if (mavenProject2 == null) {
                this.doAdd(each, recursive, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process2);
                continue;
            }
            this.doUpdate(mavenProject2, this.findAggregator(mavenProject2), false, recursive, force, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process2);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary();
    }

    private void doAdd(VirtualFile f, boolean recursuve, MavenExplicitProfiles explicitProfiles, UpdateContext updateContext, Stack<MavenProject> updateStack, MavenProjectReader reader, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        MavenProject newMavenProject = new MavenProject(f);
        MavenProject intendedAggregator = null;
        for (MavenProject each : this.getProjects()) {
            if (!each.getExistingModuleFiles().contains(f)) continue;
            intendedAggregator = each;
            break;
        }
        this.doUpdate(newMavenProject, intendedAggregator, true, recursuve, false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(MavenProject mavenProject2, MavenProject aggregator, boolean isNew, boolean recursive, boolean force, MavenExplicitProfiles explicitProfiles, UpdateContext updateContext, Stack<MavenProject> updateStack, MavenProjectReader reader, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        MavenProjectChanges changes;
        if (updateStack.contains((Object)mavenProject2)) {
            MavenLog.LOG.info("Recursion detected in " + mavenProject2.getFile());
            return;
        }
        updateStack.push((Object)mavenProject2);
        process2.setText(MavenProjectBundle.message("maven.reading.pom", mavenProject2.getPath()));
        process2.setText2("");
        List<MavenProject> prevModules = this.getModules(mavenProject2);
        HashSet<MavenProject> prevInheritors = new HashSet<MavenProject>();
        if (!isNew) {
            prevInheritors.addAll(this.findInheritors(mavenProject2));
        }
        MavenProjectTimestamp timestamp = this.calculateTimestamp(mavenProject2, explicitProfiles, generalSettings);
        boolean isChanged = force || !timestamp.equals(this.myTimestamps.get(mavenProject2));
        MavenProjectChanges mavenProjectChanges = changes = force ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
        if (isChanged) {
            this.writeLock();
            try {
                if (!isNew) {
                    this.clearIDMaps(mavenProject2);
                }
            }
            finally {
                this.writeUnlock();
            }
            MavenId oldParentId = mavenProject2.getParentId();
            changes = changes.mergedWith(mavenProject2.read(generalSettings, explicitProfiles, reader, this.myProjectLocator));
            this.writeLock();
            try {
                this.myVirtualFileToProjectMapping.put(mavenProject2.getFile(), mavenProject2);
                this.fillIDMaps(mavenProject2);
            }
            finally {
                this.writeUnlock();
            }
            if (!Comparing.equal((Object)oldParentId, (Object)mavenProject2.getParentId())) {
                timestamp = this.calculateTimestamp(mavenProject2, explicitProfiles, generalSettings);
            }
            this.myTimestamps.put(mavenProject2, timestamp);
        }
        boolean reconnected = isNew;
        if (isNew) {
            this.connect(aggregator, mavenProject2);
        } else {
            reconnected = this.reconnect(aggregator, mavenProject2);
        }
        if (isChanged || reconnected) {
            updateContext.update(mavenProject2, changes);
        }
        List<VirtualFile> existingModuleFiles = mavenProject2.getExistingModuleFiles();
        ArrayList<MavenProject> modulesToRemove = new ArrayList<MavenProject>();
        ArrayList<MavenProject> modulesToBecomeRoots = new ArrayList<MavenProject>();
        for (MavenProject mavenProject3 : prevModules) {
            VirtualFile moduleFile = mavenProject3.getFile();
            if (existingModuleFiles.contains(moduleFile)) continue;
            if (this.isManagedFile(moduleFile)) {
                modulesToBecomeRoots.add(mavenProject3);
                continue;
            }
            modulesToRemove.add(mavenProject3);
        }
        for (MavenProject mavenProject4 : modulesToRemove) {
            this.removeModule(mavenProject2, mavenProject4);
            this.doDelete(mavenProject2, mavenProject4, updateContext);
            prevInheritors.removeAll(updateContext.deletedProjects);
        }
        for (MavenProject mavenProject5 : modulesToBecomeRoots) {
            if (!this.reconnect(null, mavenProject5)) continue;
            updateContext.update(mavenProject5, MavenProjectChanges.NONE);
        }
        for (VirtualFile virtualFile : existingModuleFiles) {
            boolean isNewModule;
            MavenProject module = this.findProject(virtualFile);
            boolean bl = isNewModule = module == null;
            if (isNewModule) {
                module = new MavenProject(virtualFile);
            } else {
                MavenProject currentAggregator = this.findAggregator(module);
                if (currentAggregator != null && currentAggregator != mavenProject2) {
                    MavenLog.LOG.info("Module " + virtualFile + " is already included into " + mavenProject2.getFile());
                    continue;
                }
            }
            if (isChanged || isNewModule || recursive) {
                this.doUpdate(module, mavenProject2, isNewModule, recursive, recursive && force, explicitProfiles, updateContext, updateStack, reader, generalSettings, process2);
                continue;
            }
            if (!this.reconnect(mavenProject2, module)) continue;
            updateContext.update(module, MavenProjectChanges.NONE);
        }
        prevInheritors.addAll(this.findInheritors(mavenProject2));
        for (MavenProject mavenProject6 : prevInheritors) {
            this.doUpdate(mavenProject6, this.findAggregator(mavenProject6), false, false, false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process2);
        }
        updateStack.pop();
    }

    private MavenProjectTimestamp calculateTimestamp(MavenProject mavenProject2, MavenExplicitProfiles explicitProfiles, MavenGeneralSettings generalSettings) {
        return (MavenProjectTimestamp)ReadAction.compute(() -> {
            long pomTimestamp = MavenProjectsTree.getFileTimestamp(mavenProject2.getFile());
            MavenProject parent = this.findParent(mavenProject2);
            long parentLastReadStamp = parent == null ? -1L : parent.getLastReadStamp();
            VirtualFile profilesXmlFile = mavenProject2.getProfilesXmlFile();
            long profilesTimestamp = MavenProjectsTree.getFileTimestamp(profilesXmlFile);
            VirtualFile jvmConfigFile = MavenUtil.getConfigFile(mavenProject2, "/.mvn/jvm.config");
            long jvmConfigTimestamp = MavenProjectsTree.getFileTimestamp(jvmConfigFile);
            VirtualFile mavenConfigFile = MavenUtil.getConfigFile(mavenProject2, "/.mvn/maven.config");
            long mavenConfigTimestamp = MavenProjectsTree.getFileTimestamp(mavenConfigFile);
            long userSettingsTimestamp = MavenProjectsTree.getFileTimestamp(generalSettings.getEffectiveUserSettingsFile());
            long globalSettingsTimestamp = MavenProjectsTree.getFileTimestamp(generalSettings.getEffectiveGlobalSettingsFile());
            int profilesHashCode = explicitProfiles.hashCode();
            return new MavenProjectTimestamp(pomTimestamp, parentLastReadStamp, profilesTimestamp, userSettingsTimestamp, globalSettingsTimestamp, profilesHashCode, jvmConfigTimestamp, mavenConfigTimestamp);
        });
    }

    public String toString() {
        return "MavenProjectsTree{myRootProjects=" + this.myRootProjects + ", myProject=" + this.myProject + "}";
    }

    private static long getFileTimestamp(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return -1L;
        }
        return file.getTimeStamp();
    }

    public boolean isManagedFile(VirtualFile moduleFile) {
        return this.isManagedFile(moduleFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManagedFile(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            for (String each : this.myManagedFilesPaths) {
                if (!FileUtil.pathsEqual((String)each, (String)path)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isPotentialProject(String path) {
        if (this.isManagedFile(path)) {
            return true;
        }
        for (MavenProject each : this.getProjects()) {
            if (VfsUtilCore.pathEqualsTo((VirtualFile)each.getFile(), (String)path)) {
                return true;
            }
            if (!each.getModulePaths().contains(path)) continue;
            return true;
        }
        return false;
    }

    public void delete(List<VirtualFile> files, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        this.delete(new MavenProjectReader(this.myProject), files, this.getExplicitProfiles(), generalSettings, process2);
    }

    private void delete(MavenProjectReader projectReader, List<VirtualFile> files, MavenExplicitProfiles explicitProfiles, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        if (files.isEmpty()) {
            return;
        }
        UpdateContext updateContext = new UpdateContext();
        Stack updateStack = new Stack();
        HashSet<MavenProject> inheritorsToUpdate = new HashSet<MavenProject>();
        for (VirtualFile virtualFile : files) {
            MavenProject mavenProject2 = this.findProject(virtualFile);
            if (mavenProject2 == null) {
                return;
            }
            inheritorsToUpdate.addAll(this.findInheritors(mavenProject2));
            this.doDelete(this.findAggregator(mavenProject2), mavenProject2, updateContext);
        }
        inheritorsToUpdate.removeAll(updateContext.deletedProjects);
        for (MavenProject mavenProject2 : inheritorsToUpdate) {
            this.doUpdate(mavenProject2, null, false, false, false, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process2);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(MavenProject aggregator, MavenProject project2, UpdateContext updateContext) {
        for (MavenProject each : this.getModules(project2)) {
            if (this.isManagedFile(each.getPath())) {
                if (!this.reconnect(null, each)) continue;
                updateContext.update(each, MavenProjectChanges.NONE);
                continue;
            }
            this.doDelete(project2, each, updateContext);
        }
        this.writeLock();
        try {
            if (aggregator != null) {
                this.removeModule(aggregator, project2);
            } else {
                this.myRootProjects.remove(project2);
            }
            this.myTimestamps.remove(project2);
            this.myVirtualFileToProjectMapping.remove(project2.getFile());
            this.clearIDMaps(project2);
            this.myAggregatorToModuleMapping.remove(project2);
            this.myModuleToAggregatorMapping.remove(project2);
        }
        finally {
            this.writeUnlock();
        }
        updateContext.deleted(project2);
    }

    private void fillIDMaps(MavenProject mavenProject2) {
        MavenId id = mavenProject2.getMavenId();
        this.myWorkspaceMap.register(id, new File(mavenProject2.getFile().getPath()));
        this.myMavenIdToProjectMapping.put(id, mavenProject2);
    }

    private void clearIDMaps(MavenProject mavenProject2) {
        MavenId id = mavenProject2.getMavenId();
        this.myWorkspaceMap.unregister(id);
        this.myMavenIdToProjectMapping.remove(id);
    }

    private void connect(MavenProject newAggregator, MavenProject project2) {
        this.writeLock();
        try {
            if (newAggregator != null) {
                this.addModule(newAggregator, project2);
            } else {
                this.myRootProjects.add(project2);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconnect(MavenProject newAggregator, MavenProject project2) {
        MavenProject prevAggregator = this.findAggregator(project2);
        if (prevAggregator == newAggregator) {
            return false;
        }
        this.writeLock();
        try {
            if (prevAggregator != null) {
                this.removeModule(prevAggregator, project2);
            } else {
                this.myRootProjects.remove(project2);
            }
            if (newAggregator != null) {
                this.addModule(newAggregator, project2);
            } else {
                this.myRootProjects.add(project2);
            }
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    public boolean hasProjects() {
        this.readLock();
        try {
            boolean bl = !this.myRootProjects.isEmpty();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<MavenProject> getRootProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>(this.myRootProjects);
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private static void updateCrc(CRC32 crc, int x) {
        crc.update(x & 0xFF);
        crc.update((x >>>= 8) & 0xFF);
        crc.update((x >>>= 8) & 0xFF);
        crc.update(x >>>= 8);
    }

    private static void updateCrc(CRC32 crc, long l) {
        MavenProjectsTree.updateCrc(crc, (int)l);
        MavenProjectsTree.updateCrc(crc, (int)(l >>> 32));
    }

    private static void updateCrc(CRC32 crc, @Nullable String s) {
        if (s == null) {
            crc.update(111);
        } else {
            MavenProjectsTree.updateCrc(crc, s.hashCode());
            crc.update(s.length() & 0xFF);
        }
    }

    @NotNull
    public static Collection<String> getFilterExclusions(MavenProject mavenProject2) {
        Element config = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (config == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                MavenProjectsTree.$$$reportNull$$$0(2);
            }
            return set;
        }
        List<String> customNonFilteredExtensions = MavenJDOMUtil.findChildrenValuesByPath(config, "nonFilteredFileExtensions", "nonFilteredFileExtension");
        if (customNonFilteredExtensions.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                MavenProjectsTree.$$$reportNull$$$0(3);
            }
            return set;
        }
        List<String> list = Collections.unmodifiableList(customNonFilteredExtensions);
        if (list == null) {
            MavenProjectsTree.$$$reportNull$$$0(4);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilterConfigCrc(@NotNull ProjectFileIndex fileIndex) {
        if (fileIndex == null) {
            MavenProjectsTree.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.readLock();
        try {
            final CRC32 crc = new CRC32();
            MavenExplicitProfiles profiles2 = this.myExplicitProfiles;
            if (profiles2 != null) {
                MavenProjectsTree.updateCrc(crc, profiles2.hashCode());
            }
            Collection<MavenProject> allProjects = this.myVirtualFileToProjectMapping.values();
            crc.update(allProjects.size() & 0xFF);
            for (MavenProject mavenProject2 : allProjects) {
                VirtualFile pomFile = mavenProject2.getFile();
                Module module = fileIndex.getModuleForFile(pomFile);
                if (module == null || !Comparing.equal((Object)fileIndex.getContentRootForFile(pomFile), (Object)pomFile.getParent())) continue;
                MavenProjectsTree.updateCrc(crc, module.getName());
                MavenId mavenId = mavenProject2.getMavenId();
                MavenProjectsTree.updateCrc(crc, mavenId.getGroupId());
                MavenProjectsTree.updateCrc(crc, mavenId.getArtifactId());
                MavenProjectsTree.updateCrc(crc, mavenId.getVersion());
                MavenId parentId = mavenProject2.getParentId();
                if (parentId != null) {
                    MavenProjectsTree.updateCrc(crc, parentId.getGroupId());
                    MavenProjectsTree.updateCrc(crc, parentId.getArtifactId());
                    MavenProjectsTree.updateCrc(crc, parentId.getVersion());
                }
                MavenProjectsTree.updateCrc(crc, mavenProject2.getDirectory());
                MavenProjectsTree.updateCrc(crc, MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject2).pattern());
                MavenProjectsTree.updateCrc(crc, mavenProject2.getModelMap().hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject2.getResources().hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject2.getTestResources().hashCode());
                MavenProjectsTree.updateCrc(crc, MavenProjectsTree.getFilterExclusions(mavenProject2).hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject2.getProperties().hashCode());
                for (String each : mavenProject2.getFilterPropertiesFiles()) {
                    File file = new File(each);
                    MavenProjectsTree.updateCrc(crc, file.lastModified());
                }
                XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
                Writer crcWriter = new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        int end = off + len;
                        for (int i = off; i < end; ++i) {
                            crc.update(cbuf[i]);
                        }
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                    }
                };
                try {
                    Element warPluginCfg;
                    Element resourcePluginCfg = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
                    if (resourcePluginCfg != null) {
                        outputter.output(resourcePluginCfg, crcWriter);
                    }
                    if ((warPluginCfg = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin")) == null) continue;
                    outputter.output(warPluginCfg, crcWriter);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            int n = (int)crc.getValue();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<VirtualFile> getRootProjectsFiles() {
        return MavenUtil.collectFiles(this.getRootProjects());
    }

    public List<MavenProject> getProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>(this.myVirtualFileToProjectMapping.values());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getNonIgnoredProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> result = new ArrayList<MavenProject>();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (this.isIgnored(each)) continue;
                result.add(each);
            }
            ArrayList<MavenProject> arrayList = result;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<VirtualFile> getProjectsFiles() {
        this.readLock();
        try {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myVirtualFileToProjectMapping.keySet());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    @Nullable
    public MavenProject findProject(VirtualFile f) {
        this.readLock();
        try {
            MavenProject mavenProject2 = this.myVirtualFileToProjectMapping.get(f);
            return mavenProject2;
        }
        finally {
            this.readUnlock();
        }
    }

    @Nullable
    public MavenProject findProject(MavenId id) {
        this.readLock();
        try {
            MavenProject mavenProject2 = this.myMavenIdToProjectMapping.get(id);
            return mavenProject2;
        }
        finally {
            this.readUnlock();
        }
    }

    @Nullable
    public MavenProject findProject(MavenArtifact artifact) {
        return this.findProject(artifact.getMavenId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProject findSingleProjectInReactor(MavenId id) {
        this.readLock();
        try {
            List list = this.myMavenIdToProjectMapping.values().stream().filter(it -> StringUtil.equals((CharSequence)it.getMavenId().getArtifactId(), (CharSequence)id.getArtifactId()) && StringUtil.equals((CharSequence)it.getMavenId().getGroupId(), (CharSequence)id.getGroupId())).collect(Collectors.toList());
            MavenProject mavenProject2 = list.size() == 1 ? (MavenProject)list.get(0) : null;
            return mavenProject2;
        }
        finally {
            this.readUnlock();
        }
    }

    MavenWorkspaceMap getWorkspaceMap() {
        this.readLock();
        try {
            MavenWorkspaceMap mavenWorkspaceMap = this.myWorkspaceMap.copy();
            return mavenWorkspaceMap;
        }
        finally {
            this.readUnlock();
        }
    }

    public MavenProject findAggregator(MavenProject project2) {
        this.readLock();
        try {
            MavenProject mavenProject2 = this.myModuleToAggregatorMapping.get(project2);
            return mavenProject2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public MavenProject findRootProject(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(6);
        }
        this.readLock();
        try {
            MavenProject rootProject = project2;
            while (true) {
                MavenProject aggregator;
                if ((aggregator = this.myModuleToAggregatorMapping.get(rootProject)) == null) {
                    MavenProject mavenProject2 = rootProject;
                    MavenProject mavenProject3 = mavenProject2;
                    if (mavenProject3 == null) {
                        MavenProjectsTree.$$$reportNull$$$0(7);
                    }
                    return mavenProject3;
                }
                rootProject = aggregator;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isRootProject(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(8);
        }
        this.readLock();
        try {
            boolean bl = this.myModuleToAggregatorMapping.get(project2) == null;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getModules(MavenProject aggregator) {
        this.readLock();
        try {
            List<MavenProject> modules2 = this.myAggregatorToModuleMapping.get(aggregator);
            ArrayList<MavenProject> arrayList = modules2 == null ? Collections.emptyList() : new ArrayList<MavenProject>(modules2);
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModule(MavenProject aggregator, MavenProject module) {
        this.writeLock();
        try {
            List<MavenProject> modules2 = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules2 == null) {
                modules2 = new ArrayList<MavenProject>();
                this.myAggregatorToModuleMapping.put(aggregator, modules2);
            }
            modules2.add(module);
            this.myModuleToAggregatorMapping.put(module, aggregator);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModule(MavenProject aggregator, MavenProject module) {
        this.writeLock();
        try {
            List<MavenProject> modules2 = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules2 == null) {
                return;
            }
            modules2.remove(module);
            this.myModuleToAggregatorMapping.remove(module);
        }
        finally {
            this.writeUnlock();
        }
    }

    private MavenProject findParent(MavenProject project2) {
        return this.findProject(project2.getParentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MavenProject> findInheritors(MavenProject project2) {
        this.readLock();
        try {
            ArrayList<MavenProject> result = null;
            MavenId id = project2.getMavenId();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (each == project2 || !id.equals((Object)each.getParentId())) continue;
                if (result == null) {
                    result = new ArrayList<MavenProject>();
                }
                result.add(each);
            }
            List<Object> list = result == null ? Collections.emptyList() : result;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getDependentProjects(Collection<MavenProject> projects) {
        this.readLock();
        try {
            ArrayList<MavenProject> result = null;
            ObjectOpenCustomHashSet projectIds = new ObjectOpenCustomHashSet(projects.size(), (Hash.Strategy)new MavenCoordinateHashCodeStrategy());
            for (MavenProject project2 : projects) {
                projectIds.add(project2.getMavenId());
            }
            Set projectPaths = FileCollectionFactory.createCanonicalFileSet();
            for (MavenProject project3 : projects) {
                projectPaths.add(new File(project3.getFile().getPath()));
            }
            for (MavenProject project3 : this.myVirtualFileToProjectMapping.values()) {
                boolean isDependent = false;
                Set<String> pathsInStack = project3.getModulePaths();
                for (String path : pathsInStack) {
                    if (!projectPaths.contains(new File(path))) continue;
                    isDependent = true;
                    break;
                }
                if (!isDependent) {
                    for (MavenArtifact dep : project3.getDependencies()) {
                        if (!projectIds.contains(dep)) continue;
                        isDependent = true;
                        break;
                    }
                }
                if (!isDependent) continue;
                if (result == null) {
                    result = new ArrayList<MavenProject>();
                }
                result.add(project3);
            }
            List<Object> list = result == null ? Collections.emptyList() : result;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public <Result> Result visit(Visitor<Result> visitor) {
        for (MavenProject each : this.getRootProjects()) {
            if (visitor.isDone()) break;
            this.doVisit(each, visitor);
        }
        return visitor.getResult();
    }

    private <Result> void doVisit(MavenProject project2, Visitor<Result> visitor) {
        if (!visitor.isDone() && visitor.shouldVisit(project2)) {
            visitor.visit(project2);
            for (MavenProject each : this.getModules(project2)) {
                if (visitor.isDone()) break;
                this.doVisit(each, visitor);
            }
            visitor.leave(project2);
        }
    }

    private void writeLock() {
        this.myStructureWriteLock.lock();
    }

    private void writeUnlock() {
        this.myStructureWriteLock.unlock();
    }

    private void readLock() {
        this.myStructureReadLock.lock();
    }

    private void readUnlock() {
        this.myStructureReadLock.unlock();
    }

    public void addListener(@NotNull Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            MavenProjectsTree.$$$reportNull$$$0(9);
        }
        if (disposable == null) {
            MavenProjectsTree.$$$reportNull$$$0(10);
        }
        this.myListeners.add((Object)l, disposable);
    }

    void fireProfilesChanged() {
        for (Listener each : this.myListeners) {
            each.profilesChanged();
        }
    }

    void fireProjectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
        if (ignored == null) {
            MavenProjectsTree.$$$reportNull$$$0(11);
        }
        if (unignored == null) {
            MavenProjectsTree.$$$reportNull$$$0(12);
        }
        for (Listener each : this.myListeners) {
            each.projectsIgnoredStateChanged(ignored, unignored, fromImport);
        }
    }

    void fireProjectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
        if (updated == null) {
            MavenProjectsTree.$$$reportNull$$$0(13);
        }
        if (deleted == null) {
            MavenProjectsTree.$$$reportNull$$$0(14);
        }
        for (Listener each : this.myListeners) {
            each.projectsUpdated(updated, deleted);
        }
    }

    void fireProjectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
        if (projectWithChanges == null) {
            MavenProjectsTree.$$$reportNull$$$0(15);
        }
        for (Listener each : this.myListeners) {
            each.projectResolved(projectWithChanges, nativeMavenProject);
        }
    }

    void firePluginsResolved(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(16);
        }
        for (Listener each : this.myListeners) {
            each.pluginsResolved(project2);
        }
    }

    void fireFoldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        if (projectWithChanges == null) {
            MavenProjectsTree.$$$reportNull$$$0(17);
        }
        for (Listener each : this.myListeners) {
            each.foldersResolved(projectWithChanges);
        }
    }

    void fireArtifactsDownloaded(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(18);
        }
        for (Listener each : this.myListeners) {
            each.artifactsDownloaded(project2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsTree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unignored";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updated";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectWithChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsTree";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterExclusions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilterConfigCrc";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRootProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRootProject";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectsIgnoredStateChanged";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectsUpdated";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectResolved";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "firePluginsResolved";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fireFoldersResolved";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fireArtifactsDownloaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class MavenCoordinateHashCodeStrategy
    implements Hash.Strategy<MavenCoordinate> {
        public int hashCode(MavenCoordinate object) {
            String artifactId = object == null ? null : object.getArtifactId();
            return artifactId == null ? 0 : artifactId.hashCode();
        }

        public boolean equals(MavenCoordinate o1, MavenCoordinate o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return Objects.equals(o1.getArtifactId(), o2.getArtifactId()) && Objects.equals(o1.getVersion(), o2.getVersion()) && Objects.equals(o1.getGroupId(), o2.getGroupId());
        }
    }

    public static interface Listener
    extends EventListener {
        default public void profilesChanged() {
        }

        default public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
            if (ignored == null) {
                Listener.$$$reportNull$$$0(0);
            }
            if (unignored == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            if (updated == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (deleted == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        default public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
            if (projectWithChanges == null) {
                Listener.$$$reportNull$$$0(4);
            }
        }

        default public void pluginsResolved(@NotNull MavenProject project2) {
            if (project2 == null) {
                Listener.$$$reportNull$$$0(5);
            }
        }

        default public void foldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
            if (projectWithChanges == null) {
                Listener.$$$reportNull$$$0(6);
            }
        }

        default public void artifactsDownloaded(@NotNull MavenProject project2) {
            if (project2 == null) {
                Listener.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unignored";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updated";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deleted";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectWithChanges";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsTree$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsIgnoredStateChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsUpdated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectResolved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginsResolved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "foldersResolved";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "artifactsDownloaded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MavenProjectTimestamp {
        private final long myPomTimestamp;
        private final long myParentLastReadStamp;
        private final long myProfilesTimestamp;
        private final long myUserSettingsTimestamp;
        private final long myGlobalSettingsTimestamp;
        private final long myExplicitProfilesHashCode;
        private final long myJvmConfigTimestamp;
        private final long myMavenConfigTimestamp;

        private MavenProjectTimestamp(long pomTimestamp, long parentLastReadStamp, long profilesTimestamp, long userSettingsTimestamp, long globalSettingsTimestamp, long explicitProfilesHashCode, long jvmConfigTimestamp, long mavenConfigTimestamp) {
            this.myPomTimestamp = pomTimestamp;
            this.myParentLastReadStamp = parentLastReadStamp;
            this.myProfilesTimestamp = profilesTimestamp;
            this.myUserSettingsTimestamp = userSettingsTimestamp;
            this.myGlobalSettingsTimestamp = globalSettingsTimestamp;
            this.myExplicitProfilesHashCode = explicitProfilesHashCode;
            this.myJvmConfigTimestamp = jvmConfigTimestamp;
            this.myMavenConfigTimestamp = mavenConfigTimestamp;
        }

        public static MavenProjectTimestamp read(DataInputStream in) throws IOException {
            return new MavenProjectTimestamp(in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong());
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeLong(this.myPomTimestamp);
            out.writeLong(this.myParentLastReadStamp);
            out.writeLong(this.myProfilesTimestamp);
            out.writeLong(this.myUserSettingsTimestamp);
            out.writeLong(this.myGlobalSettingsTimestamp);
            out.writeLong(this.myExplicitProfilesHashCode);
            out.writeLong(this.myJvmConfigTimestamp);
            out.writeLong(this.myMavenConfigTimestamp);
        }

        public String toString() {
            return "(" + this.myPomTimestamp + ":" + this.myParentLastReadStamp + ":" + this.myProfilesTimestamp + ":" + this.myUserSettingsTimestamp + ":" + this.myGlobalSettingsTimestamp + ":" + this.myExplicitProfilesHashCode + ":" + this.myJvmConfigTimestamp + ":" + this.myMavenConfigTimestamp + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenProjectTimestamp timestamp = (MavenProjectTimestamp)o;
            if (this.myPomTimestamp != timestamp.myPomTimestamp) {
                return false;
            }
            if (this.myParentLastReadStamp != timestamp.myParentLastReadStamp) {
                return false;
            }
            if (this.myProfilesTimestamp != timestamp.myProfilesTimestamp) {
                return false;
            }
            if (this.myUserSettingsTimestamp != timestamp.myUserSettingsTimestamp) {
                return false;
            }
            if (this.myGlobalSettingsTimestamp != timestamp.myGlobalSettingsTimestamp) {
                return false;
            }
            if (this.myExplicitProfilesHashCode != timestamp.myExplicitProfilesHashCode) {
                return false;
            }
            if (this.myJvmConfigTimestamp != timestamp.myJvmConfigTimestamp) {
                return false;
            }
            return this.myMavenConfigTimestamp == timestamp.myMavenConfigTimestamp;
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (int)(this.myPomTimestamp ^ this.myPomTimestamp >>> 32);
            result = 31 * result + (int)(this.myParentLastReadStamp ^ this.myParentLastReadStamp >>> 32);
            result = 31 * result + (int)(this.myProfilesTimestamp ^ this.myProfilesTimestamp >>> 32);
            result = 31 * result + (int)(this.myUserSettingsTimestamp ^ this.myUserSettingsTimestamp >>> 32);
            result = 31 * result + (int)(this.myGlobalSettingsTimestamp ^ this.myGlobalSettingsTimestamp >>> 32);
            result = 31 * result + (int)(this.myExplicitProfilesHashCode ^ this.myExplicitProfilesHashCode >>> 32);
            result = 31 * result + (int)(this.myJvmConfigTimestamp ^ this.myJvmConfigTimestamp >>> 32);
            result = 31 * result + (int)(this.myMavenConfigTimestamp ^ this.myMavenConfigTimestamp >>> 32);
            return result;
        }
    }

    public static abstract class SimpleVisitor
    extends Visitor<Object> {
    }

    public static abstract class Visitor<Result> {
        private Result result;

        public boolean shouldVisit(MavenProject project2) {
            return true;
        }

        public abstract void visit(MavenProject var1);

        public void leave(MavenProject node2) {
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }

        public boolean isDone() {
            return this.result != null;
        }
    }

    private class UpdateContext {
        public final Map<MavenProject, MavenProjectChanges> updatedProjectsWithChanges = new LinkedHashMap<MavenProject, MavenProjectChanges>();
        public final Set<MavenProject> deletedProjects = new LinkedHashSet<MavenProject>();

        private UpdateContext() {
        }

        public void update(MavenProject project2, MavenProjectChanges changes) {
            this.deletedProjects.remove(project2);
            this.updatedProjectsWithChanges.put(project2, changes.mergedWith(this.updatedProjectsWithChanges.get(project2)));
        }

        public void deleted(MavenProject project2) {
            this.updatedProjectsWithChanges.remove(project2);
            this.deletedProjects.add(project2);
        }

        public void deleted(Collection<MavenProject> projects) {
            for (MavenProject each : projects) {
                this.deleted(each);
            }
        }

        public void fireUpdatedIfNecessary() {
            if (this.updatedProjectsWithChanges.isEmpty() && this.deletedProjects.isEmpty()) {
                return;
            }
            ArrayList<MavenProject> mavenProjects = this.deletedProjects.isEmpty() ? Collections.emptyList() : new ArrayList<MavenProject>(this.deletedProjects);
            List<Pair<MavenProject, MavenProjectChanges>> updated = this.updatedProjectsWithChanges.isEmpty() ? Collections.emptyList() : this.mapToListWithPairs();
            MavenProjectsTree.this.fireProjectsUpdated(updated, mavenProjects);
        }

        @NotNull
        private List<Pair<MavenProject, MavenProjectChanges>> mapToListWithPairs() {
            ArrayList<Pair<MavenProject, MavenProjectChanges>> result = new ArrayList<Pair<MavenProject, MavenProjectChanges>>(this.updatedProjectsWithChanges.size());
            for (Map.Entry<MavenProject, MavenProjectChanges> entry : this.updatedProjectsWithChanges.entrySet()) {
                entry.getKey().getProblems();
                result.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
            }
            ArrayList<Pair<MavenProject, MavenProjectChanges>> arrayList = result;
            if (arrayList == null) {
                UpdateContext.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsTree$UpdateContext", "mapToListWithPairs"));
        }
    }
}

