/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;

public final class MavenArtifactIndex {
    private static final MavenArtifactIndex EMPTY_INDEX = new MavenArtifactIndex(Collections.emptyMap());
    private final Map<String, Map<String, List<MavenArtifact>>> myData;

    private MavenArtifactIndex(Map<String, Map<String, List<MavenArtifact>>> data) {
        this.myData = data;
    }

    public Map<String, Map<String, List<MavenArtifact>>> getData() {
        return this.myData;
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable String groupId, @Nullable String artifactId) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactIndex.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<MavenArtifact> res = groupMap.get(artifactId);
        List<Object> list = res == null ? Collections.emptyList() : res;
        if (list == null) {
            MavenArtifactIndex.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable MavenId mavenId) {
        if (mavenId == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactIndex.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<MavenArtifact> list = this.findArtifacts(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion());
        if (list == null) {
            MavenArtifactIndex.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public MavenArtifact findArtifacts(@NotNull DependencyConflictId id) {
        if (id == null) {
            MavenArtifactIndex.$$$reportNull$$$0(4);
        }
        for (MavenArtifact artifact : this.findArtifacts(id.getGroupId(), id.getArtifactId())) {
            if (!id.equals(DependencyConflictId.create(artifact))) continue;
            return artifact;
        }
        return null;
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable String groupId, @Nullable String artifactId, @Nullable String version2) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactIndex.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<MavenArtifact> artifacts = groupMap.get(artifactId);
        if (artifacts == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactIndex.$$$reportNull$$$0(6);
            }
            return list;
        }
        SmartList res = new SmartList();
        for (MavenArtifact artifact : artifacts) {
            if (!Objects.equals(version2, artifact.getVersion())) continue;
            res.add(artifact);
        }
        SmartList smartList = res;
        if (smartList == null) {
            MavenArtifactIndex.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    public static MavenArtifactIndex build(@NotNull List<? extends MavenArtifact> dependencies) {
        if (dependencies == null) {
            MavenArtifactIndex.$$$reportNull$$$0(8);
        }
        if (dependencies.isEmpty()) {
            return EMPTY_INDEX;
        }
        HashMap<String, Map<String, List<MavenArtifact>>> map2 = new HashMap<String, Map<String, List<MavenArtifact>>>();
        for (MavenArtifact mavenArtifact : dependencies) {
            List artifactList;
            String artifactId;
            String groupId = mavenArtifact.getGroupId();
            if (groupId == null || (artifactId = mavenArtifact.getArtifactId()) == null) continue;
            HashMap<String, List> groupMap = (HashMap<String, List>)map2.get(groupId);
            if (groupMap == null) {
                groupMap = new HashMap<String, List>();
                map2.put(groupId, groupMap);
            }
            if ((artifactList = (List)groupMap.get(artifactId)) == null) {
                artifactList = new SmartList();
                groupMap.put(artifactId, artifactList);
            }
            artifactList.add(mavenArtifact);
        }
        return new MavenArtifactIndex(map2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenArtifactIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifacts";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenArtifactIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findArtifacts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

