/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.util.PairConsumer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class GroovyImporter
extends MavenImporter {
    public GroovyImporter(String pluginGroupID, String pluginArtifactID) {
        super(pluginGroupID, pluginArtifactID);
    }

    @Override
    public void collectSourceRoots(MavenProject mavenProject2, PairConsumer<String, JpsModuleSourceRootType<?>> result) {
        this.collectSourceOrTestFolders(mavenProject2, "compile", "src/main/groovy", JavaSourceRootType.SOURCE, result);
        this.collectSourceOrTestFolders(mavenProject2, "testCompile", "src/test/groovy", JavaSourceRootType.TEST_SOURCE, result);
    }

    private void collectSourceOrTestFolders(MavenProject mavenProject2, String goal, String defaultDir, JavaSourceRootType type2, PairConsumer<String, JpsModuleSourceRootType<?>> result) {
        Element sourcesElement = this.getGoalConfig(mavenProject2, goal);
        List<String> dirs2 = MavenJDOMUtil.findChildrenValuesByPath(sourcesElement, "sources", "fileset.directory");
        if (dirs2.isEmpty()) {
            result.consume((Object)(mavenProject2.getDirectory() + "/" + defaultDir), (Object)type2);
            return;
        }
        for (String dir2 : dirs2) {
            result.consume((Object)dir2, (Object)type2);
        }
    }

    @Override
    public void collectExcludedFolders(MavenProject mavenProject2, List<String> result) {
        String stubsDir = this.findGoalConfigValue(mavenProject2, "generateStubs", "outputDirectory");
        String testStubsDir = this.findGoalConfigValue(mavenProject2, "generateTestStubs", "outputDirectory");
        String defaultStubsDir = mavenProject2.getGeneratedSourcesDirectory(false) + "/groovy-stubs";
        result.add((String)(stubsDir == null ? defaultStubsDir : stubsDir));
        result.add((String)(testStubsDir == null ? defaultStubsDir : testStubsDir));
    }
}

