/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProjectBundle;

public class MavenDuplicateDependenciesInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public MavenDuplicateDependenciesInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<MavenDomProjectModel> domFileElement, DomElementAnnotationHolder holder) {
        MavenDomProjectModel projectModel = (MavenDomProjectModel)domFileElement.getRootElement();
        MavenDuplicateDependenciesInspection.checkManagedDependencies(projectModel, holder);
        MavenDuplicateDependenciesInspection.checkDependencies(projectModel, holder);
    }

    private static void checkDependencies(@NotNull MavenDomProjectModel projectModel, @NotNull DomElementAnnotationHolder holder) {
        if (projectModel == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(1);
        }
        MultiMap<DependencyConflictId, MavenDomDependency> allDuplicates = MavenDuplicateDependenciesInspection.getDuplicateDependenciesMap(projectModel);
        for (MavenDomDependency dependency : projectModel.getDependencies().getDependencies()) {
            Collection dependencies;
            DependencyConflictId id = DependencyConflictId.create(dependency);
            if (id == null || (dependencies = allDuplicates.get((Object)id)).size() <= 1) continue;
            ArrayList<MavenDomDependency> duplicatedDependencies = new ArrayList<MavenDomDependency>();
            for (MavenDomDependency d : dependencies) {
                if (d == dependency) continue;
                if (d.getParent() == dependency.getParent()) {
                    duplicatedDependencies.add(d);
                    continue;
                }
                if (!MavenDuplicateDependenciesInspection.scope(d).equals(MavenDuplicateDependenciesInspection.scope(dependency)) || !Objects.equals(d.getVersion().getStringValue(), dependency.getVersion().getStringValue())) continue;
                duplicatedDependencies.add(d);
            }
            if (duplicatedDependencies.size() <= 0) continue;
            MavenDuplicateDependenciesInspection.addProblem(dependency, duplicatedDependencies, holder);
        }
    }

    private static String scope(MavenDomDependency dependency) {
        String res = dependency.getScope().getRawText();
        if (StringUtil.isEmpty((String)res)) {
            return "compile";
        }
        return res;
    }

    private static void addProblem(@NotNull MavenDomDependency dependency, @NotNull Collection<MavenDomDependency> dependencies, @NotNull DomElementAnnotationHolder holder) {
        if (dependency == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(2);
        }
        if (dependencies == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(4);
        }
        HashSet<MavenDomProjectModel> processed = new HashSet<MavenDomProjectModel>();
        ArrayList<String> links = new ArrayList<String>();
        for (MavenDomDependency domDependency : dependencies) {
            MavenDomProjectModel model2;
            if (dependency.equals(domDependency) || (model2 = (MavenDomProjectModel)domDependency.getParentOfType(MavenDomProjectModel.class, false)) == null || processed.contains(model2)) continue;
            links.add(MavenDuplicateDependenciesInspection.createLinkText(model2, domDependency));
            processed.add(model2);
        }
        links.sort(null);
        holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, MavenDomBundle.message("MavenDuplicateDependenciesInspection.has.duplicates", NlsMessages.formatAndList(links)));
    }

    private static String createLinkText(@NotNull MavenDomProjectModel model2, @NotNull MavenDomDependency dependency) {
        XmlTag tag;
        if (model2 == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(5);
        }
        if (dependency == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(6);
        }
        if ((tag = dependency.getXmlTag()) == null) {
            return MavenDomUtil.getProjectName(model2);
        }
        VirtualFile file = tag.getContainingFile().getVirtualFile();
        if (file == null) {
            return MavenDomUtil.getProjectName(model2);
        }
        return "<a href ='#navigation/" + file.getPath() + ":" + tag.getTextRange().getStartOffset() + "'>" + MavenDomUtil.getProjectName(model2) + "</a>";
    }

    @NotNull
    private static MultiMap<DependencyConflictId, MavenDomDependency> getDuplicateDependenciesMap(MavenDomProjectModel projectModel) {
        MultiMap allDependencies = MultiMap.createSet();
        Processor collectProcessor = model2 -> {
            MavenDuplicateDependenciesInspection.collect((MultiMap<DependencyConflictId, MavenDomDependency>)allDependencies, model2.getDependencies());
            return false;
        };
        MavenDomProjectProcessorUtils.processChildrenRecursively(projectModel, (Processor<? super MavenDomProjectModel>)collectProcessor, true);
        MavenDomProjectProcessorUtils.processParentProjects(projectModel, (Processor<? super MavenDomProjectModel>)collectProcessor);
        MultiMap multiMap = allDependencies;
        if (multiMap == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    private static void collect(MultiMap<DependencyConflictId, MavenDomDependency> duplicates, @NotNull MavenDomDependencies dependencies) {
        if (dependencies == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(8);
        }
        for (MavenDomDependency dependency : dependencies.getDependencies()) {
            DependencyConflictId mavenId = DependencyConflictId.create(dependency);
            if (mavenId == null) continue;
            duplicates.putValue((Object)mavenId, (Object)dependency);
        }
    }

    private static void checkManagedDependencies(@NotNull MavenDomProjectModel projectModel, @NotNull DomElementAnnotationHolder holder) {
        if (projectModel == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(10);
        }
        MultiMap duplicates = MultiMap.createSet();
        MavenDuplicateDependenciesInspection.collect((MultiMap<DependencyConflictId, MavenDomDependency>)duplicates, projectModel.getDependencyManagement().getDependencies());
        for (Map.Entry entry : duplicates.entrySet()) {
            Collection set = (Collection)entry.getValue();
            if (set.size() <= 1) continue;
            for (MavenDomDependency dependency : set) {
                holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, MavenProjectBundle.message("inspection.message.duplicated.dependency", new Object[0]));
            }
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "MavenDuplicateDependenciesInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            MavenDuplicateDependenciesInspection.$$$reportNull$$$0(12);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/inspections/MavenDuplicateDependenciesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/inspections/MavenDuplicateDependenciesInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateDependenciesMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDependencies";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addProblem";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLinkText";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkManagedDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

