/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\nH\u0007J,\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\nH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenConsumerPomUtil;", "", "()V", "getDerivedParentPropertyForConsumerPom", "", "currentPomFile", "Lcom/intellij/psi/xml/XmlFile;", "parentElementArtifactId", "parentElementGroupId", "extractor", "Lkotlin/Function1;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lcom/intellij/util/xml/GenericDomValue;", "getDerivedPropertiesForConsumerPom", "context", "Lcom/intellij/util/xml/ConvertContext;", "getMavenParentElementFromContext", "Lorg/jetbrains/idea/maven/dom/model/MavenDomParent;", "getParentGroupForConsumerPom", "getParentVersionForConsumerPom", "isConsumerPomResolutionApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenConsumerPomUtil {
    @NotNull
    public static final MavenConsumerPomUtil INSTANCE;

    @JvmStatic
    public static final boolean isConsumerPomResolutionApplicable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return Registry.is((String)"maven.consumer.pom.support");
    }

    @JvmStatic
    @Nullable
    public static final String getParentVersionForConsumerPom(@NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return MavenConsumerPomUtil.getDerivedPropertiesForConsumerPom(context, (Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>>)((Function1)getParentVersionForConsumerPom.1.INSTANCE));
    }

    @JvmStatic
    @Nullable
    public static final String getParentGroupForConsumerPom(@NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return MavenConsumerPomUtil.getDerivedPropertiesForConsumerPom(context, (Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>>)((Function1)getParentGroupForConsumerPom.1.INSTANCE));
    }

    @JvmStatic
    @Nullable
    public static final String getDerivedPropertiesForConsumerPom(@NotNull ConvertContext context, @NotNull Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>> extractor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        MavenDomParent mavenDomParent = INSTANCE.getMavenParentElementFromContext(context);
        if (mavenDomParent == null) {
            return null;
        }
        MavenDomParent parentElement = mavenDomParent;
        GenericDomValue genericDomValue = parentElement.getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"parentElement.artifactId");
        String artifactId = (String)genericDomValue.getValue();
        GenericDomValue genericDomValue2 = parentElement.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"parentElement.groupId");
        String groupId = (String)genericDomValue2.getValue();
        if (artifactId == null || groupId == null) {
            return null;
        }
        XmlFile xmlFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"context.file");
        return MavenConsumerPomUtil.getDerivedParentPropertyForConsumerPom(xmlFile, artifactId, groupId, extractor);
    }

    @JvmStatic
    @Nullable
    public static final String getDerivedParentPropertyForConsumerPom(@NotNull XmlFile currentPomFile, @NotNull String parentElementArtifactId, @NotNull String parentElementGroupId, @NotNull Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>> extractor) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)currentPomFile, (String)"currentPomFile");
        Intrinsics.checkNotNullParameter((Object)parentElementArtifactId, (String)"parentElementArtifactId");
        Intrinsics.checkNotNullParameter((Object)parentElementGroupId, (String)"parentElementGroupId");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        PsiDirectory psiDirectory = currentPomFile.getParent();
        if (!((psiDirectory != null && (psiDirectory = psiDirectory.getParent()) != null ? psiDirectory.findFile("pom.xml") : (psiFile = null)) instanceof XmlFile)) {
            psiFile = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            return null;
        }
        XmlFile parentPsi = xmlFile;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomModel((PsiFile)parentPsi, MavenDomProjectModel.class);
        if (mavenDomProjectModel == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"MavenDomUtil.getMavenDom\u2026lass.java) ?: return null");
        MavenDomProjectModel mavenParentDomPsiModel = mavenDomProjectModel;
        GenericDomValue<String> genericDomValue = mavenParentDomPsiModel.getGroupId();
        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"mavenParentDomPsiModel.groupId");
        String string = (String)genericDomValue.getValue();
        if (string == null) {
            MavenDomParent mavenDomParent = mavenParentDomPsiModel.getMavenParent();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomParent, (String)"mavenParentDomPsiModel.mavenParent");
            GenericDomValue genericDomValue2 = mavenDomParent.getGroupId();
            Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"mavenParentDomPsiModel.mavenParent.groupId");
            string = (String)genericDomValue2.getValue();
        }
        String parentRealGroupId = string;
        GenericDomValue<String> genericDomValue3 = mavenParentDomPsiModel.getArtifactId();
        Intrinsics.checkNotNullExpressionValue(genericDomValue3, (String)"mavenParentDomPsiModel.artifactId");
        if (Intrinsics.areEqual((Object)((String)genericDomValue3.getValue()), (Object)parentElementArtifactId) && Intrinsics.areEqual((Object)parentRealGroupId, (Object)parentElementGroupId)) {
            return (String)((GenericDomValue)extractor.invoke((Object)mavenParentDomPsiModel)).getValue();
        }
        return null;
    }

    private final MavenDomParent getMavenParentElementFromContext(ConvertContext context) {
        MavenDomParent mavenDomParent;
        DomElement domElement = context.getInvocationElement();
        Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"context.invocationElement");
        DomElement domElement2 = domElement.getParent();
        if (!(domElement2 instanceof MavenDomParent)) {
            domElement2 = null;
        }
        if ((mavenDomParent = (MavenDomParent)domElement2) != null) {
            return mavenDomParent;
        }
        DomElement domElement3 = context.getInvocationElement();
        Intrinsics.checkNotNullExpressionValue((Object)domElement3, (String)"context.invocationElement");
        DomElement domElement4 = domElement3.getParent();
        if (!(domElement4 instanceof MavenDomProjectModel)) {
            domElement4 = null;
        }
        MavenDomProjectModel mavenDomProjectModel = (MavenDomProjectModel)domElement4;
        return mavenDomProjectModel != null ? mavenDomProjectModel.getMavenParent() : null;
    }

    private MavenConsumerPomUtil() {
    }

    static {
        MavenConsumerPomUtil mavenConsumerPomUtil;
        INSTANCE = mavenConsumerPomUtil = new MavenConsumerPomUtil();
    }
}

