/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.CmdVersionClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

@Service
public final class SvnExecutableChecker
extends ExecutableValidator
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SvnExecutableChecker.class);
    public static final String SVN_EXECUTABLE_LOCALE_REGISTRY_KEY = "svn.executable.locale";
    @NonNls
    private static final String SVN_VERSION_ENGLISH_OUTPUT = "The following repository access (RA) modules are available";
    private static final Pattern INVALID_LOCALE_WARNING_PATTERN = Pattern.compile("^.*cannot set .* locale.*please check that your locale name is correct$", 42);
    @NotNull
    private final SvnVcs myVcs;

    public SvnExecutableChecker(@NotNull Project project) {
        if (project == null) {
            SvnExecutableChecker.$$$reportNull$$$0(0);
        }
        super(project, SvnBundle.message("subversion.executable.notification.title", new Object[0]), SvnBundle.message("subversion.executable.notification.description", new Object[0]), SvnBundle.message("subversion.executable.notification.cant.run.in.safe.mode", new Object[0]));
        this.myVcs = SvnVcs.getInstance(project);
        Registry.get((String)SVN_EXECUTABLE_LOCALE_REGISTRY_KEY).addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                SvnExecutableChecker.this.myVcs.checkCommandLineVersion();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker$1", "afterValueChanged"));
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    protected String getCurrentExecutable() {
        return SvnApplicationSettings.getInstance().getCommandLinePath();
    }

    @NotNull
    protected String getConfigurableDisplayName() {
        String string = SvnConfigurable.getGroupDisplayName();
        if (string == null) {
            SvnExecutableChecker.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected boolean notify(@Nullable Notification notification) {
        this.expireAll();
        return super.notify(notification);
    }

    public void expireAll() {
        for (ExecutableValidator.ExecutableNotValidNotification notification : (ExecutableValidator.ExecutableNotValidNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ExecutableValidator.ExecutableNotValidNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    protected void showSettingsAndExpireIfFixed(@NotNull Notification notification) {
        if (notification == null) {
            SvnExecutableChecker.$$$reportNull$$$0(2);
        }
        this.showSettings();
        notification.expire();
        this.myVcs.checkCommandLineVersion();
    }

    @Nullable
    protected Notification validate(@NotNull String executable) {
        if (executable == null) {
            SvnExecutableChecker.$$$reportNull$$$0(3);
        }
        ExecutableValidator.ExecutableNotValidNotification result = this.createDefaultNotification();
        Version version = this.getConfiguredClientVersion();
        if (version != null) {
            try {
                result = this.validateVersion(version);
                if (result == null) {
                    result = this.validateLocale();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return result;
    }

    @Nullable
    private Notification validateVersion(@NotNull Version version) {
        if (version == null) {
            SvnExecutableChecker.$$$reportNull$$$0(4);
        }
        return !this.myVcs.isSupportedByCommandLine(WorkingCopyFormat.from(version)) ? new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, SvnBundle.message("subversion.executable.too.old", version)) : null;
    }

    @Nullable
    private Notification validateLocale() throws SvnBindException {
        ProcessOutput versionOutput = this.getVersionClient().runCommand(false);
        ExecutableValidator.ExecutableNotValidNotification result = null;
        Matcher matcher = INVALID_LOCALE_WARNING_PATTERN.matcher(versionOutput.getStderr());
        if (matcher.find()) {
            @NlsSafe String warningText = matcher.group();
            LOG.info(warningText);
            result = new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, this.prepareDescription(UIUtil.getHtmlBody((String)warningText), false), NotificationType.WARNING);
        } else if (!SvnExecutableChecker.isEnglishOutput(versionOutput.getStdout())) {
            LOG.info("\"svn --version\" command contains non-English output " + versionOutput.getStdout());
            result = new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, this.prepareDescription(SvnBundle.message("non.english.locale.detected.warning", new Object[0]), false), NotificationType.WARNING);
        }
        return result;
    }

    @Nullable
    private Version getConfiguredClientVersion() {
        Version result = null;
        try {
            result = this.getVersionClient().getVersion();
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        return result;
    }

    @NotNull
    private CmdVersionClient getVersionClient() {
        CmdVersionClient cmdVersionClient = (CmdVersionClient)this.myVcs.getCommandLineFactory().createVersionClient();
        if (cmdVersionClient == null) {
            SvnExecutableChecker.$$$reportNull$$$0(5);
        }
        return cmdVersionClient;
    }

    public static boolean isEnglishOutput(@NotNull String versionOutput) {
        if (versionOutput == null) {
            SvnExecutableChecker.$$$reportNull$$$0(6);
        }
        return StringUtil.containsIgnoreCase((String)versionOutput, (String)SVN_VERSION_ENGLISH_OUTPUT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsAndExpireIfFixed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnglishOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

