/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AllowedItemsResourceStorageBase {
    private static final Logger LOG = Logger.getInstance(AllowedItemsResourceStorageBase.class);
    private final Class<?> resourceHolder;
    private final String relativePath;

    public AllowedItemsResourceStorageBase(@NotNull Class<?> holder, @NotNull String path) {
        if (holder == null) {
            AllowedItemsResourceStorageBase.$$$reportNull$$$0(0);
        }
        if (path == null) {
            AllowedItemsResourceStorageBase.$$$reportNull$$$0(1);
        }
        this.resourceHolder = holder;
        this.relativePath = path;
    }

    @Nullable
    protected String createValue(@NotNull String value) {
        if (value == null) {
            AllowedItemsResourceStorageBase.$$$reportNull$$$0(2);
        }
        return value.trim();
    }

    /*
     * Loose catch block
     */
    @NotNull
    protected Set<String> readItems() {
        block11: {
            BufferedReader reader;
            block10: {
                InputStream resourceStream = this.resourceHolder.getResourceAsStream(this.relativePath);
                if (resourceStream == null) {
                    throw new IOException("Resource " + this.relativePath + " not found");
                }
                reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
                List values = FileUtil.loadLines((BufferedReader)reader);
                if (values.isEmpty()) break block10;
                Set set = ContainerUtil.map2SetNotNull((Collection)values, s -> this.createValue((String)s));
                reader.close();
                Set set2 = set;
                if (set2 == null) {
                    AllowedItemsResourceStorageBase.$$$reportNull$$$0(3);
                }
                return set2;
            }
            try {
                reader.close();
                break block11;
                {
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AllowedItemsResourceStorageBase.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public abstract Set<String> getItems();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/AllowedItemsResourceStorageBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/AllowedItemsResourceStorageBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

